<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page permettant de changer le mot de passe d'un utilisateur
// nécessite tete_pied.php, base_de_donnees.php
// et l'initialisation des strings et des erreurs
function page_preferences($lien_bdd,$message1='', $message2='', $message3='', $message4='') {

    debut_html(PREFERENCES, PREFERENCES);
    
    $jeton = getJeton();
    echo '<div class="formulaire">'."\n";
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="editer_preferences">'."</p>\n";
    
    /**** langue ***/
    echo '<p class="soustitre">'.CHANGER_LANGUE.'</p>';
    $handle = opendir('../../langues');
    while ( $fichier = readdir($handle) )
    if (substr($fichier, strlen($fichier) - 4) === '.php')
        $fichiers_langue[] = basename($fichier, '.php');
    closedir($handle);
    echo '<p>'.LANGUE;
    echo '   <select name="langue">';
    $langue = $_SESSION['langue'];
    echo '<option value="'.$langue.'">'.$langue.'</option>';
    for ( $i = 0; $i < count($fichiers_langue); $i++ )
    {
        $nom = $fichiers_langue[$i];
        if ($nom != $langue)
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo "</select></p>\n";
    
    if ($message1 != '')
        echo $message1;
    echo '<hr>';
    echo '<br>';
    
    /*** mot de passe ***/
    echo '<p class="soustitre">'.CHANGER_MDP.'</p>';
    echo '<p>'.ANCIEN_MDP.' : <input type="password" name="ancienmdp" class="texte" maxlength="15">'."</p>";
    echo '<p>'.NOUVEAU_MDP.' : <input type="password" name="nouveaumdp" class="texte" maxlength="15">'."</p>";
    echo '<p>'.NOUVEAU_MDP_BIS.' : <input type="password" name="nouveaumdpbis" class="texte" maxlength="15">'."</p>";
    
    if ($message2 != '')
        echo $message2;
    echo '<hr>';
    echo '<br>';
    
    /*** email ***/
    echo '<p class="soustitre">'.CHANGER_EMAIL.'</p>';
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    $email = $utilisateur['email'];
    
    echo '<p>'.EMAIL.' : <input type="text" name="email" class="texte" size="30" maxlength="50" value="'.$email.'">'."</p>";
    
    if (isset($_POST['confirmer_email']))
        $valeur = $_POST['confirmer_email'];
    else
        $valeur = '';
    echo '<p>'.CONFIRMER_EMAIL.' : <input type="text" name="confirmer_email" class="texte" size="30" maxlength="50" value="'.$valeur.'">'."</p>\n";
    
    if ($message3 != '')
        echo $message3;
    echo '<hr>';
    echo '<br>';
    
        /**** éditeur ***/
    echo '<p class="soustitre">'.CHANGER_EDITEUR.'</p>';
    echo '<p>'.EDITEUR;
    echo '   <select name="editeur">';
    $editeur = $utilisateur['editeur'];
    if ($editeur == '')
        $editeur = 'Jaxe';
    echo '<option value="'.$editeur.'">'.$editeur.'</option>';
    if ($editeur != 'Jaxe')
        echo '<option value="Jaxe">Jaxe</option>';
    if ($editeur != 'Daxe')
        echo '<option value="Daxe">Daxe</option>';
    echo "</select></p>\n";
    
    if ($message4 != '')
        echo $message4;
    echo '<hr>';
    echo '<br>';
    
    echo '<p><input type="submit" name="modifier" value="'.MODIFIER2.'" class="valider"></p>'."\n";
    echo "</form>\n";
    echo "</div>\n"; // formulaire
    
    fin_html();
}

// action éditer les préférences
function action_editer_preferences($lien_bdd) {
    if (!isset($_POST['langue']) || !isset($_POST['ancienmdp']) || !isset($_POST['nouveaumdp']) || !isset($_POST['nouveaumdpbis']) ||
        !isset($_POST['email']) || !isset($_POST['confirmer_email']) || !isset($_POST['editeur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $msg1 = '';
    $msg2 = '';
    $msg3 = '';
    $msg4 = '';
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    
    if ($_POST['langue'] != $_SESSION['langue'])
        $msg1 = action_changer_langue($lien_bdd);
        
    $ancienmdp = $_POST['ancienmdp'];
    $nouveaumdp = $_POST['nouveaumdp'];
    $nouveaumdpbis = $_POST['nouveaumdpbis'];
    if ($ancienmdp != '' || $nouveaumdp != '' || $nouveaumdpbis != '')
        $msg2 = action_changer_mdp($lien_bdd);
        
    $email = $utilisateur['email'];
    $confirmer_email = $_POST['confirmer_email'];
    if ($_POST['email'] != $email || $confirmer_email != '')
        $msg3 = action_changer_email($lien_bdd);
    
    if ($_POST['editeur'] != $utilisateur['editeur'])
        $msg4 = action_changer_editeur($lien_bdd);
    
    page_preferences($lien_bdd,$msg1, $msg2, $msg3, $msg4);
}

// action changer la langue
function action_changer_langue($lien_bdd) {
    $msg = '';
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $langue_choisie = $_POST['langue'];
    verifie_langue($langue_choisie);
    
    modifier_utilisateur($lien_bdd,$id_utilisateur, false, false, false, false, false, $langue_choisie, false);
    $msg = '<p class="succes">'.LANGUE_MODIFIEE.'</p>';
    
    $_SESSION['langue'] = $langue_choisie;
    //header("Location:index.php?page=preferences");
    return $msg;
}


// action changer le mot de passe d'un utilisateur
function action_changer_mdp($lien_bdd) {
    $msg = '';
    
    password_utilisateur($_POST['ancienmdp']);
    password_utilisateur($_POST['nouveaumdp']);
    password_utilisateur($_POST['nouveaumdpbis']);
    
    $ancienmdp = md5($_POST['ancienmdp']);
    $nouveaumdp = md5($_POST['nouveaumdp']);
    $nouveaumdpbis = md5($_POST['nouveaumdpbis']);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    $motdepasse = $utilisateur['motdepasse'];
    
    if($ancienmdp == $motdepasse && $nouveaumdp == $nouveaumdpbis) {
        modifier_utilisateur($lien_bdd,$id_utilisateur, false, false, false, false, $nouveaumdp, false, false, false);
        $msg = '<p class="succes">'.MDP_MODIFIE.'</p>';
    } else
        $msg = '<p class="erreur">'.MAUVAIS_MDP.'</p>';
    
    return $msg;
    
}

// action changer l'email d'un utilisateur
function action_changer_email($lien_bdd) {
    $msg = '';
    
    $email = $_POST['email'];
    $confirmer_email = $_POST['confirmer_email'];
    
    verifie_email($email);
    verifie_email($confirmer_email);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    if($email == $confirmer_email) {
        modifier_utilisateur($lien_bdd,$id_utilisateur, false, false, false, false, false, false, $email, false);
        $msg = '<p class="succes">'.EMAIL_MODIFIE.'</p>';
    } else
        $msg = '<p class="erreur">'.EMAIL_PAS_IDENTIQUE.'</p>';
    
    return $msg;
    
}

function action_changer_editeur($lien_bdd) {
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $editeur = $_POST['editeur'];
    if ($editeur != 'Jaxe' && $editeur != 'Daxe')
        return '???';
    
    modifier_utilisateur($lien_bdd,$id_utilisateur, false, false, false, false, false, false, false, $editeur);
    
    return '<p class="succes">'.EDITEUR_MODIFIE.'</p>';
}


?>
