<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page permettant de créer ou d'importer une nouvelle contribution
// nécessite tete_pied.php, projets.php, contributions.php, base_de_donnees.php, utilisateurs.php, pclzip.lib.php
// et l'initialisation des strings et des erreurs
function page_nouvelle_contribution($lien_bdd,$message1='', $message2='', $id_proj=false) {

    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    debut_html(NOUVELLE_CONTRIBUTION, NOUVELLE_CONTRIBUTION, '', $id_proj);
    
    $jeton = getJeton();
    
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.TITRE_AJOUTER_CONTRIBUTION.'</p>'."\n";
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="ajouter_contribution">'."</p>\n";
    echo "<p>\n";
    echo NOM_CONTRIBUTION.' <input type="text" name="nom_contribution" class="texte" maxlength="20">'."\n";
    
    echo '<br>'.PROJET.': ';
    echo '<select name="id_projet">';
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur);
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id_projet = $liste_projets[$i]['id'];
            $titre_projet = $liste_projets[$i]['titre'];
            if ($id_proj != false) {
                if ($id_projet == $id_proj)
                    echo '<option value="'.$id_projet.'" selected>'.$titre_projet.'</option>';
                else
                    echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
            }
            else
                echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
        }
    }
    echo '</select> ';
    
    echo '<br>'.CONFIGURATION_JAXE.': ';
    echo '<select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    $fichiers_configuration_jaxe = liste_configs();
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select> ';
    
    echo '<br><input type="submit" name="ajouter" value="'.AJOUTER.'" class="valider">'."\n";
    echo "</p>\n";
    if ($message1 != '')
        echo "<p class=\"erreur\">$message1</p>\n";
    echo "</form>\n";
    echo "</div>\n";
    
    
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.IMPORT_CONTRIBUTION.'</p>'."\n";
    echo '<form method="POST" enctype="multipart/form-data" action="index.php?test=1">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="importer_contribution">'."</p>\n";
    echo "<p>\n";
    echo FICHIER_ZIP.' <input type="file" name="fichier" class="fichier">'."\n";
    
    echo '<br>'.PROJET.': ';
    echo '<select name="id_projet">';
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id_projet = $liste_projets[$i]['id'];
            $titre_projet = $liste_projets[$i]['titre'];
            if ($id_proj != false) {
                if ($id_projet == $id_proj)
                    echo '<option value="'.$id_projet.'" selected>'.$titre_projet.'</option>';
                else
                    echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
            }
            else
                echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
        }
    }
    echo '</select> ';
    
    echo '<br>'.CONFIGURATION_JAXE.': ';
    echo '<select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select> ';
    
    echo '<br><input type="submit" name="importer" value="'.IMPORTER.'" class="valider">'."\n";
    echo "</p>\n";
    if ($message2 != '')
        echo $message2;
    echo "</form>\n";
    echo "</div>\n";
    
    fin_html();
}

function liste_configs() {
    $handle = opendir('../../config');
    while ( $fichier = readdir($handle) )
        if ($fichier != '.' and $fichier != '..' and is_dir('../../config/'.$fichier))
            $fichiers_configuration_jaxe[] = $fichier;
    closedir($handle);
    return($fichiers_configuration_jaxe);
}

// Ajoute une contribution à partir de son nom dans une requête POST
function action_ajouter_contribution($lien_bdd) {
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$_SESSION['id_utilisateur']);
    if ($liste_projets == FALSE)
        erreur(PAS_DE_PROJET);
    if (!isset($_POST['nom_contribution']) || !isset($_POST['config']) || !isset($_POST['id_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    //verifier_l_utilisateur($_SESSION['id_utilisateur']); ne sert à rien
    $nom_contribution = $_POST['nom_contribution'];
    $id_projet = $_POST['id_projet'];
    $config = $_POST['config'];
    
    if ($nom_contribution == "")
        page_nouvelle_contribution($lien_bdd,NOM_CONTRIBUTION_MANQUANT, '', $id_projet);
    else {
        creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config);
        page_liste_contributions($lien_bdd);
    }
}

// import d'une nouvelle contribution à partir d'un zip contenant le dossier de la contribution et du choix de la config
function action_importer_contribution($lien_bdd) {
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$_SESSION['id_utilisateur']);
    if ($liste_projets == FALSE)
        erreur(PAS_DE_PROJET);
    
    if (!isset($_FILES['fichier']) || !isset($_POST['config']) || !isset($_POST['id_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $nom_fichier_tmp = $_FILES['fichier']['tmp_name'];
    $id_projet = $_POST['id_projet'];
    $config = $_POST['config'];
    
    if (!file_exists($nom_fichier_tmp)) {
        page_nouvelle_contribution('', '<p class="erreur">'.ZIP_NON_TROUVE.'</p>', $id_projet);
        return;
    }
    $zip = new PclZip($nom_fichier_tmp);
    if (($list = $zip->listContent()) == 0) {
        page_nouvelle_contribution('', '<p class="erreur">'.CONTENU_ZIP.'</p>', $id_projet);
        return;
    }
    $nom_contribution = '';
    for ($i=0; $i<sizeof($list); $i++) {
        if ($list[$i]['folder'] && substr_count($list[$i]['filename'], '/') <= 1 && substr_count($list[$i]['filename'], '\\') <= 1) {
            $nom_dossier = $list[$i]['filename'];
            $nom_dossier = str_replace('/', '', $nom_dossier);
            $nom_dossier = str_replace('\\', '', $nom_dossier);
            for ($j=0; $j<sizeof($list); $j++) {
                if ($list[$j]['filename'] == $nom_dossier.'/'.$nom_dossier.'.xml' || $list[$j]['filename'] == $nom_dossier.'\\'.$nom_dossier.'.xml')
                    $nom_contribution = $nom_dossier;
            }
        }
    }
    if ($nom_contribution == '') {
        page_nouvelle_contribution('', '<p class="erreur">'.CONTENU_ZIP.'</p>', $id_projet);
        return;
    }
    
    creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config);
    $sep = DIRECTORY_SEPARATOR;
    $racine = realpath(getcwd().$sep.'..'.$sep.'..'.$sep).$sep;
    $contrib_xml = $racine.'contribXML';
    if ($zip->extract(PCLZIP_OPT_PATH, $contrib_xml.$sep.$nom_contribution, PCLZIP_OPT_REMOVE_PATH, $nom_contribution, PCLZIP_CB_PRE_EXTRACT, 'filtre') == 0)
        erreur($zip->errorInfo(true));
    page_nouvelle_contribution('', '<p class="succes">'.CONTRIBUTION_IMPORTEE.'</p>', $id_projet);
}

function filtre($p_event, &$p_header) {
    $info = pathinfo($p_header['filename']);
    $nom = $info['basename'];
    $chemin = $info['dirname'];
    if ($nom == '__MACOSX' || strpos($chemin, '__MACOSX') !== false || $nom == '.DS_Store' || $nom == 'Thumbs.db')
        return(0);
    return(1);
}

?>
