<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page permettant de créer un nouveau projet
// nécessite tete_pied.php, projets.php, base_de_donnees.php
// et l'initialisation des strings et des erreurs
function page_nouveau_projet($message1='', $message2='') {

    debut_html(NOUVEAU_PROJET, NOUVEAU_PROJET);
    
    $jeton = getJeton();
    // formulaire pour ajouter un projet
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.TITRE_AJOUTER_PROJET.'</p>'."\n";
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="ajouter_projet">'."</p>\n";
    echo '<p>'.TITRE_PROJET.' <input type="text" name="titre_projet" class="texte" maxlength="40"></p>';
    echo '<p><input type="submit" name="ajouter" value="'.AJOUTER.'" class="valider"></p>'."\n";
    
    if ($message1 != '')
        echo $message1;
    echo "</form>\n";
    echo "</div>\n"; // formulaire
    
    // import d'un projet
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.IMPORT_PROJET.'</p>'."\n";
    echo '<form method="POST" enctype="multipart/form-data" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="importer_projet">'."</p>\n";
    echo '<p>'.FICHIER_ZIP.' <input type="file" name="fichier" class="fichier">'."</p>";
    
    echo '<p>'.CONFIGURATION_JAXE.': ';
    echo '<select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    $fichiers_configuration_jaxe = liste_configs();
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select></p>';
    
    echo '<p><input type="submit" name="importer" value="'.IMPORTER.'" class="valider">'."</p>\n";
    if ($message2 != '')
        echo $message2;
    echo "</form>\n";
    echo "</div>\n";
    
    fin_html();
}

// Ajoute un projet à partir de son titre dans une requête POST
function action_ajouter_projet($lien_bdd) {
    if (!isset($_POST['titre_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $titre_projet = $_POST['titre_projet'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    if (projet_existe($lien_bdd,$titre_projet))
        erreur(PROJET_EXISTE_DEJA.$titre_projet);
    
    $id_projet = creer_projet($lien_bdd,$titre_projet);
    ajouter_participant($lien_bdd,$id_projet, $id_utilisateur,1);
    page_nouveau_projet('<p class="succes">'.PROJET_CREE.'</p>');
}

// import d'un nouveau projet à partir d'un zip contenant les dossiers des contributions
function action_importer_projet($lien_bdd) {
    if (!isset($_FILES['fichier']) || !isset($_POST['config']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $nom_fichier_tmp = $_FILES['fichier']['tmp_name'];
    $config = $_POST['config'];
    
    importer_projet($lien_bdd,$nom_fichier_tmp, $config);
    page_nouveau_projet('', '<p class="succes">'.PROJET_IMPORTE.'</p>');
}

?>
