<?php
/* récupère la liste des fichiers de la contributuion et l'envoi au plugin Java sous forme xml */

session_start();

if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__)."/../include/contributions.php");
require_once(dirname(__FILE__)."/../include/projets.php");
require_once(dirname(__FILE__)."/../include/utilisateurs.php");
require_once(dirname(__FILE__)."/../include/base_de_donnees.php");
require_once(dirname(__FILE__)."/../include/outils.php");
require_once(dirname(__FILE__)."/../include/verification_noms.php");

init_erreurs_texte();

$_SESSION['section'] = 'utilisateur';

if (!isset($_SESSION['id_utilisateur'])) {
    error_log("Pas de session ouverte");
    erreur(ERREUR_ENREGISTREMENT_SESSION);
}

else {
    if (!isset($_GET['contrib']) ) {
        error_log("l'utilisateur ".$_SESSION['id_utilisateur']." :parametre manquant");
        erreur(PARAMETRES_MANQUANT);
    }
    else {
        $id_utilisateur = $_SESSION['id_utilisateur'];
        $contrib = utf8_decode($_GET['contrib']);
        if ($contrib == '') {
            error_log("l'utilisateur ".$_SESSION['id_utilisateur']." :contribution vide");
            erreur(PARAMETRES_MANQUANT);
        }
        verifie_nom_contribution(false,$contrib);
        verifier_l_utilisateur(false,$id_utilisateur, false, $contrib);
        $chemin_contrib = '../../contribXML/'.$contrib;
        header('Content-Type: application/xml');
        echo '<?xml version="1.0" encoding="ISO-8859-1" ?>'."\n";
        echo '<DOSSIER nom="'.basename($chemin_contrib).'">'."\n";
        lister($chemin_contrib);
    } 
}

function xmlspecialchars($text) {
    return str_replace('&#039;', '&apos;', htmlspecialchars($text, ENT_QUOTES));
}

// liste les dossiers et fichiers d'un répertoire
function lister($chemin_contrib) {   
    $nom_repertoire = $chemin_contrib;
 
    if ($nom_repertoire[strlen($nom_repertoire)-1] != "/")
        $nom_repertoire .= "/"; 
        
    $dir = opendir($nom_repertoire);
    $liste = array();
    // scandir serait plus simple mais nécessite PHP5
    if ($dir) {
        while (false !== ($f = readdir($dir))) {
            $liste[] = $f;
        }
        sort($liste);
    }
    closedir($dir);
    for ($i=0; $i<count($liste); $i++) {
        $f = $liste[$i];
        if (is_file($nom_repertoire.$f) && $f != $_GET['contrib'].".xml") {
            echo '    <FICHIER nom="'.xmlspecialchars($f).'"/>'."\n";
        }
        if (is_dir($nom_repertoire.$f) && $f!=".." && $f!="." ) {
            echo '    <DOSSIER nom="'.xmlspecialchars($f).'">'."\n";
            lister($nom_repertoire.$f);
            echo "    </DOSSIER>\n";
        }
    }
}
echo "</DOSSIER>\n";
?>
