<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche l'historique d'une contribution, à partir de son id
// nécessite tete_pied.php, contributions.php, utilisateurs.php, Diff.php, Renderer.php, inline.php
// et l'initialisation des strings et des erreurs
function page_historique($lien_bdd,$id_contribution, $rep_date='', $repertoire='') {

    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    
    debut_html(HISTORIQUE, TITRE_EDITER_CONTRIBUTION);
    
    echo '<h2>'.$nom_contribution."</h2>\n";
    if ($repertoire == '') {
        if ($rep_date == '')
            $chemin = "../../historique/".$nom_contribution;
        else
            $chemin = "../../historique/".$nom_contribution.'/'.$rep_date;
    } else
        $chemin = "../../historique/".$nom_contribution.'/'.$rep_date.'/'.$repertoire;
    
    echo ' <div class="listedefichier">'."\n";
    $chemincourant = '';
    echo '<a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'">';
    echo '<img src="../../design/icones/dossier_ouvert.gif" alt="">'.$nom_contribution."</a>\n";
    if ($rep_date != '') {
        echo '<div class="indentation_fichier">'."\n";
        echo '<a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$rep_date.'">';
        echo '<img src="../../design/icones/dossier_ouvert.gif" alt="">'.date_lisible($rep_date)."</a>\n";
    }
    if ($repertoire != '') {
        $rep = preg_split('#[/]#', $repertoire);
        for ($i=0; $i<count($rep); $i++)
        {
            if ($chemincourant == '')
                $chemincourant = $rep[$i];
            else
                $chemincourant = $chemincourant."/".$rep[$i];
            echo '<div class="indentation_fichier">'."\n";
            echo '<a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$rep_date.'&amp;repertoire='.$chemincourant.'">';
            echo '<img src="../../design/icones/dossier_ouvert.gif" alt="">'.$rep[$i]."</a>\n";
        }
    }
    
    // tri des dossiers historiques de plus récent au plus ancien
    $dossier_h = array();
    if (file_exists($chemin) && $dirhandle = opendir($chemin)) {
        while (false !== ($f = readdir($dirhandle))) {
            if ($f != "." && $f != "..") {
                $dossier_h[] = $f;
            }
        }
    rsort($dossier_h);
    closedir($dirhandle);
    }
    
    for ($i=0; $i<count($dossier_h); $i++) {
        $chemin_dossier = $chemin.DIRECTORY_SEPARATOR.$dossier_h[$i];
        if ($repertoire == '')
            $chemin_dans_contrib = $dossier_h[$i];
        else
            $chemin_dans_contrib = $repertoire.'/'.$dossier_h[$i];
        echo ' <div class="indentation_fichier">'."\n";
        if (is_dir($chemin_dossier)) {
            if ($rep_date == '')
                echo '<a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$chemin_dans_contrib.'">';
            else
                echo '<a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$rep_date.'&amp;repertoire='.$chemin_dans_contrib.'">';
            echo '<img src="../../design/icones/dossier.gif" alt="">';
        } else {
            echo '<a href="../../contribXML/'.$nom_contribution.'/'.$chemin_dans_contrib.'">';
            echo '<img src="../../design/icones/fichier.gif" alt="">';
        }
        
        if (is_dir($chemin_dossier) && $rep_date == '' && strlen($dossier_h[$i]) == 16) {
            $chemin_fichier = $chemin_dossier.DIRECTORY_SEPARATOR.$nom_contribution.'.xml';
            if (file_exists($chemin_fichier))
                $taille = filesize($chemin_fichier);
            else
                $taille = '?';
            if (login_utilisateur_historique($lien_bdd,$id_contribution, $dossier_h[$i]))
                echo date_lisible($dossier_h[$i])."&nbsp; (".$taille." ".OCTETS.") &nbsp; ".PAR." <i>".login_utilisateur_historique($lien_bdd,$id_contribution, $dossier_h[$i])."</i>";
            else 
                echo date_lisible($dossier_h[$i])."&nbsp; (".$taille." ".OCTETS.")";
        }
        else
            echo $dossier_h[$i];
        echo '</a>';
        if (!is_dir($chemin_dossier) && strpos($dossier_h[$i], '.xml') == strlen($dossier_h[$i]) - 4) {
            $repdate_precedent = '';
            $repdate_dernier = '';
            $chemin_contrib = "../../historique/".$nom_contribution;
            $dates = array();
            if ($repdate_dirhandle = opendir($chemin_contrib)) {
                $i = 0;
                while (false !== ($repdate_f = readdir($repdate_dirhandle))) {
                    if ($repdate_f != "." && $repdate_f != ".." && is_dir($chemin_contrib.DIRECTORY_SEPARATOR.$repdate_f)) {
                        if (file_exists($chemin_contrib.DIRECTORY_SEPARATOR.$repdate_f.DIRECTORY_SEPARATOR.$chemin_dans_contrib)) {
                            $dates[$i] = $repdate_f;
                            $i++;
                        }
                    }
                }
                closedir($repdate_dirhandle);
            }
            sort($dates);
            $index_rep_date = array_search($rep_date, $dates);
            if ($index_rep_date !== FALSE) {
                if ($index_rep_date > 0)
                    $repdate_precedent = $dates[$index_rep_date - 1];
                if ($index_rep_date < count($dates) - 1)
                    $repdate_dernier = $dates[count($dates) - 1];
            }
            if ($repdate_precedent != '') {
                echo '<div class="indentation_fichier">'."\n";
                echo '<a href="index.php?page=diff&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$repdate_precedent.'&amp;fichier='.$chemin_dans_contrib.'&amp;avec='.$rep_date.'">';
                echo COMPARER_PRECEDENT."</a>\n";
                echo "</div>\n";
            }
            if ($repdate_dernier != '') {
                echo '<div class="indentation_fichier">'."\n";
                echo '<a href="index.php?page=diff&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$rep_date.'&amp;fichier='.$chemin_dans_contrib.'&amp;avec='.$repdate_dernier.'">';
                echo COMPARER_DERNIER."</a>\n";
                echo "</div>\n";
            }
        }
        echo "</div>\n";
    }
    
    if ($repertoire != '') {
        for ($i=0; $i<count($rep); $i++)
            echo "</div>\n"; // indentation_fichier
    }
    if ($rep_date != '')
        echo "</div>\n"; // indentation_fichier
    
    echo "</div>\n"; // listedefichier
    
    echo '<p><a href="index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" target="_parent">'.RETOUR."</a></p>\n";
    
    fin_html();
}

function date_lisible($s) {
    if (strlen($s) != 16)
        return($s);
    $annee = substr($s, 0, 4);
    $mois = substr($s, 5, 2);
    $jour = substr($s, 8, 2);
    $heures = substr($s, 11, 2);
    $minutes = substr($s, 14, 2);
    return($jour.'/'.$mois.'/'.$annee.' '.$heures.':'.$minutes);
    
}

// affiche la différence entre le fichier donné et la dernière version
function page_diff($lien_bdd,$id_contribution, $rep_date, $chemin_dans_contrib, $avec) {
    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    if (strpos($rep_date, '..') !== FALSE || strpos($chemin_dans_contrib, '..') !== FALSE || strpos($avec, '..') !== FALSE)
        erreur(PAS_AUTORISE);
    
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    
    debut_html(HISTORIQUE, TITRE_EDITER_CONTRIBUTION);
    
    echo '<h2>'.$chemin_dans_contrib."</h2>\n";
    
    $chemin_fichier_1 = "../../historique/".$nom_contribution.'/'.$rep_date.'/'.$chemin_dans_contrib;
    $chemin_fichier_2 = "../../historique/".$nom_contribution.'/'.$avec.'/'.$chemin_dans_contrib;
    if (!file_exists($chemin_fichier_1) || !file_exists($chemin_fichier_2))
        erreur(FICHIER_INTROUVABLE);
    $contenu_1 = file($chemin_fichier_1);
    $contenu_2 = file($chemin_fichier_2);
    
    if (preg_match('/encoding=["\']([^"\']+)["\']/', $contenu_1[0], $res)) {
        $encoding = $res[1];
        foreach ($contenu_1 as $k => $v) {
            if (strcasecmp($encoding,"ISO-8859-1") == 0)
                $contenu_1[$k] = utf8_encode($v);
            else
                $contenu_1[$k] = mb_convert_encoding($v, "UTF-8", $encoding);
        }
        foreach ($contenu_2 as $k => $v) {
            if (strcasecmp($encoding,"ISO-8859-1") == 0)
                $contenu_2[$k] = utf8_encode($v);
            else
                $contenu_2[$k] = mb_convert_encoding($v, "UTF-8", $encoding);
        }
    }
    if (config_contribution($lien_bdd,$id_contribution) == 'XPAGES') {
        $dans_equation = false;
        foreach ($contenu_1 as $k => $v) {
            if ($dans_equation) {
                if (preg_match('#</EQUAT[IONEX]+>#', $v, $res)) {
                    $dans_equation = false;
                    $contenu_1[$k] = preg_replace('#.*</EQUAT[IONEX]+>#', '', $v);
                } else
                    $contenu_1[$k] = '';
            }
            if (preg_match('#<EQUAT[IONEX]+ texte="[^"]*">#', $contenu_1[$k])) {
                $dans_equation = true;
                $contenu_1[$k] = preg_replace('#<EQUAT([IONEX]+) texte="([^"]*)">[^<]*#', '<EQUAT\1 texte="\2">', $contenu_1[$k]);
            }
        }
        $dans_equation = false;
        foreach ($contenu_2 as $k => $v) {
            if ($dans_equation) {
                if (preg_match('#</EQUAT[IONEX]+>#', $v, $res)) {
                    $dans_equation = false;
                    $contenu_2[$k] = preg_replace('#.*</EQUAT[IONEX]+>#', '', $v);
                } else
                    $contenu_2[$k] = '';
            }
            if (preg_match('#<EQUAT[IONEX]+ texte="[^"]*">#', $contenu_2[$k])) {
                $dans_equation = true;
                $contenu_2[$k] = preg_replace('#<EQUAT([IONEX]+) texte="([^"]*)">[^<]*#', '<EQUAT\1 texte="\2">', $contenu_2[$k]);
            }
        }
    }
    $diff = new Text_Diff('auto', array($contenu_1, $contenu_2));
    $renderer = new Text_Diff_Renderer_inline();
    echo "<div class=\"source\">\n";
    echo LIGNES_AJOUTEES.": <font color='green'>".$diff->countAddedLines()."</font><br>";
    echo LIGNES_SUPPRIMEES.": <font color='red'>".$diff->countDeletedLines()."</font><br><br>";
    echo str_replace("\n", "<br>\n", $renderer->render($diff));
    echo "</div>\n";
    
    echo '<p><a href="index.php?page=historique&amp;id_contribution='.$id_contribution.'&amp;rep_date='.$rep_date.'">'.RETOUR."</a></p>\n";
    
    fin_html();
}

?>
