<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();

if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__)."/../include/utilisateurs.php");
require_once(dirname(__FILE__)."/../include/contributions.php");
require_once(dirname(__FILE__)."/../include/projets.php");
require_once(dirname(__FILE__)."/../include/outils.php");
require_once(dirname(__FILE__)."/../include/base_de_donnees.php");
require_once(dirname(__FILE__)."/../include/verification_noms.php");
require_once(dirname(__FILE__)."/../partie_administrateur/maj_bdd.php");
require_once(dirname(__FILE__)."/../installation/creation_bdd.php");

init_erreurs_texte();

$_SESSION['section'] = 'utilisateur';

//sarra add this and to be modified later
$lien_bdd = connexion();
if (!isset($_SESSION['id_utilisateur']))
//    erreur(PAS_DE_SESSION);
// l'erreur peut être causée sur Firefox qui ne transmet pas les cookies de session à l'applet
//   quand "Accepter les cookies tiers" est désactivé (bugzilla #441166)
    $sortie = "erreur\n".ERREUR_ENREGISTREMENT_SESSION;
else {
    if ((!isset($_POST['contrib']) && !isset($_POST['chemin'])) || !isset($_FILES['contenu']))
        $sortie = PARAMETRES_MANQUANT;
    else {
        $id_utilisateur = $_SESSION['id_utilisateur'];
        $sortie = "ok";
        if (isset($_POST['chemin'])) {
            // pour enregistrer un fichier XML autre que nomcontrib/nomcontrib.xml,
            // l'applet passe en paramètre le chemin complet sur le serveur
            $chemin = utf8_decode($_POST['chemin']);
            verifie_nom_fichier_upload(basename($chemin));
            $urlb = $_SERVER['PHP_SELF'];
            $path_parts = pathinfo($urlb);
            $dossier_racine = $path_parts['dirname'];
            $tdr = explode('/', $dossier_racine);
            array_splice($tdr, count($tdr) - 2);
            $dossier_contribXML = implode('/', $tdr).'/contribXML/';
            $pos = strpos($chemin, $dossier_contribXML);
            if ($pos === false || $pos != 0)
                erreur(PAS_AUTORISE);
            $contrib = substr($chemin, strlen($dossier_contribXML));
            $pos = strpos($contrib, '/');
            if ($pos === false)
                erreur(PAS_AUTORISE);
            $contrib = substr($contrib, 0, $pos);
            verifier_l_utilisateur($lien_bdd,$id_utilisateur, false, $contrib);
            $pos = strpos($chemin, '/contribXML/');
            $chemin_fichier = '../..'.substr($chemin, $pos);
            $chemin_du_dossier = dirname($chemin_fichier);
            $pos = strpos(realpath($chemin_du_dossier), realpath("../../contribXML/".$contrib));
            if ($pos === false || $pos != 0)
                erreur(PAS_AUTORISE);
        } else {
            $contrib = utf8_decode($_POST['contrib']);
            if ($contrib == '')	
                erreur(PARAMETRES_MANQUANT);
            verifier_l_utilisateur($lien_bdd,$id_utilisateur, false, $contrib);
            $chemin_fichier = '../../contribXML/'.$contrib.'/'.$contrib.'.xml';
        }
        
        if (is_uploaded_file($_FILES['contenu']['tmp_name'])) {
            //compare les 2 fichiers avant de créer l'historique
            $contenu1 = "";
            $contenu2 = "";
            $fic1 = file($_FILES['contenu']['tmp_name']);
            if (file_exists($chemin_fichier))
                $fic2 = file($chemin_fichier);
            else
                $fic2 = $_FILES['contenu']['tmp_name'];
            for($i=0; $i<count($fic1); $i++)
                $contenu1 .= $fic1[$i];
            for($i=0; $i<count($fic2); $i++) 
                $contenu2 .= $fic2[$i];
                
            copy($_FILES['contenu']['tmp_name'], $chemin_fichier);
    

            // si modif créer l'historique
            if (strnatcasecmp($contenu1, $contenu2) != 0) {
                // historique
                $chemin_dans_contrib = substr($chemin_fichier, strlen('../../contribXML/'.$contrib.'/'));
                if (PHP_VERSION >= 5)
                    date_default_timezone_set('Europe/Paris');
                $dossier_historique = date('Y-m-d\TH_i');
                $chemin_historique = '../../historique/'.$contrib.'/'.$dossier_historique.'/'.$chemin_dans_contrib;
                mkdir_recursif(dirname($chemin_historique));
                copy($chemin_fichier, $chemin_historique);
                
                // insertion dans la table historiques
                $id_contribution = id_contribution($lien_bdd,$contrib);
                requete_creer_historique($lien_bdd,$id_contribution, $id_utilisateur, $dossier_historique);
            }
        } else
            $sortie = "erreur\n".ERREUR_ENREGISTREMENT_FICHIER;
    }
}
header("content-type:text/plain; charset=utf-8");
echo $sortie;

// Création d'un répertoire, et de tous les répertoires parents si nécessaire
// renvoit true (si ça c'est bien passé) ou false
// (l'option recursive de mkdir ne marche pas avec PHP 4)
function mkdir_recursif($dossier) {
    if (strrpos($dossier, '/') == 0) // racine ?
        return(true);
    if (is_dir($dossier))
        return(true);
    if (mkdir_recursif(dirname($dossier)))
        return(mkdir($dossier));
    else
        return(false);
}

?>
