<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page d'une contribution, à partir de son id
// nécessite tete_pied.php, contributions.php, base_de_donnees.php, utilisateurs.php, pclzip.lib.php
// et l'initialisation des strings et des erreurs
function page_edition_contribution($lien_bdd,$id_contribution, $suppression='') {

    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $id_projet = id_projet_contribution($lien_bdd,$id_contribution);
    $id_profile = profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur);
    $_SESSION['id_profile'] = $id_profile;
    debut_html(TITRE_EDITER_CONTRIBUTION, TITRE_EDITER_CONTRIBUTION, '', $id_projet);
    $jeton = getJeton();
    
    echo '<div class="editer">'."\n"; // classe non définie dans le CSS
    echo "<h2>".$nom_contribution."</h2>\n";
    //echo "<b>".OPERATIONS."</b>\n";
    echo '<div>'."\n";
    if($id_profile == 1)
    {
    echo "<div class=\"boitebouton\">";
    echo "<a href=\"index.php?page=cadre_edition_xml&amp;id_contribution=$id_contribution\"";
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    if ($utilisateur['editeur'] == 'Daxe')
        echo " target=\"blank\"";
    echo ">";
    echo "<img src=\"../../design/icones/editer_big.png\" alt=\"".EDITER_FICHIER_XML."\"><br>".EDITER_FICHIER_XML."</a>";
    echo "</div>\n";
    echo "<div class=\"boitebouton\">";
    echo "<a href=\"index.php?page=fichiers_associes&amp;id_contribution=$id_contribution\">";
    echo "<img src=\"../../design/icones/fichier_associes_big.png\" alt=\"".EDITER_FICHIER_ASSOCIES."\"><br>".EDITER_FICHIER_ASSOCIES."</a>";
    echo "</div>\n";
    $config = config_contribution($lien_bdd,$id_contribution);
    $php_config = dirname(__FILE__)."/../../config/".$config."/php/".$config.".php";
    if (file_exists($php_config)) {
        require_once($php_config);
        if (function_exists('types_sites')) 
        {
            $types = types_sites();
            $noms = $types['noms'];
            $titres = $types['titres'];
            foreach ($noms as $nom) 
            {
                echo "<div class=\"boitebouton\">";
                echo "<a href=\"index.php?action=generer_apercu&amp;id_contribution=$id_contribution&amp;type=$nom&amp;jeton=$jeton\" target=\"_blank\">";
                $titre = GENERER_APERCU." '".$titres[$nom]."'";
                echo "<img src=\"../../design/icones/apercu_big.png\" alt=\"".$titre."\"><br>".$titre."</a>";
                echo "</div>\n";
            }
        } 
        else
        {
            echo "<div class=\"boitebouton\">";
            echo "<a href=\"index.php?action=generer_apercu&amp;id_contribution=$id_contribution&amp;jeton=$jeton\" target=\"_blank\">";
            echo "<img src=\"../../design/icones/apercu_big.png\" alt=\"".GENERER_APERCU."\"><br>".GENERER_APERCU."</a>";
            echo "</div>\n";
        }
    }
    
   }
    $dossier_sites = $_SESSION['chemin_dossier_apercu'];
	if (is_file("../../".$dossier_sites."/".$nom_contribution."/index.html")) 
	{
        echo "<div class=\"boitebouton\">";
        echo "<a href=\"../../".$dossier_sites."/".$nom_contribution."/index.html\" target=\"_blank\">";
        echo "<img src=\"../../design/icones/site_big.png\" alt=\"".VOIR_APERCU."\"><br>".VOIR_APERCU."</a>";
        echo "</div>\n";
	}

	
		echo "<div class=\"boitebouton\">";
		echo "<a href=\"index.php?action=exporter&amp;id_contribution=$id_contribution&amp;jeton=$jeton\">";
		echo "<img src=\"../../design/icones/exporter.png\" alt=\"".EXPORTER."\"><br>".EXPORTER_CONTRIBUTION."</a>";
		echo "</div>\n";
	
    if (file_exists("../../historique/".$nom_contribution)) {
        echo "<div class=\"boitebouton\">";
        echo "<a href=\"index.php?page=historique&amp;id_contribution=$id_contribution\">";
        echo "<img src=\"../../design/icones/historique_big.png\" alt=\"".HISTORIQUE."\"><br>".HISTORIQUE."</a>";
        echo "</div>\n";
    }
    echo "</div>\n";
    
    if($id_profile == 1)
    {
		echo '<div class="ensemble_boutons">'."\n";
		if (count(liste_contributeurs($lien_bdd,$id_contribution)) == 1 || $_SESSION['status'] == 'administrateur')
		 {
			echo "<div class=\"boitebouton\">";
			echo "<a href=\"index.php?page=edition_contribution&amp;id_contribution=$id_contribution&amp;suppression=demande\">";
			echo "<img src=\"../../design/icones/poubelle_big.png\" alt=\"".SUPPRIMER."\"><br>".SUPPRIMER_CONTRIBUTION."</a>";
			echo "</div>\n";
		}
    
   
		if (file_exists("../../sites/".$nom_contribution)) {
			echo "<div class=\"boitebouton\">";
			echo "<a href=\"index.php?action=effacer_site&amp;id_contribution=$id_contribution&amp;jeton=$jeton\">";
			echo "<img src=\"../../design/icones/effacer_site.png\" alt=\"".EFFACER_SITE."\"><br>".EFFACER_SITE."</a>";
			echo "</div>\n";
		}
}
    
    if (isset($types)) {
        foreach ($noms as $nom) {
            echo "<div class=\"boitebouton\">";
            echo "<a href=\"index.php?action=exporter_site&amp;id_contribution=$id_contribution&amp;type=$nom&amp;jeton=$jeton\">";
            $titre = EXPORTER_SITE." '".$titres[$nom]."'";
            echo "<img src=\"../../design/icones/exporter_site.png\" alt=\"".$titre."\"><br>".$titre."</a>";
            echo "</div>\n";
        }
    } else 
    {
        echo "<div class=\"boitebouton\">";
        echo "<a href=\"index.php?action=exporter_site&amp;id_contribution=$id_contribution&amp;jeton=$jeton\">";
        echo "<img src=\"../../design/icones/exporter_site.png\" alt=\"".EXPORTER_SITE."\"><br>".EXPORTER_SITE."</a>";
        echo "</div>\n";
    }
    
    if($id_profile == 1)
    {
		
		echo "<div class=\"boitebouton\">";
		echo "<a href=\"index.php?page=renommer_contribution&amp;id_contribution=$id_contribution\">";
		echo "<img src=\"../../design/icones/renommer_contribution.png\" alt=\"".RENOMMER_CONTRIBUTION."\"><br>".RENOMMER_CONTRIBUTION."</a>";
		echo "</div>\n";
	}
    
    if ($suppression == 'demande') {
        echo '<p>'.VRAIMENT_SUPPRIMER_CONTRIBUTION."</p>\n";
        echo "<p><a href=\"index.php?action=supprimer_contribution&amp;id_contribution=$id_contribution&amp;jeton=$jeton\">";
        echo SUPPRIMER.'</a>';
        echo " <a href=\"index.php?page=edition_contribution&amp;id_contribution=$id_contribution\">";
        echo ANNULER."</a></p>\n";
    }
    echo "</div>\n";
    
    //echo "</div>\n";
    
    fin_html();
}


// affiche la page permettant d'éditer une contribution avec Jaxe ou Daxe (cette page contient 2 frames, edition_xml et reload)
// nécessite utilisateurs.php, contributions.php, et l'initialisation des strings et des erreurs
function page_cadre_edition_xml($lien_bdd,$id_contribution, $chemin_fichier_dans_contrib='') {
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);

    
    
    $id_verif = verifier_verrouillage($lien_bdd,$id_contribution);
    if ($id_verif == FALSE) {
        echo '<!DOCTYPE html>'."\n";
        echo "<html>\n";
        echo "<head>\n";
        echo '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">'."\n";
        echo '<link href="../../design/css/style_util.css" rel="stylesheet" type="text/css">'."\n";
        echo "<title>".TITRE_EDITION."</title>\n";
        echo "</head>\n";
        
        if ($utilisateur['editeur'] == 'Daxe') {
            verrouiller_contribution($lien_bdd,$id_contribution);
            $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
            $chemin_fichier_dans_contrib = $nom_contribution.'.xml';
            $debut_url = '';
            $urlb = $_SERVER['PHP_SELF'];
            $path_parts = pathinfo($urlb);
            $dossier_racine = $path_parts['dirname'];
            // pour éviter '../../' dans l'url passée à Daxe, on retire les 2 derniers répertoires du chemin
            $tdr = explode('/', $dossier_racine);
            array_splice($tdr, count($tdr) - 2);
            $dossier_contrib = implode('/', $tdr).'/contribXML';
            // chemin absolu du fichier XML 
            $chemin_fichier = $debut_url.$dossier_contrib.'/'.$nom_contribution.'/'.$chemin_fichier_dans_contrib;
            $config = config_contribution($lien_bdd,$id_contribution);
            $chemin_config = 'config/'.$config.'_config.xml';
            echo "<iframe id=\"frame1\" src=\"../../daxe/daxe.html?file=".urlencode($chemin_fichier)."&amp;config=$chemin_config&amp;save=../php/partie_utilisateur/enregistrer_xml.php\" name=\"zone1\">des frames sont utilisées</iframe>";
        } else {
            if ($chemin_fichier_dans_contrib != '')
                echo "<iframe id=\"frame1\" src=\"index.php?page=edition_xml&amp;id_contribution=".$id_contribution."&amp;fichier=".urlencode($chemin_fichier_dans_contrib)."\" name=\"zone1\">des frames sont utilisées</iframe>";
            else
                echo "<iframe id=\"frame1\" src=\"index.php?page=edition_xml&amp;id_contribution=".$id_contribution."\" name=\"zone1\">des frames sont utilisées</iframe>";
        }
        echo "<iframe id=\"frame2\" src=\"index.php?page=reload&amp;id_contribution=".$id_contribution."\" name=\"zone2\">des frames sont utilisées</iframe>";
        echo "</html>";
    } else {
        $util_ver = utilisateur($lien_bdd,$id_verif);
        debut_html(TITRE_EDITER_CONTRIBUTION, TITRE_EDITER_CONTRIBUTION, 'init_edition()');
        echo '<p>'.CONTRIBUTION_VEROUILLEE." ".$util_ver['prenom'].' '.$util_ver['nom']."</p>\n";
        if ($utilisateur['editeur'] != 'Daxe') {
            // avec Daxe la page est ouverte dans un autre onglet, il faut la fermer
            echo '<p><a href="index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" target="_parent">'.RETOUR."</a></p>\n";
        }
        fin_html();
    }
}


// affiche la frame permettant d'éditer une contribution avec Jaxe
// nécessite tete_pied.php, contributions.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_edition_xml($lien_bdd,$id_contribution, $chemin_fichier_dans_contrib='') 
{
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    if ($chemin_fichier_dans_contrib == '')
        $chemin_fichier_dans_contrib = $nom_contribution.'.xml';
    
    debut_html(TITRE_EDITER_CONTRIBUTION, TITRE_EDITER_CONTRIBUTION, 'init_edition()');
    
    if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443)
        $debut_url = 'https://'.$_SERVER['SERVER_NAME'];
    else
        $debut_url = 'http://'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'];
    $urlb = $_SERVER['PHP_SELF'];
    $path_parts = pathinfo($urlb);
    $dossier_racine = $path_parts['dirname'];
    // pour éviter '../../' dans l'url passée à l'applet, on retire les 2 derniers répertoires du chemin
    $tdr = explode('/', $dossier_racine);
    array_splice($tdr, count($tdr) - 2);
    $dossier_contrib = implode('/', $tdr).'/contribXML';
    // URL du fichier XML 
    $url = $debut_url.$dossier_contrib.'/'.$nom_contribution.'/'.$chemin_fichier_dans_contrib;
    //chemin relatif vers le fichier
    $chemin_fichier = '../../contribXML/'.$nom_contribution.'/'.$chemin_fichier_dans_contrib;
    
    if (is_file($chemin_fichier))
        $nouveau = "non";
    else
        $nouveau = "oui";
    
    verrouiller_contribution($lien_bdd,$id_contribution);
    $config = config_contribution($lien_bdd,$id_contribution);
    echo '<div class="editer">';
    echo EDITION_FICHIER." : ".$chemin_fichier_dans_contrib;
    echo "<br><br><br>\n";
    echo '<p>'.PAS_FERMER_FENETRE."</p>\n";
    echo "<br><br><br>\n";
    echo "<p><a href=\"index.php?page=fichiers_associes&amp;id_contribution=$id_contribution\" target=\"_blank\">";
    echo OUVRIR_FICHIERS_ASSOCIES."</a></p>\n";
    echo "<br><br><br>\n";
    echo '<p><a href="index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" target="_parent">'.RETOUR."</a></p>\n";
    
    // liste des fichiers .jar dans jaxe/lib/plugins
    $liste_plugins = '';
    $repertoire_plugins = '../../jaxe/lib/plugins';
    if ($plugindir = opendir($repertoire_plugins)) {
        while ( ($f = readdir($plugindir)) !== FALSE ) {
            $info = pathinfo($f);
            if (is_file($repertoire_plugins.'/'.$f) && $info['extension'] == 'jar') {
                if ($liste_plugins != '')
                    $liste_plugins .= ',';
                $liste_plugins .= 'jaxe/lib/plugins/'.$f;
            }
        }
        closedir($plugindir);
    } else
        erreur(IMPOSSIBLE_OUVRIR_DOSSIER.' : '.$repertoire_plugins);
    if ($liste_plugins != '')
        $liste_plugins .= ',';
    
    echo '<applet name="jaxe" archive="jaxe/lib/JaxeApplet.jar,'.$liste_plugins.'config/'.$config.'/" code="jaxeapplet.JaxeApplet" codebase="../../"  width="20" height="20">'."\n";
    echo '<param name="config" value="../../config/'.$config.'/'.$config.'_config.xml">'."\n";
    echo '<param name="fichier" value="'.$url.'">'."\n";
    echo '<param name="nouveau" value="'.$nouveau.'">'."\n";
    if ($_SESSION['langue'] == "fr") {
        echo '<param name="dictionnaire" value="../../jaxe/dicos/francais.dico">'."\n";
        echo '<param name="phonetique" value="../../jaxe/dicos/francais.phon">'."\n";
    } else {
        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && $_SERVER['HTTP_ACCEPT_LANGUAGE'] == "en-us") {
            echo '<param name="dictionnaire" value="../../jaxe/dicos/american.dico">'."\n";
            echo '<param name="phonetique" value="../../jaxe/dicos/american.phon">'."\n";
        } else {
            echo '<param name="dictionnaire" value="../../jaxe/dicos/british.dico">'."\n";
            echo '<param name="phonetique" value="../../jaxe/dicos/british.phon">'."\n";
        }
    }
    echo '<param name="enregistrement" value="enregistrer_xml.php">'."\n";
    echo '<param name="codebase_lookup" value="false">'."\n";
    // il y a toujours des requêtes inutiles vers DocumentBuilderFactory malgré codebase_lookup
    // à cause du répertoire de config dans le classpath :
    // il faudrait mettre chaque dossier de config dans un jar pour éviter le problème,
    // ou alors utiliser DocumentBuilderFactory.newInstance(String, ClassLoader) dans Jaxe
    echo PAS_JAVA;
    echo "</applet>\n";
    echo '</div>';
    
    fin_html();
}


// affiche la frame permettant de garder la session ouverte lors de l'édition dans Jaxe
// nécessite contributions.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_reload($lien_bdd,$id_contribution) 
{
    $id_utilisateur =$_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    echo '<!DOCTYPE html>'."\n";
    echo "<html>\n";
    echo "<head>\n";
    echo '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">'."\n";
    echo '<meta http-equiv="Refresh" content="30">'."\n";
    echo "<title>".RELOAD."</title>\n";
    echo "</head>\n";
    $id_verif = verifier_verrouillage($lien_bdd,$id_contribution);
    if ( $id_verif == FALSE )
        mettre_a_jour_verrouillage($lien_bdd,$id_contribution);
    echo "<body>\n";
    echo "</body>\n";
    echo "</html>\n";
}


// Génère l'aperçu et affiche la page index.html résultat, à partir du nom de la contrib dans une requête GET
// nécessite la transfo XSLT PHP, et l'initialisation des strings et des erreurs
function action_generer_apercu($lien_bdd,$type=NULL, $chemin_site=NULL, $tmp_profile =false) 
{
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_GET['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($tmp_profile == false)
    {
		if($id_profile == false)
			erreur(PAS_AUTORISE);
	}

    $config = config_contribution($lien_bdd,$id_contribution);
    $php_config = "../../config/".$config."/php/".$config.".php";
    if (file_exists($php_config))
        require_once($php_config);
    else
        erreur("Le fichier de transformation en PHP n'existe pas pour la config ".$config.".");
    
    $dossier_sites = $_SESSION['chemin_dossier_apercu'];
    $sep = DIRECTORY_SEPARATOR;
    $racine = getcwd().$sep."..".$sep."..".$sep;
    $dossier_contribs = $racine."contribXML";
    $xml_a_traiter = $racine."contribXML".$sep.$nom_contribution.$sep.$nom_contribution.".xml";
    if ($chemin_site != NULL)
        $redirection = NULL; // pas de redirection quand on spécifie le chemin vers le site (pour un export)
    else {
        $chemin_site = $racine.$dossier_sites.$sep.$nom_contribution;
        $redirection = "../../".$dossier_sites."/".$nom_contribution."/index.html";
    }
    $dossier_config = $racine."config".$sep.$config;
    $dossier_temp = $racine."tmp";
    transfo_webjaxe($dossier_contribs, $xml_a_traiter, $chemin_site, $dossier_config, $dossier_temp, $redirection, $type);
}


// Export en zip d'une contribution
function action_exporter($lien_bdd) {
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_contribution = $_GET['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    if ($_SESSION['status'] != "administrateur")
        verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $sep = DIRECTORY_SEPARATOR;
    $racine = realpath(getcwd().$sep.'..'.$sep.'..'.$sep).$sep;
    $dossier_temp = $racine.'tmp';
    $tmpzip = tempnam($dossier_temp, 'tmpzip_'.$nom_contribution);
    $archive = new PclZip($tmpzip);
    $contrib_xml = $racine.'contribXML';
    $v_list = $archive->add($contrib_xml.$sep.$nom_contribution, PCLZIP_OPT_REMOVE_PATH, $contrib_xml);
    if ($v_list == 0)
        erreur($archive->errorInfo(true));
    if (!file_exists($tmpzip))
        erreur(CONTACTER_ADMIN);
    
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename='.$nom_contribution.'.zip');
    header('Content-Transfer-Encoding: binary');
    header('Expires: 0');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Content-Length: ' . filesize($tmpzip));
    lire_un_fichier($tmpzip);
    unlink($tmpzip);
}


// Supprimer une contribution à partir de son id dans une requête GET
function action_supprimer_contribution($lien_bdd) {
    
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);

    $id_contribution = $_GET['id_contribution'];
    
    if (count(liste_contributeurs($lien_bdd,$id_contribution)) != 1 && $_SESSION['status'] != "administrateur")
        erreur(PAS_AUTORISE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    
    supprimer_contribution($lien_bdd,$id_contribution);
    page_liste_contributions($lien_bdd);
}



// Export en zip d'un site
function action_exporter_site($lien_bdd,$type=NULL) {
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
        
    $id_contribution = $_GET['id_contribution'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    // génération du site à exporter dans un dossier temporaire,
    // pour qu'il soit propre et pour éviter des conflits avec le site généré
    // (type différent, génération par un autre utilisateur...)
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $sep = DIRECTORY_SEPARATOR;
    $racine = realpath(getcwd().$sep.'..'.$sep.'..'.$sep).$sep;
    $dossier_tmp = $racine.'tmp';
    $chemin_parent_site = dossier_unique($dossier_tmp.$sep.'tmp_site_'.$nom_contribution);
    $chemin_site = $chemin_parent_site.$sep.$nom_contribution;
    //sarra decomment this: ça me bloque pour l'export du site d'un utilisateur read seulement ?????
    $tmp_profile = false;
    if ($_SESSION['id_profile'] == 0)
		$tmp_profile = true;
	action_generer_apercu($lien_bdd,$type, $chemin_site, $tmp_profile);
    
    // compression zip et effacement du dossier temporaire
    $tmpzip = tempnam($dossier_tmp, 'tmpzip_'.$nom_contribution);
    $archive = new PclZip($tmpzip);
    $v_list = $archive->add($chemin_site, PCLZIP_OPT_REMOVE_PATH, $chemin_parent_site);
    supprimer_vraiment($chemin_parent_site);
    if ($v_list == 0)
        erreur($archive->errorInfo(true));
    if (!file_exists($tmpzip))
        erreur(CONTACTER_ADMIN);
    
    // envoi et suppression du fichier zip
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename='.'site_'.$nom_contribution.'.zip');
    header('Content-Transfer-Encoding: binary');
    header('Expires: 0');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Content-Length: ' . filesize($tmpzip));
    lire_un_fichier($tmpzip);
    unlink($tmpzip);
}

// Effacer un site
function action_effacer_site($lien_bdd) {
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_contribution = $_GET['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    //verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $sep = DIRECTORY_SEPARATOR;
    $racine = realpath(getcwd().$sep.'..'.$sep.'..'.$sep).$sep;
    $chemin_vers_site = $racine.'sites'.$sep.$nom_contribution.$sep;
    if (is_dir($chemin_vers_site)) {
        $chemin_poubelle = $racine.'poubelle';
        if (!is_dir($chemin_poubelle))
            exit(POUBELLE_INTROUVABLE);
        // on crée un dossier unique pour pourvoir éviter le cas où une contribution portant le même nom a été jetée auparavant 
        $chemin_site_dans_poubelle = dossier_unique($chemin_poubelle.$sep."site_".$nom_contribution);
        if ( rename($chemin_vers_site, $chemin_site_dans_poubelle) == FALSE )
            erreur(ERREUR_DEPLACEMENT);
        else
            supprimer_vraiment($chemin_site_dans_poubelle);
    }
    //page_edition_contribution($id_contribution);
    header("Location:index.php?page=edition_contribution&id_contribution=$id_contribution");
}

?>
