<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page permettant de modifier les sous-projets d'un projet
// nécessite tete_pied.php, projets.php, base_de_donnees.php, et l'initialisation des strings et des erreurs
function page_sous_projets($lien_bdd,$id_projet) {
    
    $titre_projet = titre_projet($lien_bdd,$id_projet);
    $liste_projets = liste_id_projets($lien_bdd);
    $liste_sous_projets = liste_sous_projets($lien_bdd,$id_projet);
    
    debut_html(SOUS_PROJETS, GESTION_PROJETS);
    $jeton = getJeton();
    echo '<h2>'.$titre_projet.'</h2>'."\n";
    echo '<div class="boitedroite">'."\n";
    if ($liste_sous_projets != false) {
        foreach ($liste_sous_projets as $sous_projet) {
            $id_sous_projet = $sous_projet['id'];
            $titre_sous_projet = $sous_projet['titre'];
            echo '<div class="contributeur">';
            echo '<form method="POST" action="administration.php">'."\n";
            echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
            echo "$titre_sous_projet\n";
            echo '<input type="hidden" name="action" value="supprimer_sous_projet">'."\n";
            echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">';
            echo '<input type="hidden" name="id_sous_projet" value="'.$id_sous_projet.'">';
            echo '<input type="submit" value="'.RETIRER.'" class="valider">'."\n";
            echo "</form>\n";
            echo "</div>\n";
        }
    }
    //ajouter un projet
    echo '<div class="ajout_contributeur">'."\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="ajouter_sous_projet">'."\n";
    echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">'."\n";
    $liste_autres_projets = array();
    for ($i=0; $i<count($liste_projets); $i++) {
        $id_autre_projet = $liste_projets[$i];
        $lien = false;
        for ($j=0; $j<count($liste_sous_projets); $j++) {
            if ($id_autre_projet == $liste_sous_projets[$j]['id'])
                $lien = true;
        }
        if ($lien == false && $id_autre_projet != $id_projet)
            array_push($liste_autres_projets, $id_autre_projet);
    }
    if (count($liste_autres_projets) > 0) {
        echo '<select name="id_sous_projet">';
        foreach ($liste_autres_projets as $id_autre_projet) {
            echo "<option value=\"".$id_autre_projet."\">".titre_projet($lien_bdd,$id_autre_projet)."</option>";
        }
        echo "</select>\n";
        echo '<input type="submit" name="ajouter" value="'.AJOUTER.'" class="valider">';
    }
    echo "</form>\n";
    echo "</div>"; // ajout_contributeur
    echo "</div>\n"; // boitedroite
    
    echo '<p><a href="administration.php?page=administration_projets">'.RETOUR."</a></p>\n";
    
    fin_html();
}


// Ajoute un lien projet-projet à partir d'une requête POST
function action_ajouter_sous_projet($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_sous_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_sous_projet = $_POST['id_sous_projet'];
    verifie_id($id_sous_projet);
    
    ajouter_sous_projet($lien_bdd,$id_projet, $id_sous_projet);
    page_sous_projets($lien_bdd,$id_projet);
}


// Supprime un lien projet-projet à partir d'une requête POST
function action_supprimer_sous_projet($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_sous_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_sous_projet = $_POST['id_sous_projet'];
    verifie_id($id_sous_projet);
    
    supprimer_sous_projet($lien_bdd,$id_projet, $id_sous_projet);
    page_sous_projets($lien_bdd,$id_projet);
}

?>
