<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page avec les paramètres du site
// nécessite tete_pied.php, et l'initialisation des strings et des erreurs
require_once(dirname(__FILE__)."/../../site_config/confedit.class.php");

function page_parametres_du_site() {

    // Liste des fichiers de configuration et des langues à partir des répertoires config et langues
    $handle = opendir('../../config');
    while ( $fichier = readdir($handle) )
        if ($fichier != '.' and $fichier != '..' and is_dir('../../config/'.$fichier))
            $fichiers_configuration_jaxe[] = $fichier;
    closedir($handle);
    
    $liste_langues = lire_liste_langues();
    
    debut_html(PARAMETRE_WEBJAXE, PARAMETRE_WEBJAXE);
    
    $jeton = getJeton();
    
    echo '<div class="parametres_du_site">'."\n";
    echo '<div class="boite_parametre_du_site">'."\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="changement_parametres_site">'."</p>\n";
    echo '<table class="bordure">';
    echo '<tr>';
    echo '<td>'.CONFIGURATION_PAR_DEFAUT.'</td>';
    echo '<td>';
    echo '<select name="chemin_configuration_jaxe">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select>';
    echo '</td>';
    echo "</tr>\n";
    echo '<tr>';
    echo "<td>".DOSSIER_SITE."</td>";
    echo '<td><input type="text" name="chemin_dossier_apercu" value="'.$_SESSION['chemin_dossier_apercu'].'" class="texte"></td>';
    echo "</tr>\n";
    /*
    echo '<tr>';
    echo "<td>".DOSSIER_INTERFACE."</td>";
    echo '<td><input type="text" name="chemin_dossier_interface" value="'.$_SESSION['chemin_dossier_interface'].'" class="texte"></td>';
    echo "</tr>\n";
    */
    echo '<tr>';
    echo '<td>'.SERVEUR_BASE_DE_DONNEE.'</td>';
    echo '<td><input type="text" name="adresse_bdd" value="'.$_SESSION['serveur_base_de_donnes'].'" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.NOM_BASE_DE_DONNEE.'</td>';
    echo '<td><input type="text" name="nom_bdd" value="'.$_SESSION['nom_base_de_donnes'].'" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.LOGIN_BASE_DE_DONNEE.'</td>';
    echo '<td><input type="text" name="login_bdd" value="'.$_SESSION['login_base_de_donnes'].'" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.MOT_DE_PASSE_BASE_DE_DONNEE.'</td>';
    echo '<td><input type="password" name="pass_bdd" value="" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.EMAIL_ADMIN.'</td>';
    echo '<td><input type="text" name="admin_mail" value="'.$_SESSION['email_admin'].'" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.GESTION_MAIL.'</td>';
    if ($_SESSION['choix_du_mail'] == 'PAS_MAIL')
        echo '<td>'.PAS_MAIL.'<input type="radio" name="mail_choice" value="PAS_MAIL" class="texte" checked>&nbsp;&nbsp;&nbsp;';
    else 
        echo '<td>'.PAS_MAIL.'<input type="radio" name="mail_choice" value="PAS_MAIL" class="texte">&nbsp;&nbsp;&nbsp;';
    if ($_SESSION['choix_du_mail'] == 'UTILISER_MAIL_PHP')
        echo UTILISER_MAIL_PHP.'<input type="radio" name="mail_choice" value="UTILISER_MAIL_PHP" class="texte" checked>&nbsp;&nbsp;&nbsp;';
    else 
        echo UTILISER_MAIL_PHP.'<input type="radio" name="mail_choice" value="UTILISER_MAIL_PHP" class="texte">&nbsp;&nbsp;&nbsp;';
    if ($_SESSION['choix_du_mail'] == 'UTILISER_SMTP')
        echo UTILISER_SMTP.'<input type="radio" name="mail_choice" value="UTILISER_SMTP" class="texte" checked></td>';
    else 
        echo UTILISER_SMTP.'<input type="radio" name="mail_choice" value="UTILISER_SMTP" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.SERVEUR_SMTP.'</td>';
    echo '<td><input type="text" name="smtp_serveur" value="'.$_SESSION['nom_du_serveur_smtp'].'" class="texte"></td>';
    echo "</tr>\n";
    echo '<tr><td>'.LANGUE.'</td><td>';
    echo '<select name="langue">';
    for ( $i = 0; $i < count($liste_langues); $i++ )
    {
        $nom = $liste_langues[$i];
        if ($nom == $_SESSION['langue_site'])
            echo '<option value="'.$nom.'" selected>'.$nom.'</option>';
        else
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select>'."\n";
    echo '</td></tr>'."\n";
    echo '</table>'."\n";
    echo '<p>';
    echo '<input type="submit" name="changer_les_parametres" value="'.CHANGER_PARAMETRES.'" class="valider">';
    echo "</p>\n";
    echo "</form>\n";
    echo "<br><br>\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="desinstallation">'."</p>\n";
    echo '<p><input type="submit" name="desinstaller" value="'.DESINSTALLER.'" class="valider">'."</p>\n";
    echo "</form>\n";
    echo "</div>\n"; // boite_parametre_du_site
    echo "</div>\n"; // parametres_du_site
    
    echo '<p><a href="administration.php?page=accueil">'.RETOUR."</a></p>\n";
    
    fin_html();
}

// change les paramètres du site à partir de la requête POST
// nécessite tete_pied.php, lecture_config.php, et l'initialisation des strings et des erreurs
function action_changement_parametres_site() {

    if (!isset($_POST['chemin_configuration_jaxe']) || !isset($_POST['chemin_dossier_apercu']) ||
        !isset($_POST['adresse_bdd']) || !isset($_POST['nom_bdd']) || !isset($_POST['login_bdd']) ||
        !isset($_POST['pass_bdd']) || !isset($_POST['langue']) || !isset($_POST['mail_choice']) || !isset($_POST['smtp_serveur']) || !isset($_POST['jeton']))
            erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $chemin_configuration_jaxe = $_POST['chemin_configuration_jaxe'];
    $chemin_dossier_apercu = $_POST['chemin_dossier_apercu'];
    if ($_POST['chemin_dossier_apercu'] != $_SESSION['chemin_dossier_apercu'])
    {
        $sep = DIRECTORY_SEPARATOR;
        $racine = getcwd().$sep."..".$sep."..".$sep;
        $nouveau_chemin_site = $racine.$_POST['chemin_dossier_apercu'];
        $ancien_chemin_site = $racine.$_SESSION['chemin_dossier_apercu'];
        rename($ancien_chemin_site, $nouveau_chemin_site);
    }
    //$chemin_dossier_interface = $_POST['chemin_dossier_interface'];
    $adresse_bdd = $_POST['adresse_bdd'];
    $nom_bdd = $_POST['nom_bdd'];
    $login_bdd = $_POST['login_bdd'];
    if (empty($_POST['pass_bdd']))
    {
		$pass_bdd = FALSE;
        //erreur(PARAMETRES_MANQUANT.": Veuillez indiquer le mot de passe de la base de donnée!");
	}
    else
		$pass_bdd = $_POST['pass_bdd'];
			
		$langue = $_POST['langue'];
		$admin_mail = $_POST['admin_mail'];
		$mail_choice = $_POST['mail_choice'];
		$smtp_serveur = $_POST['smtp_serveur'];
		
		$config = new ConfigEditor();
		$config_file = "../../site_config/config.php";
		editer_fichier_config($config,$config_file,$chemin_configuration_jaxe, $chemin_dossier_apercu, $adresse_bdd, $nom_bdd, $login_bdd, $pass_bdd, $langue, $admin_mail, $mail_choice, $smtp_serveur);
		lire_fichier_configuration($config_file);
     
    //editer_fichier_config($chemin_configuration_jaxe, $chemin_dossier_apercu, $adresse_bdd, $nom_bdd, $login_bdd, $pass_bdd, $langue, $admin_mail, $mail_choice, $smtp_serveur);
    //lire_fichier_configuration("../../site_config/site_config.xml");     
    
    // pb : les strings, sous forme de constantes, ne sont pas redéfinis avec une nouvelle langue
    page_parametres_du_site();
    header("Location:administration.php?page=parametres_du_site");
}

// Efface la base de données et les contributions
// utilise tete_pied.php, contributions.php, base_de_donnees.php, et l'initialisation des strings et des erreurs
function action_desinstallation() {
    if (!isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    supprimer_contributions($lien_bdd);
    $requete = "drop database ".$_SESSION['nom_base_de_donnes'];
    $resultat = executer_requete($lien_bdd,$requete);
    debut_html(DESINSTALLATION, "");
    echo DESINTALLATION_FINIT;
    fin_html();
}

?>
