<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page de modification d'un projet, à partir de son id
// nécessite tete_pied.php, outils.php, base_de_donnees.php, administration_projets, projets.php, et l'initialisation des strings et des erreurs
function page_modifier_projet($lien_bdd,$id_projet) {
    
    $titre_projet = titre_projet($lien_bdd,$id_projet);
    
    debut_html(GESTION_PROJETS, GESTION_PROJETS);
    
    $jeton = getJeton();
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" class="texte" name="id_projet" value="'.$id_projet.'">'."\n";
    echo '<input type="hidden" name="action" value="modifier_projet">'."\n";
    echo '<p>'.TITRE_PROJET.' <input type="text" class="texte" name="titre" value="'.$titre_projet.'" size="40" maxlength="40"></p>'."\n";
    echo "<p>\n";
    echo '<input type="reset">'."\n";
    echo '<input type="submit">'."\n";
    echo "</p>\n";
    echo "</form>\n";
    
    echo '<p><a href="administration.php?page=administration_projets">'.RETOUR."</a></p>\n";
    
    fin_html();
}

// Change le titre d'un projet à partir d'une requête POST
function action_modifier_projet($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['titre']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $titre = $_POST['titre'];
    
    modifier_projet($lien_bdd,$id_projet, $titre);
    page_administration_projets($lien_bdd);
}

?>
