<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page pour la gestion des contributions
// nécessite tete_pied.php, contributions.php, projets.php, base_de_donnees.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_gestion_des_contributions($lien_bdd,$id_proj=false, $suppression='') {

    debut_html(GESTION_CONTRIBUTIONS, GESTION_CONTRIBUTIONS);
    $jeton = getJeton();
    $dossier_sites = $_SESSION['chemin_dossier_apercu'];
    
    if ($id_proj != false)
        $liste_projets = array(0 => projet($lien_bdd,$id_proj));
    else
        $liste_projets = liste_des_projets($lien_bdd);
        
    if ($liste_projets != false) 
    {
        $foret_projets = construire_foret_projets($liste_projets);
        afficher_foret_contributions($lien_bdd,$foret_projets, $id_proj, $dossier_sites, $jeton);
    }
    
    //interface pour ajouter une contribution
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.TITRE_AJOUTER_CONTRIBUTION.'</p>'."\n";
    echo '<form method="POST" action="administration.php" name="formulaire_ajout_contribution">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="ajout_contribution">'."</p>\n";
    echo '<p><input type="text" name="nom_contribution" class="texte" maxlength="20"></p>'."\n";
    
    echo '<p><select name="id_projet">';
    $liste_projets = liste_des_projets($lien_bdd);
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id_projet = $liste_projets[$i]['id'];
            $titre_projet = $liste_projets[$i]['titre'];
            if ($id_proj != false) {
                if ($id_projet == $id_proj)
                    echo '<option value="'.$id_projet.'" selected>'.$titre_projet.'</option>';
                else
                    echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
            }
            else
                echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
        }
    }
    echo '</select>';
    
    echo ' <select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    $fichiers_configuration_jaxe = liste_configs();
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select> ';
    echo '<input type="submit" name="ajouter" value="'.AJOUTER.'" class="valider"></p>';
    echo "</form>\n";
    echo "</div>\n"; // formulaire
    
    
    // IMPORT
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.IMPORT_CONTRIBUTION.'</p>'."\n";
    echo '<form method="POST" enctype="multipart/form-data" action="administration.php?test=1">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="import_contribution">'."</p>\n";
    //echo "<p>\n";
    echo '<p>'.FICHIER_ZIP.' <input type="file" name="fichier" class="fichier">'."</p>";
    
    //echo PROJET.': ';
    echo '<p><select name="id_projet">';
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id_projet = $liste_projets[$i]['id'];
            $titre_projet = $liste_projets[$i]['titre'];
            if ($id_proj != false) {
                if ($id_projet == $id_proj)
                    echo '<option value="'.$id_projet.'" selected>'.$titre_projet.'</option>';
                else
                    echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
            }
            else
                echo '<option value="'.$id_projet.'">'.$titre_projet.'</option>';
        }
    }
    echo '</select>';
    
    //echo '<br>'.CONFIGURATION_JAXE.': ';
    echo '<select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select>';
    
    echo '<input type="submit" name="importer" value="'.IMPORTER.'" class="valider"></p>';
    echo "</form>\n";
    echo "</div>\n";
    
    echo '<p><a href="administration.php?page=accueil">'.RETOUR."</a></p>\n";
    
    fin_html();
}

function afficher_foret_contributions($lien_bdd,$foret, $id_proj, $dossier_sites, $jeton) {
    echo "<ul>\n";
    for ($i=0; $i<count($foret); $i++) {
        echo "<li>";
        $projet = $foret[$i]['projet'];
        $sous_projets = $foret[$i]['sous-projets'];
        $id_projet = $projet['id'];
        $titre_projet = $projet['titre'];
        $liste_contributions = liste_des_contributions_projet($lien_bdd,$id_projet);
        echo '<p class="soustitre">'.PROJET.' <em>'.$titre_projet."</em></p>\n";
        if ($liste_contributions != FALSE) {
            echo '<table class="table_administration tab_contrib_admin">'."\n";
            echo '<tr><th>'.NOM.'</th><th>'.DERNIER_AUTEUR.'</th><th>'.DATE.'</th><th>'.ACTIONS.'</th></tr>'."\n";
            for ($j=0; $j<count($liste_contributions); $j++) {
                $contribution = $liste_contributions[$j];
                $id_contribution = $contribution['id'];
                $nom_contribution = $contribution['nom'];
                $liste_historique_contrib = liste_des_historiques_contribution($lien_bdd,$id_contribution);
                echo "<tr>\n";
                echo '<td><b>'.$nom_contribution."</b></td>\n";
                $historique_contrib = $liste_historique_contrib[0];
                $id_utilisateur = $historique_contrib['id_utilisateur'];
                if ($id_utilisateur != FALSE) {
                    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
                    echo '<td>'.$utilisateur['prenom'].' '.$utilisateur['nom']."</td>\n";
                } else
                    echo "<td></td>\n";
                $date_edition = $historique_contrib['dossier_historique'];
                if ($date_edition != FALSE) {
                    $morceaux = explode('T', $date_edition); // on garde juste la date
                    echo '<td>'.$morceaux[0]."</td>\n";
                } else
                    echo "<td></td>\n";
                echo '<td>';
                echo '<a href="administration.php?page=renommer_contribution&amp;id_contribution='.$id_contribution.'&amp;id_projet='.$id_projet.'" class="petit_bouton">';
                echo '<img src="../../design/icones/renommer.gif" class="icone" border="0" alt=""> '.RENOMMER."</a>\n";
                
                echo '<a href="administration.php?page=projet_contribution&amp;id_contribution='.$id_contribution.'" class="petit_bouton">';
                echo CHANGER_PROJET.'</a>'."\n";
                
                echo '<a href="../partie_utilisateur/index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" class="petit_bouton">';
                echo '<img src="../../design/icones/editer.gif" class="icone" border="0" alt=""> '.EDITER.'</a>'."\n";
                
                /*
                if (is_file("../../".$dossier_sites."/".$nom_contribution."/index.html")) {
                    echo '<a href="../../'.$dossier_sites.'/'.$nom_contribution.'/index.html" class="petit_bouton">';
                    echo '<img src="../../design/icones/site.gif" class="icone" border="0"> '.APERCU.'</a>'."\n";
                }
                */
                
                echo '<a href="../partie_utilisateur/index.php?action=exporter&amp;id_contribution='.$id_contribution.'&amp;jeton='.$jeton.'" class="petit_bouton">';
                echo '<img src="../../design/icones/telecharger.gif" class="icone" border="0" alt=""> '.EXPORTER."</a>\n";
                
                if ($id_proj != false)
                    echo '<a href="administration.php?page=confirmation&amp;id_contribution='.$id_contribution.'&amp;id_projet='.$id_projet.'" class="petit_bouton">';
                else
                    echo '<a href="administration.php?page=confirmation&amp;id_contribution='.$id_contribution.'" class="petit_bouton">';
                echo '<img src="../../design/icones/poubelle.gif" class="icone" border="0" alt=""> '.SUPPRIMER."</a>\n";
                echo "</td>\n";
                echo "</tr>\n";
            }
            echo "</table>\n";
        }
        if (count($sous_projets) > 0)
            afficher_foret_contributions($lien_bdd,$sous_projets, $id_proj, $dossier_sites, $jeton);
        
        echo "</li>\n";
    }
    echo "</ul>\n";
}

function liste_configs() {
    $handle = opendir('../../config');
    while ( $fichier = readdir($handle) )
        if ($fichier != '.' and $fichier != '..' and is_dir('../../config/'.$fichier))
            $fichiers_configuration_jaxe[] = $fichier;
    closedir($handle);
    return($fichiers_configuration_jaxe);
}


// Ajoute une contribution à partir de son nom dans une requête POST
function action_ajout_contribution($lien_bdd) 
{
    $liste_projets = liste_des_projets($lien_bdd);
    if ($liste_projets == FALSE)
        erreur(PAS_DE_PROJET);
        
    if (!isset($_POST['nom_contribution']) || !isset($_POST['id_projet']) || !isset($_POST['config']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $nom_contribution = $_POST['nom_contribution'];
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $config = $_POST['config'];
    
    creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config);
    page_gestion_des_contributions($lien_bdd,$id_projet);
  
}



// Supprime une contribution à partir de son id dans une requête GET
function action_supprimer_contribution($lien_bdd) {
    
    if (!isset($_GET['id_contribution']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution= $_GET['id_contribution'];
    verifie_id($id_contribution);
    
    $id_projet = id_projet_contribution($lien_bdd,$id_contribution);
    if (supprimer_contribution($lien_bdd,$id_contribution))
        page_gestion_des_contributions($lien_bdd,$id_projet);
    else
        erreur(CONTRIBUTION_PAS_SUPPRIMEE);
}


// import d'une nouvelle contribution à partir d'un zip contenant le dossier de la contribution et du choix de la config
function action_import_contribution($lien_bdd) {
    $liste_projets = liste_des_projets($lien_bdd);
    if ($liste_projets == FALSE)
        erreur(PAS_DE_PROJET);
    
    if (!isset($_FILES['fichier']) || !isset($_POST['config']) || !isset($_POST['id_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $nom_fichier_tmp = $_FILES['fichier']['tmp_name'];
    $id_projet = $_POST['id_projet'];
    $config = $_POST['config'];
    
    if (!file_exists($nom_fichier_tmp)) {
        erreur(ZIP_NON_TROUVE);
        return;
    }
    $zip = new PclZip($nom_fichier_tmp);
    if (($list = $zip->listContent()) == 0) {
        erreur(CONTENU_ZIP);
        return;
    }
    $nom_contribution = '';
    for ($i=0; $i<sizeof($list); $i++) {
        if ($list[$i]['folder'] && substr_count($list[$i]['filename'], '/') <= 1 && substr_count($list[$i]['filename'], '\\') <= 1) {
            $nom_dossier = $list[$i]['filename'];
            $nom_dossier = str_replace('/', '', $nom_dossier);
            $nom_dossier = str_replace('\\', '', $nom_dossier);
            for ($j=0; $j<sizeof($list); $j++) {
                if ($list[$j]['filename'] == $nom_dossier.'/'.$nom_dossier.'.xml' || $list[$j]['filename'] == $nom_dossier.'\\'.$nom_dossier.'.xml')
                    $nom_contribution = $nom_dossier;
            }
        }
    }
    if ($nom_contribution == '') {
        erreur(CONTENU_ZIP);
        return;
    }
    
    creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config);
    $sep = DIRECTORY_SEPARATOR;
    $racine = realpath(getcwd().$sep.'..'.$sep.'..'.$sep).$sep;
    $contrib_xml = $racine.'contribXML';
    if ($zip->extract(PCLZIP_OPT_PATH, $contrib_xml.$sep.$nom_contribution, PCLZIP_OPT_REMOVE_PATH, $nom_contribution, PCLZIP_CB_PRE_EXTRACT, 'filtre') == 0)
        erreur($zip->errorInfo(true));
    page_gestion_des_contributions($lien_bdd,$id_projet);
}

function filtre($p_event, &$p_header) {
    $info = pathinfo($p_header['filename']);
    $nom = $info['basename'];
    $chemin = $info['dirname'];
    if ($nom == '__MACOSX' || strpos($chemin, '__MACOSX') !== false || $nom == '.DS_Store' || $nom == 'Thumbs.db')
        return(0);
    return(1);
}

?>
