<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page pour l'administration des utilisateurs
// nécessite tete_pied.php, outils.php, base_de_donnees.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_administration_utilisateurs($lien_bdd) {

    $liste_utilisateurs = liste_des_utilisateurs($lien_bdd);
    $liste_demandes = liste_des_demandes($lien_bdd);
    
    debut_html(GESTION_UTILISATEURS, GESTION_UTILISATEURS);
    
    $jeton = getJeton();
    
        echo '<div class="spacer"></div>'."\n";
    echo "<h1>".TITRE_DEMANDES_INSCRIPTION."</h1>\n";
    if ($liste_demandes != FALSE)
    {
        echo '<div class="demande_inscription">'."\n";
        for($i=0; $i<count($liste_demandes); $i++)
        {
            $demande = $liste_demandes[$i];
            $login = $demande['login'];
            $prenom = $demande['prenom'];
            $nom = $demande['nom'];
            $motdepasse = $demande['motdepasse'];
            $id = $demande['id'];
            echo '<div class="boite">'."\n";
            echo LOGIN." : <span class='login'>".$login."</span><br>\n";
            echo PRENOM." : <span class='prenom'>".$prenom."</span><br>\n";
            echo NOM_FAMILLE." : <span class='nom'>".$nom."</span><br>\n";
            echo "<br>\n";
            
            echo '<form method="POST" action="administration.php">'."\n";
            echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
            echo '<p><input type="hidden" name="action" value="creation_compte_definitif">'."</p>\n";
            echo '<p><input type="hidden" name="id" value="'.$id.'">'."</p>\n";
            echo '<p><input type="submit" value="'.AUTORISER.'" class="valider">'."</p>\n";
            echo "</form>\n";
            
            echo '<form method="POST" action="administration.php">'."\n";
            echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
            echo '<p><input type="hidden" name="action" value="ne_pas_autoriser">'."</p>\n";
            echo '<p><input type="hidden" name="id" value="'.$id.'">'."</p>\n";
            echo '<p><input type="submit" value="'.PAS_AUTORISER.'" class="valider">'."</p>\n";
            echo "</form>\n";
            
            echo "</div>\n"; // boite
        }
        echo "</div>\n"; // demande_inscription
    } else
        echo '<p>'.AUCUNE."</p><br>\n";
    
    echo '<div class="spacer"></div>';
    
    if ($liste_utilisateurs != FALSE) {
        echo '<table class="table_administration tab_utilisateur">'."\n";
        echo '<tr><th>'.LOGIN.'</th><th>'.PRENOM.'</th><th>'.NOM_FAMILLE.'</th><th colspan="3">'.ACTIONS.'</th></tr>'."\n";
        for($i=0; $i<count($liste_utilisateurs); $i++)
        {
            $utilisateur = $liste_utilisateurs[$i];
            $login = $utilisateur['login'];
            $status = $utilisateur['status'];
            $prenom = $utilisateur['prenom'];
            $nom = $utilisateur['nom'];
            $motdepasse = $utilisateur['motdepasse'];
            $id = $utilisateur['id'];
            echo "<tr>\n";
            echo "<td><span class='login'>".$login."</span></td>\n";
            echo "<td><span class='prenom'>".$prenom."</span></td>\n";
            echo "<td><span class='nom'>".$nom."</span></td>\n";
            echo '<td><a href="administration.php?page=modifier_utilisateur&amp;id='.$id.'" class="petit_bouton">';
            echo '<img src="../../design/icones/editer.gif" class="icone" border="0" alt=""> '.MODIFIER."</a></td>\n";
            echo '<td><a href="administration.php?page=projets_utilisateur&amp;id_utilisateur='.$id.'" class="petit_bouton">';
            echo '<img src="../../design/icones/projet_small.gif" class="icone" border="0" alt=""> '.PROJETS."</a></td>\n";
            if ($status != "administrateur") {
                echo '<td><a href="administration.php?action=supprimer_utilisateur&amp;id='.$id.'&amp;jeton='.$jeton.'" class="petit_bouton">';
                echo '<img src="../../design/icones/poubelle.gif" class="icone" border="0" alt=""> '.SUPPRIMER."</a></td>\n";
            } else
                echo "<td></td>\n";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
    

    echo '<p><a href="administration.php?page=accueil">'.RETOUR."</a></p>\n";
    
    fin_html();
}

// Supprime un utilisateur à partir de son id dans une requête GET
function action_supprimer_utilisateur($lien_bdd) {
    
    if (!isset($_GET['id']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id = $_GET['id'];
    verifie_id($id);
    
    suprimer_utilisateur($lien_bdd,$id);
    page_administration_utilisateurs($lien_bdd);
}

// Rejette l'inscription d'un utilisateur,  à partir de son id dans une requête POST
function action_ne_pas_autoriser($lien_bdd) {
    
    if (!isset($_POST['id']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id = $_POST['id'];
    verifie_id($id);
    
    refuser_utilisateur($lien_bdd,$id);
    page_administration_utilisateurs($lien_bdd);
}

// Création d'un compte définitif pour un utilisateur, à partir de son id dans une requête POST
function action_creation_compte_definitif($lien_bdd) {
    
    if (!isset($_POST['id']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id = $_POST['id'];
    verifie_id($id);
    
    valider_utilisateur($lien_bdd,$id);
    page_administration_utilisateurs($lien_bdd);
}

?>
