<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page pour la gestion des projets
// nécessite tete_pied.php, projets.php, et l'initialisation des strings et des erreurs
function page_administration_projets($lien_bdd,$suppression='') {

    debut_html(GESTION_PROJETS, GESTION_PROJETS);
    $jeton = getJeton();
    $liste_projets = liste_des_projets($lien_bdd);
    if ($liste_projets != false) {
        $foret_projets = construire_foret_projets($liste_projets);
        afficher_foret_projets($lien_bdd,$foret_projets, $jeton);
    }
    
    // formulaire pour ajouter un projet
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.TITRE_AJOUTER_PROJET.'</p>'."\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="ajouter_projet">'."</p>\n";
    echo '<p><input type="text" name="titre_projet" class="texte" size="40" maxlength="40"></p>'."\n";
    echo '<p><input type="submit" name="ajouter" value="'.AJOUTER.'" class="valider"></p>'."\n";
    echo "</form>\n";
    echo "</div>\n"; // formulaire
    
    // import d'un projet
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.IMPORT_PROJET.'</p>'."\n";
    echo '<form method="POST" enctype="multipart/form-data" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="importer_projet">'."</p>\n";
    echo "<p>\n";
    echo FICHIER_ZIP.' <input type="file" name="fichier" class="fichier">'."\n";
    
    //echo '<br>'.CONFIGURATION_JAXE.': ';
    echo '<select name="config">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    $fichiers_configuration_jaxe = liste_configs();
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo '</select> ';
    
    echo '<input type="submit" name="importer" value="'.IMPORTER.'" class="valider">'."\n";
    echo "</p>\n";
    echo "</form>\n";
    echo "</div>\n";
    
    echo '<p><a href="administration.php?page=accueil">'.RETOUR."</a></p>\n";
    
    fin_html();
}

function afficher_foret_projets($lien_bdd,$foret, $jeton) {
    echo "<ul>\n";
    for ($i=0; $i<count($foret); $i++) {
        echo "<li>";
        $projet = $foret[$i]['projet'];
        $sous_projets = $foret[$i]['sous-projets'];
        $id_projet = $projet['id'];
        $titre_projet = $projet['titre'];
        echo '<b>'.$titre_projet."</b><br>\n";
        
        echo '<a href="administration.php?page=modifier_projet&amp;id_projet='.$id_projet.'" class="petit_bouton">';
        echo '<img src="../../design/icones/renommer.gif" class="icone" border="0" alt=""> '.RENOMMER."</a>\n";
        
        echo '<a href="administration.php?page=gestion_des_contributions&amp;id_projet='.$id_projet.'" class="petit_bouton">';
        echo '<img src="../../design/icones/contributions_small.gif" class="icone" border="0" alt=""> '.CONTRIBUTIONS."</a>\n";
        
        echo '<a href="administration.php?page=participants_projet&amp;id_projet='.$id_projet.'" class="petit_bouton">';
        echo '<img src="../../design/icones/utilisateurs_small.gif" class="icone" border="0" alt=""> '.PARTICIPANTS."</a>\n";
        
        echo '<a href="administration.php?page=sous_projets&amp;id_projet='.$id_projet.'" class="petit_bouton">';
        echo '<img src="../../design/icones/projet_small.gif" class="icone" border="0" alt=""> '.SOUS_PROJETS."</a>\n";
        
        $liste_contributions = liste_id_contributions_projet($lien_bdd,$id_projet);
        if ($liste_contributions != false && count($liste_contributions) != 0) {
            echo '<a href="../partie_utilisateur/index.php?action=exporter_projet&amp;id='.$id_projet.'&amp;jeton='.$jeton.'" class="petit_bouton">';
            echo '<img src="../../design/icones/telecharger.gif" class="icone" border="0" alt=""> '.EXPORTER."</a>\n";
        }
        
        echo '<a href="administration.php?page=confirmation&amp;id_projet='.$id_projet.'" class="petit_bouton">';
        echo '<img src="../../design/icones/poubelle.gif" class="icone" border="0" alt=""> '.SUPPRIMER."</a>\n";
        
        if (count($sous_projets) > 0)
            afficher_foret_projets($lien_bdd,$sous_projets, $jeton);
        
        echo "</li>\n";
    }
    echo "</ul>\n";
}

// Ajoute un projet à partir de son titre dans une requête POST
function action_ajouter_projet($lien_bdd) {
    if (!isset($_POST['titre_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $titre_projet = $_POST['titre_projet'];
    
    if (projet_existe($lien_bdd,$titre_projet))
        erreur(PROJET_EXISTE_DEJA.$titre_projet);
    
    creer_projet($lien_bdd,$titre_projet);
    page_administration_projets($lien_bdd);
}


// Supprime un projet et toutes les contributions qui contient à partir de son id dans une requête GET
function action_supprimer_projet($lien_bdd) {
    
    if (!isset($_GET['id_projet']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_GET['id_projet'];
    verifie_id($id_projet);
    
    // supprimer les contributions du projet
    $liste_contributions = liste_id_contributions_projet($lien_bdd,$id_projet);
    if ($liste_contributions != false) {
        for ($i=0; $i<count($liste_contributions); $i++) {
            $id_contribution = $liste_contributions[$i];
            if (!supprimer_contribution($lien_bdd,$id_contribution))
                erreur(CONTRIBUTION_PAS_SUPPRIMEE);
        }
    }
        
    supprimer_projet($lien_bdd,$id_projet);
    page_administration_projets($lien_bdd);
}

// import d'un nouveau projet à partir d'un zip contenant les dossiers des contributions
function action_importer_projet($lien_bdd) {
    if (!isset($_FILES['fichier']) || !isset($_POST['config']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
        
    $nom_fichier_tmp = $_FILES['fichier']['tmp_name'];
    $config = $_POST['config'];
    
    importer_projet($lien_bdd,$nom_fichier_tmp, $config);
    header("Location:administration.php?page=administration_projets");
}

?>
