<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();
if (!isset($_SESSION['langue']) || !$_SESSION['langue']) {
    if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && file_exists('../../langues/'.substr($_SERVER['HTTP_ACCEPT_LANGUAGE'],0,2).'.php'))
        $langue = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'],0,2);
    else
        $langue = 'fr';
} else
    $langue = $_SESSION['langue'];
$_SESSION['langue'] = $langue;
$fichierlangue = dirname(__FILE__).'/../../langues/'.$langue.'.php';
require_once($fichierlangue);
require_once(dirname(__FILE__)."/../include/base_de_donnees.php");
require_once(dirname(__FILE__)."/../include/lecture_config.php");
require_once(dirname(__FILE__)."/../include/outils.php");
require_once(dirname(__FILE__)."/../include/tete_pied.php");
require_once(dirname(__FILE__)."/../include/verification_noms.php");
require_once(dirname(__FILE__)."/creation_bdd.php");
//sarra add: confedit.class.php
require_once(dirname(__FILE__)."/../../site_config/confedit.class.php");

$_SESSION['section'] = "installation";

lire_fichier_configuration(dirname(__FILE__)."/../../site_config/config.php");
//lire_fichier_configuration("../../site_config/site_config.xml");
//sarra add this and decomment the line before

$_SESSION['langue'] = $langue;

$bdexist = tester_base(); // à faire avant l'initialisation des erreurs mais après lire_fichier_configuration

init_erreurs();

if ($bdexist) {
    if (tester_tables())
        erreur(BDD_EXISTE_DEJA);
}

if (isset($_POST['action'])) {
    if ($_POST['action'] == 'creation_bdd')
        creation_bdd();
    else
        erreur('Action inconnue');
    
} else {
    debut_html(INITIALISATION, INITIALISATION);
    $jeton = getJeton();
    
    echo '<form method="POST" action="index.php">';
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="creation_bdd">'."\n";
    echo '<table border="0">'."\n";
    
    $handle = opendir('../../config');
    while ( $fichier = readdir($handle) )
        if ($fichier != '.' and $fichier != '..' and is_dir('../../config/'.$fichier))
            $fichiers_configuration_jaxe[] = $fichier;
    closedir($handle);
    echo '<tr><td>'.CONFIGURATION_PAR_DEFAUT.'</td>';
    echo '<td><select name="chemin_configuration_jaxe">';
    echo '<option value="'.$_SESSION['chemin_configuration_jaxe'].'">'.$_SESSION['chemin_configuration_jaxe'].'</option>';
    for ( $i = 0; $i < count($fichiers_configuration_jaxe); $i++ )
    {
        $nom = $fichiers_configuration_jaxe[$i];
        if ($nom != $_SESSION['chemin_configuration_jaxe'])
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo "</select></td></tr>\n";
    
    $handle = opendir('../../langues');
    while ( $fichier = readdir($handle) )
        if (substr($fichier, strlen($fichier) - 4) === '.php')
            $fichiers_langue[] = basename($fichier, '.php');
    closedir($handle);
    echo '<tr><td>'.LANGUE.'</td>';
    echo '<td><select name="langue">';
    echo '<option value="'.$langue.'">'.$langue.'</option>';
    for ( $i = 0; $i < count($fichiers_langue); $i++ )
    {
        $nom = $fichiers_langue[$i];
        if ($nom != $langue)
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo "</select></td></tr>\n";
    
    echo '<tr><td>'.SERVEUR_WEB.'</td><td><input type="text" name="serveur" value="localhost" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.NOM_BASE_DONNEES.'</td><td><input type="text" name="base" value="webjaxe" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.LOGIN_BD.'</td><td><input type="text" name="utilisateur" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.PASSWD_BD.'</td><td><input type="password" name="mot_de_passe" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>'."\n";
    echo '<tr><td>'.PRENOM_ADMIN.'</td><td><input type="text" name="prenom_admin" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.NOM_ADMIN.'</td><td><input type="text" name="nom_admin" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.LOGIN_ADMIN.'</td><td><input type="text" name="login_admin" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.PASSWD_ADMIN.'</td><td><input type="password" name="passwd_admin" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.EMAIL_ADMIN.'</td><td><input type="text" name="email_admin" value="" class="texte"></td></tr>'."\n";
    echo '<tr><td><h3>'.GESTION_MAIL.'</h3></td></tr>'."\n";
    echo '<tr><td>'.PAS_MAIL.'</td><td><input type="radio" name="choix_du_mail" value="PAS_MAIL" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.UTILISER_MAIL_PHP.'</td><td><input type="radio" name="choix_du_mail" value="UTILISER_MAIL_PHP" class="texte"></td></tr>'."\n";
    echo '<tr><td>'.UTILISER_SMTP.'</td><td><input type="radio" name="choix_du_mail" value="UTILISER_SMTP" class="texte">';
    echo '&nbsp;&nbsp;&nbsp;'.SERVEUR_SMTP.': <input type="text" name="nom_du_serveur_smtp" value="" class="texte"></td></tr>'."\n";
    echo "</table>\n";
    echo '<input type="submit" name="button" value="'.CREER_BD.'">'."\n";
    echo '</form>'."\n";
    
    fin_html();
}

?>
