<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

function verifie_nom_fichier_upload($nom_fichier)
{
    if (! preg_match ("/^[-_\.0-9a-zA-Z]{1,}\.[-_0-9a-zA-Z]*$/", $nom_fichier))
        erreur(NOM_DE_FICHIER);
    return true;
}

function verifie_nom_dossier_creation($nom_dossier)
{
    if (! preg_match ("/^[-_0-9a-zA-Z]+$/", $nom_dossier))
        erreur(NOM_DE_DOSSIER);
    return true;
}

function verifie_nom_dossier_liste($nom_dossier)
{
    if (! preg_match ("/^[-_0-9a-zA-Z]+$/", $nom_dossier))
        return false;
    return true;
}

function verifie_nom_contribution($nom_contribution)
{
    if (! preg_match ("/^[-0-9a-z]{1,30}$/", $nom_contribution))
        erreur(NOM_DE_CONTRIBUTION);
    return true;
}

function verifie_nom_config($nom_config)
{
    if (! preg_match ("/^[-_0-9a-zA-Z]+$/", $nom_config))
        erreur(NOM_CONFIG);
    return true;
}

function prenom_utilisateur($prenom)
{
    if (! preg_match ("/^[-_a-zA-Zàâäçéèêëîïôöùûü 0-9]{1,20}$/", $prenom))
        erreur(VERIFIE_PRENOM_UTILISATEUR);
    return true;
}


function nom_utilisateur($nom)
{
    if (! preg_match ("/^[-_a-zA-Zàâäçéèêëîïôöùûüÿ 0-9]{1,20}$/", $nom))
        erreur(VERIFIE_NOM_UTILISATEUR);
    return true;
}

function login_utilisateur($login)
{
    if (! preg_match ("/^[-_a-z0-9]{4,16}$/", $login))
        erreur(VERIFIE_LOGIN_UTILISATEUR);
    return true;
}

function password_utilisateur($password)
{
    if (! preg_match ("/^[-_0-9a-zA-Zàâäçéèêëîïôöùûü ]{4,30}$/", $password))
        erreur(VERIFIE_PASSWORD_UTILISATEUR);
    return true;
}

function verifie_email($email)
{
    if (! preg_match ("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/", $email))
        erreur(VERIFIE_EMAIL_UTILISATEUR);
    return true;
}

function verifie_langue($langue)
{
    $liste_langues = lire_liste_langues();
    foreach ($liste_langues as $l) {
        if ($l == $langue)
            return(true);
    }
    return(false);
}

function verifie_titre_projet($titre)
{
    if (! preg_match ("/^[-_a-zA-Zàâäçéèêëîïôöùûü 0-9]{1,40}$/", $titre))
        erreur(VERIFIE_TITRE_PROJET);
    return true;
}

function verifie_id($id)
{
    if (! preg_match ("/^[0-9]{1,20}$/", $id))
        erreur(VERIFIE_ID);
    return true;
}

?>
