<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

//--------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------- requetes SQL utilisateurs -------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------

// Effectue une requête sur la table des utilisateurs
// Sélectionne les utilisateurs avec les champs id, login et motdepasse donnés en paramètres
// (sélectionne tous les utilisateurs si aucune valeur de champ n'est donnée)
function requete_lire_utilisateurs($lien_bdd,$id_utilisateur=false, $login_utilisateur=false, $motdepasse=false, $status=false)
{
    $requete = "SELECT * FROM utilisateurs";
    if ($id_utilisateur!=false || $login_utilisateur!=false || $motdepasse!=false || $status!=false)
        $requete .= " WHERE ";
    if ($id_utilisateur!=false)
        $requete .= "id='$id_utilisateur'";
    if ($login_utilisateur!=false) {
        if ($id_utilisateur!=false)
            $requete .= " AND ";
        $requete .= "login='$login_utilisateur'";
    }
    if ($motdepasse!=false) {
        if ($id_utilisateur!=false || $login_utilisateur!=false)
            $requete .= " AND ";
        $requete .= "motdepasse='$motdepasse'";
    }
    if ($status!=false) {
        if ($id_utilisateur!=false || $login_utilisateur!=false || $motdepasse!=false)
            $requete .= " AND ";
        $requete .= "status='$status'";
    }
    $requete .= " ORDER BY nom";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_ajouter_utilisateur($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email, $editeur='Jaxe')
{
    $requete = "INSERT INTO utilisateurs VALUES ('',";
    foreach (array('prenom', 'nom', 'login', 'status', 'motdepasse', 'langue', 'email', 'editeur') as $champ) {
        if ($champ != 'email' && $champ != 'editeur' && $$champ == false)
            return(false);
        $requete .= "'".addslashes($$champ)."'";
        if ($champ != 'editeur')
            $requete .= ",";
    }
    $requete .= ")";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_modifier_utilisateur($lien_bdd,$id, $prenom, $nom, $login, $status, $motdepasse, $langue, $email, $editeur=false)
{
    $requete = "UPDATE utilisateurs SET ";
    $premier = true;
    foreach (array('prenom', 'nom', 'login', 'status', 'motdepasse', 'langue', 'email', 'editeur') as $champ) {
        if ($$champ != false) {
            if ($premier)
                $premier = false;
            else
                $requete .= ",";
            $requete .= $champ."='".addslashes($$champ)."'";
        }
    }
    $requete .= " WHERE id='$id'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_supprimer_utilisateur($lien_bdd,$id_utilisateur)
{
    if ($id_utilisateur == false)
        return(false);
    $requete = "DELETE FROM utilisateurs WHERE utilisateurs.id= '$id_utilisateur'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

//remplacée par une autre fonction qui tient en compte les sous projet qui ne sont pas dans la table participant
//requete pour obtenir l'id_profile de l'utilisateur
/*function requete_profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur)
{
	$requete = "SELECT id_profile FROM participants WHERE id_projet = ".$id_projet. " AND id_utilisateur = ".$id_utilisateur;
	$resultat = executer_requete($requete,$lien_bdd);
	$id_profile = lire_premier_resultat($resultat,'id_profile');
	return ($id_profile);
	
}*/

//---------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------- requetes SQL demandes inscription ------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------------

function requete_lire_inscription($lien_bdd,$id_demande=false, $login=false)
{
    $requete = "SELECT * FROM demandes_inscription";
    if ($id_demande!=false || $login!=false)
        $requete .= " WHERE ";
    if ($id_demande!=false)
        $requete .= "id = '$id_demande'";
    if ($login!=false) {
        if ($id_demande!=false)
            $requete .= " AND ";
        $requete .= "login = '$login'";
    }
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}


function requete_ecrire_inscription($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email)
{
    $requete = "INSERT INTO demandes_inscription VALUES ('',";
    foreach (array('prenom', 'nom', 'login', 'status', 'motdepasse', 'langue', 'email') as $champ) {
        if ($champ != 'email' && $$champ == false)
            return(false);
        $requete .= "'".addslashes($$champ)."'";
        if ($champ != 'email')
            $requete .= ",";
    }
    $requete .= ")";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}


function requete_supprimer_inscription($lien_bdd,$id)
{
    $requete = "DELETE FROM demandes_inscription WHERE id = '$id'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}


//-------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------- fonctions ----------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------------

// retourne un tableau avec les champs de l'utilisateur
function utilisateur($lien_bdd=false,$id)
{
    $resultat_lire_utilisateurs = requete_lire_utilisateurs($lien_bdd,$id);
    if ( tester_resultat($resultat_lire_utilisateurs) == FALSE )
        erreur(ECHEC_DONNEES_UTILISATEURS);
    $utilisateur = lire_premier_resultat($resultat_lire_utilisateurs);
    return($utilisateur);
}


// retourne un tableau avec les champs de la demande d'inscription
function demande($lien_bdd,$id)
{
    $resultat_lire_inscription = requete_lire_inscription($lien_bdd,$id);
    if ( tester_resultat($resultat_lire_inscription) == FALSE )
        erreur(ECHEC_DONNEES_POSTULANT_UTILISATEURS);
    $utilisateur = lire_premier_resultat($resultat_lire_inscription);
    return($utilisateur);
}

// supprimer les liens avec les projets d'un utilisateur
// paramètre : un numero id de l'utilisateur
// sortie : la veleur booléenne true en cas de réussite
function supprimer_participations($lien_bdd,$id_utilisateur)
{
    $resultat_requete = requete_supprimer_participants($lien_bdd,false, $id_utilisateur);
    if (!tester_resultat($resultat_requete))
        erreur(ECHEC_REQUETE.' supprimer_participations '.$id_utilisateur);
    return(true);
}

// Supprime l'utilisateur avec l'id en paramètre
// (tables modifiées : utilisateurs, participants)
function suprimer_utilisateur($lien_bdd,$id)
{
    supprimer_participations($lien_bdd,$id);
    $utilisateur = utilisateur($lien_bdd,$id);
    $resultat_suppression = requete_supprimer_utilisateur($lien_bdd,$id);
    if ( tester_resultat($resultat_suppression) == FALSE )
        erreur(ECHEC_SUPRIMER_UTILISATEUR);
    return(true);
}


// Renvoie un tableau de tous les utilisateurs, avec un tableau des champs pour chaque utilisateur,
// ou FALSE s'il n'y a pas d'utilisateur
function liste_des_utilisateurs($lien_bdd=false)
{
    // Pour les utilisateurs déjà inscrits
   $resultat_requete = requete_lire_utilisateurs($lien_bdd,false);
    if ( tester_resultat($resultat_requete) == FALSE )
        erreur(ECHEC_LISTE_UTILISATEUR);
    $liste = lire_le_resultat($resultat_requete);
    return($liste);
}


// Renvoie un tableau des utilisateurs administrateurs
function liste_administrateurs($lien_bdd=false)
{
    // Trouver les utilisateurs avec un status administrateur
   $resultat_requete = requete_lire_utilisateurs($lien_bdd,false, false, false, 'administrateur');
    if ( tester_resultat($resultat_requete) == FALSE )
        erreur(ECHEC_LISTE_UTILISATEUR);
    $liste = lire_le_resultat($resultat_requete);
    return($liste);
}


// Renvoie un tableau des demandes d'inscription, avec un tableau des champs pour chaque demande,
// ou FALSE s'il n'y a pas de demande d'inscription.
function liste_des_demandes($lien_bdd=false)
{
    // Pour les utilsiateurs en attente de validation    
    $resultat_liste_des_demandes = requete_lire_inscription($lien_bdd);
    if ( tester_resultat($resultat_liste_des_demandes) == FALSE )
        erreur(ECHEC_LISTE_DEMANDES);
    $liste_des_demandes = lire_le_resultat($resultat_liste_des_demandes);
    return $liste_des_demandes;
}



function valider_utilisateur($lien_bdd,$id)
{
    // On recupère les données de l'utilisateur
    $utilisateur = demande($lien_bdd,$id);
    $login = $utilisateur['login'];
    $prenom = $utilisateur['prenom'];
    $nom = $utilisateur['nom'];
    $motdepasse = $utilisateur['motdepasse'];
    $status = $utilisateur['status'];
    $langue = $utilisateur['langue'];
    $email = $utilisateur['email'];
    // On vérifie si l'utilisateur n'existe pas déjà
    $resultat_lire_utilisateur = requete_lire_utilisateurs($lien_bdd,false, $login);
    if ( tester_resultat($resultat_lire_utilisateur) == FALSE )
        erreur(ECHEC_UTILISATEUR_EXISTANT);
    if ( nombre_de_lignes($resultat_lire_utilisateur) != 0 )
    {
        erreur(UTILISATEUR_EXISTANT);
    }
    else
    {  
        // Création de l'utilisateur
        $resultat_creer_utlisateur = requete_ajouter_utilisateur($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email);
        // A-t-on réussi à créer un utilisateur?
        if ( ! tester_resultat($resultat_creer_utlisateur) )
            erreur(ECHEC_CREATION_UTILISATEUR);
            
        // Envoi de mail à l'utilisateur si email existe
        $from = $_SESSION['email_admin'];
        if ($from != '' && $email != '') {
            $to = $email;
            $subject = WJ_INSCRIPTION_VALIDEE;
            $message = BONJOUR." ".ucfirst($prenom)." ".strtoupper($nom).",\n\n".VOTRE_INSCRIPTION_VALIDEE."\n\n".VOTRE_LOGIN." ".$login;
            envoi_mail($from, $to, $subject, $message);
        }
        
        // On retire l'utilisateur de la liste des utilisateurs en attente d'inscription
        $resultat_suppression_inscription = requete_supprimer_inscription($lien_bdd,$id);
        if ( ! tester_resultat($resultat_suppression_inscription) )
            erreur(ECHEC_SUPPRESSION_UTILISATEUR);
    }
}


function modifier_utilisateur($lien_bdd,$id, $prenom, $nom, $login, $status, $motdepasse, $langue, $email, $editeur=false)
{
    if ( $id == false || ($prenom == false && $nom == false && $login == false &&
            $status == false && $motdepasse == false && $langue == false && $email == false && $editeur == false) )
        erreur(VARIABLES_VIDES);
    $resultat_requete = requete_modifier_utilisateur($lien_bdd,$id, $prenom, $nom, $login, $status, $motdepasse, $langue, $email, $editeur);
    if ( tester_resultat($resultat_requete) == FALSE )
        erreur(ERREUR_MODIF_UTILISATEUR);
    else
        return(true);
}


function refuser_utilisateur($lien_bdd,$id)
{
    $resultat_suppression = requete_supprimer_inscription($lien_bdd,$id);
    if ( tester_resultat($resultat_suppression) == FALSE )
        erreur(ERREUR_REFUS);
    else
        return(true);
}



//paramètres : une chaine de caractère login, une chaine de caractere passwd
//sortie : tableau des champs de l'utilisateur correspondant, ou la valeur booléenne false
function se_loguer($login, $passwd)
{
    // On recupère le login et le mot de passe depuis le formulaire et on effectue la requête
    // pour trouver l'utilisateur correspondant
    $lien_bdd = connexion();
    $resultat_lire_utilisateurs = requete_lire_utilisateurs($lien_bdd,false,$login, $passwd);
    if ( tester_resultat($resultat_lire_utilisateurs) == FALSE )
        erreur(ECHEC_LISTE_UTILISATEUR);
    return lire_premier_resultat($resultat_lire_utilisateurs);
}


// vérifie qu'un utilisateur a le droit d'éditer une contribution
// sortie : true si autorisé, sinon lance une erreur
function verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution=false, $label_contrib=false)
{
    if ( isset($_SESSION['id_utilisateur']) == FALSE )
        erreur(PAS_AUTORISE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    if ($id_contribution == false && $label_contrib == false)
        erreur(PAS_AUTORISE);
    if ($id_contribution == false && $label_contrib != false)
        $id_contribution = id_contribution($lien_bdd,$label_contrib);
    $id_projet = id_projet_contribution($lien_bdd,$id_contribution);
    $id_profile = profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur);
    //print (isset($id_profile));
    if($id_profile == 1)
		return (true);
	else if (!isset($id_profile))
		erreur(PAS_AUTORISE);
	else if ($id_profile == 0)
		return (false);		
    else if ($id_profile == (-1))
		erreur(PAS_AUTORISE);
}

/*function profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur)
{
	if ($id_projet == false || $id_utilisateur == false)
		return(false);
	$id_profile = requete_profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur);
	return ($id_profile);
	
}*/

function profile_utilisateur($lien_bdd,$id_projet,$id_utilisateur)
{
	$projets_utilisateur = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur, true); // avec les sous-projets
	if ($projets_utilisateur)
	{
		foreach ($projets_utilisateur as $projet) 
		{
			if ($projet['id'] == $id_projet)
			{   
				$liste_projets_ancetres = liste_projets_ancetres($lien_bdd,$id_projet);
				if ($liste_projets_ancetres == null)
				{ 
					return($projet['id_profile']);
				}
				if (array_key_exists('id_profile', $projet)){
					//if ($projet['id_profile'] == 1)
						return($projet['id_profile']);
				}
				if (count($liste_projets_ancetres) > 0)
				{	
					foreach($liste_projets_ancetres as $projet_ancetre)
					{	
						$resultat_requete = requete_lire_participants($lien_bdd,$projet_ancetre['id'], $id_utilisateur);	
						if (nombre_de_lignes($resultat_requete) > 0)
						{
							$liste = lire_premier_resultat($resultat_requete);
							return($liste['id_profile']);
						}
						else  
							profile_utilisateur($lien_bdd,$projet_ancetre['id'],$id_utilisateur);
							
					}
				}
			}
		}
	}
	else return (-1);
}

function creation_compte_temporaire($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email)
{
    //lire_fichier_configuration("../site_config/site_config.xml");
    lire_fichier_configuration(dirname(__FILE__)."/../../site_config/config.php");
    
    $resultat_lire_utilisateurs = requete_lire_utilisateurs($lien_bdd,false, $login);
    if ( tester_resultat($resultat_lire_utilisateurs) == FALSE )
        erreur(ECHEC_REQUETE);
    $resultat_lire_inscriptions = requete_lire_inscription($lien_bdd,false, $_POST['login']);
    if ( tester_resultat($resultat_lire_inscriptions) == FALSE )
        erreur(ECHEC_REQUETE);
    if ( nombre_de_lignes($resultat_lire_utilisateurs) != 0 || nombre_de_lignes($resultat_lire_inscriptions) != 0 )
    {
       erreur(ERREUR_LOGIN_EXISTANT);
    }
    else
    {          
        // Création de l'utilisateur
        $resultat_ecrire_inscription = requete_ecrire_inscription($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email);
        // A-t-on réussi à créer un utilisateur?
        return tester_resultat($resultat_ecrire_inscription);
    }
}

// fusionne 2 ensembles d'utilisateurs en évitant les doublons
function fusion_utilisateurs($liste1, $liste2) {
    $liste = $liste1;
    foreach ($liste2 as $u2) {
        $id = $u2['id'];
        $trouve = false;
        foreach ($liste1 as $u1) {
            if ($u1['id'] == $id) {
                $trouve = true;
                break;
            }
        }
        if (!$trouve)
            array_push($liste, $u2);
    }
    return($liste);
}

?>
