<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

require_once(dirname(__FILE__)."/../../site_config/confedit.class.php");

// Lecture des paramètres depuis un fichier config.php et mise des paramètres du site dans une session
function lire_fichier_configuration($fichier_config)
{
    if (!is_file($fichier_config) && !is_readable($fichier_config) )
		die("FICHIER_PAS_OUVERT ".$fichier_config);
   
    $config = new ConfigEditor();
    $config->LoadFromFile($fichier_config);
    //Valeurs par défault
    $_SESSION['email_admin'] = "";
    $_SESSION['choix_du_mail'] = 'PAS_MAIL';
    $_SESSION['nom_du_serveur_smtp'] = ""; 
    
    $config_names = $config->GetVarNames();	
    foreach($config_names as $config_name)
    {
		$cfg_var = $config->GetVar($config_name);
		$cfg_name = $cfg_var[CE_VARNAME];
		
		if($cfg_name == 'cfg_confjaxe')
			$_SESSION['chemin_configuration_jaxe'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_dir_apercu')	
			$_SESSION['chemin_dossier_apercu'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_serveur_bdd')
			$_SESSION['serveur_base_de_donnes'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_name_bdd')
			$_SESSION['nom_base_de_donnes'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_login_bdd')
			$_SESSION['login_base_de_donnes'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_passwd_bdd')	
			$_SESSION['pass_base_de_donnes'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_langue_site')
			$_SESSION['langue_site'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_langue')
			$_SESSION['langue'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_email_admin')
			$_SESSION['email_admin'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_gestion_mail')
			$_SESSION['choix_du_mail'] = $cfg_var[CE_VARVALUE];
		if($cfg_name == 'cfg_serveur_smtp')
			$_SESSION['nom_du_serveur_smtp'] = $cfg_var[CE_VARVALUE];
		
		
	}

	if(isset($_SESSION['serveur_base_de_donnes']) && isset($_SESSION['nom_base_de_donnes']))
		$_SESSION['serveur_db'] = "mysql:host=".$_SESSION['serveur_base_de_donnes'].";dbname=".$_SESSION['nom_base_de_donnes'];

}

function editer_fichier_config($config,$config_file,$chemin_configuration_jaxe = false, $chemin_dossier_apercu =  false,
   $adresse_bdd = false, $nom_bdd = false, $login_bdd = false , $pass_bdd = false, $langue = false, $admin_mail = false, $mail_choice = false, $smtp_serveur = false)
{
	if($chemin_configuration_jaxe === false)
		$config->SetVar('cfg_confjaxe',$_SESSION['chemin_configuration_jaxe'],'CONFIGURATION_JAXE');
	else
		$config->SetVar('cfg_confjaxe',$chemin_configuration_jaxe,'CONFIGURATION_JAXE');
		
	if($chemin_dossier_apercu === false)
		$config->SetVar('cfg_dir_apercu',$_SESSION['chemin_dossier_apercu'],'DOSSIER_APERCU');
	else
		$config->SetVar('cfg_dir_apercu',$chemin_dossier_apercu,'DOSSIER_APERCU');
	
	if($adresse_bdd === false)
		$config->SetVar('cfg_serveur_bdd',$_SESSION['serveur_base_de_donnes'],'SERVEUR_BDD');
	else
		$config->SetVar('cfg_serveur_bdd',$adresse_bdd,'SERVEUR_BDD');
	
	if($nom_bdd === false)
		$config->SetVar('cfg_name_bdd',$_SESSION['nom_base_de_donnes'],'NOM_BDD');
	else
		$config->SetVar('cfg_name_bdd',$nom_bdd,'NOM_BDD');
		
	if($login_bdd === false)
		$config->SetVar('cfg_login_bdd',$_SESSION['login_base_de_donnes'],'LOGIN_BDD');
	else
		$config->SetVar('cfg_login_bdd',$login_bdd,'LOGIN_BDD');
	
	if($pass_bdd === false)
		$config->SetVar('cfg_passwd_bdd',$_SESSION['pass_base_de_donnes'],'PASS_BDD');
	else
		$config->SetVar('cfg_passwd_bdd',$pass_bdd,'PASS_BDD');
	
	if($langue === false)
	{
		$config->SetVar('cfg_langue_site',$_SESSION['langue'],'LANGUE');
		$config->SetVar('cfg_langue',$_SESSION['langue'],'LANGUE');
	}
	else
	{
		$config->SetVar('cfg_langue_site',$langue,'LANGUE');
		$config->SetVar('cfg_langue',$langue,'LANGUE');
		
	}
	if($admin_mail === false)
		$config->SetVar('cfg_email_admin',$_SESSION['email_admin'],'EMAIL_ADMIN');
	else
		$config->SetVar('cfg_email_admin',$admin_mail,'EMAIL_ADMIN');
		
	if($mail_choice === false)
		$config->SetVar('cfg_gestion_mail',$_SESSION['choix_du_mail'],'GESTION_MAIL');
	else
		$config->SetVar('cfg_gestion_mail',$mail_choice,'GESTION_MAIL');
	
	if($smtp_serveur === false)
		$config->SetVar('cfg_serveur_smtp',$_SESSION['nom_du_serveur_smtp'],'GESTION_MAIL_SERVEUR');
	else
		$config->SetVar('cfg_serveur_smtp',$smtp_serveur,'GESTION_MAIL_SERVEUR');
    
    $config->Save($config_file);
}

function conversion_xml_php($fichier_config_xml, $fichier_config_php)
{
	if ( is_file($fichier_config_xml) && is_readable($fichier_config_xml) )
        $data = implode("", file($fichier_config_xml));
    else
        return (FALSE);
    $xml_parser = xml_parser_create();
    $res = xml_parse_into_struct($xml_parser, $data, $values);
    xml_parser_free($xml_parser);
    if ($res != 1)
        die(FICHIER_PAS_OUVERT);
   
    $config = new ConfigEditor();
    
    foreach ($values as $elem) {
        $nom = $elem['tag'];
        if (isset($elem['value']))
            $valeur = $elem['value'];
        else
            $valeur = '';
        
        if ( $nom == 'CONFIGURATION_JAXE' )
			$config->SetVar('cfg_confjaxe',$valeur,$nom);
		
        
        if ( $nom == 'DOSSIER_APERCU' )
            $config->SetVar('cfg_dir_apercu',$valeur,$nom);
        
        //if ( $nom == "DOSSIER_INTERFACE" )
        //    $_SESSION['chemin_dossier_interface'] = $valeur;
        
        if ( $nom == 'SERVEUR_BDD' )
            $config->SetVar('cfg_serveur_bdd',$valeur,$nom);
        
        if ( $nom == 'NOM_BDD' )
            $config->SetVar('cfg_name_bdd',$valeur,$nom);
        
        if ( $nom == 'LOGIN_BDD' )
           $config->SetVar('cfg_login_bdd',$valeur,$nom);
        
        if ( $nom == 'PASS_BDD' )
            $config->SetVar('cfg_passwd_bdd',$valeur,$nom);
    
        if ( $nom == 'LANGUE' ) {
            $config->SetVar('cfg_langue_site',$valeur,$nom);
		    $config->SetVar('cfg_langue',$valeur,$nom);
        }
            
        if ( $nom == 'EMAIL_ADMIN' )
            $config->SetVar('cfg_email_admin',$valeur,$nom);
            
        if ( $nom == 'GESTION_MAIL' )
            $config->SetVar('cfg_gestion_mail',$valeur,$nom); 
            
        if ( $nom == 'SERVEUR_SMTP' )
            $config->SetVar('cfg_serveur_smtp',$valeur,$nom);
    }
    
    $config->Save($fichier_config_php);
	//unlink(realpath($fichier_config_xml));
	rename(realpath($fichier_config_xml),realpath($fichier_config_xml).".bak");
}

?>
