/*
 * Decompiled with CFR 0.152.
 */
package jaxeapplet;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellDictionaryDichoMem
extends SpellDictionaryASpell {
    private StringBuffer dico = null;
    private int pos = -1;

    public SpellDictionaryDichoMem(URL wordList, String encoding) throws IOException {
        super((Reader)null);
        this.dico = this.lectureDico(wordList, encoding);
    }

    public SpellDictionaryDichoMem(URL wordList, URL phonetic, String encoding) throws IOException {
        super(new BufferedReader(new InputStreamReader(phonetic.openConnection().getInputStream(), encoding)));
        this.dico = this.lectureDico(wordList, encoding);
    }

    private StringBuffer lectureDico(URL u, String encoding) throws IOException {
        int l;
        URLConnection conn = u.openConnection();
        int clength = conn.getContentLength();
        StringBuffer sbuff = clength != -1 ? new StringBuffer(clength) : new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
        char[] cbuf = new char[1024];
        while ((l = reader.read(cbuf)) != -1) {
            sbuff.append(cbuf, 0, l);
        }
        reader.close();
        if (clength == -1) {
            sbuff.trimToSize();
        }
        return sbuff;
    }

    private void setPos(int offset) {
        this.pos = offset;
    }

    private int getPos() {
        return this.pos;
    }

    private String getLine() throws IOException {
        int p;
        int dicolength = this.dico.length();
        if (this.dico == null || dicolength <= this.pos) {
            throw new IOException("getLine(): unable to read line");
        }
        boolean lend = false;
        for (p = this.pos; p < dicolength && !lend; ++p) {
            char c = this.dico.charAt(p);
            lend = c == '\n' || c == '\r';
        }
        String line = this.dico.substring(this.pos, lend ? p - 1 : p);
        if (p < dicolength && (this.dico.charAt(p) == '\n' || this.dico.charAt(p) == '\r')) {
            ++p;
        }
        this.pos = p;
        return line;
    }

    @Override
    public void addWord(String word) {
        System.err.println("error: addWord is not implemented for SpellDictionaryDichoMem");
    }

    private LinkedList<String> dichoFind(String code, int p1, int p2) throws IOException {
        int pm = (p1 + p2) / 2;
        this.setPos(pm);
        String l = this.getLine();
        if (this.pos == this.dico.length()) {
            return new LinkedList<String>();
        }
        pm = this.getPos();
        l = this.getLine();
        int pm2 = this.getPos();
        if (pm2 >= p2) {
            return this.seqFind(code, p1, p2);
        }
        int istar = l.indexOf(42);
        if (istar == -1) {
            throw new IOException("bad format: no * !");
        }
        String testcode = l.substring(0, istar);
        int comp = code.compareTo(testcode);
        if (comp < 0) {
            return this.dichoFind(code, p1, pm - 1);
        }
        if (comp > 0) {
            return this.dichoFind(code, pm2, p2);
        }
        LinkedList<String> l1 = this.dichoFind(code, p1, pm - 1);
        LinkedList<String> l2 = this.dichoFind(code, pm2, p2);
        String word = l.substring(istar + 1);
        l1.add(word);
        l1.addAll(l2);
        return l1;
    }

    private LinkedList<String> seqFind(String code, int p1, int p2) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        this.setPos(p1);
        while (this.getPos() < p2) {
            String l = this.getLine();
            int istar = l.indexOf(42);
            if (istar == -1) {
                throw new IOException("bad format: no * !");
            }
            String testcode = l.substring(0, istar);
            if (!testcode.equals(code)) continue;
            list.add(l.substring(istar + 1));
        }
        return list;
    }

    @Override
    public List<String> getWords(String code) {
        LinkedList<String> list;
        try {
            list = this.dichoFind(code, 0, this.dico.length() - 1);
        }
        catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
            list = new LinkedList();
        }
        return list;
    }
}

