/*
 * Decompiled with CFR 0.152.
 */
package jaxeapplet;

import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import jaxe.ActionInsertionBalise;
import jaxe.AllowedElementsPanel;
import jaxe.ArbreXML;
import jaxe.AttributePanel;
import jaxe.Config;
import jaxe.EcouteurMAJ;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeException;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import jaxe.elements.JESwing;
import jaxeapplet.AppletSourceFrame;
import jaxeapplet.AppletValidationFrame;
import jaxeapplet.SpellDictionaryDichoMem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxeAppletFrame
extends JFrame
implements EcouteurMAJ {
    protected static boolean iconeValide = false;
    protected static ResourceBundle rb = JaxeResourceBundle.getRB();
    protected URL urlFichier;
    protected URL urlEnregistrement;
    protected JaxeDocument doc;
    protected JaxeTextPane textPane;
    protected JScrollPane paneScrollPane;
    protected JMenuBar barreInsertion;
    protected JTabbedPane sidepane;
    protected ArbreXML arbrexml;
    protected AllowedElementsPanel allowed;
    protected AttributePanel attpane;
    protected JSplitPane split;
    protected CaretListenerLabel caretListenerLabel;
    protected UndoAction monActionAnnuler;
    protected RedoAction monActionRetablir;
    protected boolean afficherSide = true;
    protected boolean afficherArbre = true;
    protected boolean afficherAllowed = true;
    protected boolean afficherAttributs = true;
    protected Action actionFermeture = null;
    protected AppletSourceFrame fenetreSource = null;
    protected AppletValidationFrame fenetreValidation = null;
    protected URL urlDictionnaire = null;
    protected URL urlPhonetique = null;

    public JaxeAppletFrame(URL urlCfg, URL urlFichier, URL urlEnregistrement, URL urlDictionnaire, URL urlPhonetique, boolean nouveau) {
        super(urlFichier.getPath());
        this.urlFichier = urlFichier;
        this.urlEnregistrement = urlEnregistrement;
        this.urlDictionnaire = urlDictionnaire;
        this.urlPhonetique = urlPhonetique;
        if (nouveau) {
            try {
                this.doc = new JaxeDocument(new Config(urlCfg, true));
                this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
                this.doc.nouveau();
                this.doc.furl = urlFichier;
            }
            catch (JaxeException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), rb.getString("erreur.Erreur"), 0);
                this.doc = new JaxeDocument();
                this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            }
        } else {
            this.doc = new JaxeDocument();
            this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            this.doc.lire(urlFichier, urlCfg);
        }
        this.initGUI();
        if (!nouveau) {
            this.sidepane.setSelectedComponent(this.arbrexml);
        }
    }

    public JaxeAppletFrame(URL urlCfg, URL urlFichier, URL urlEnregistrement, boolean nouveau) {
        super(urlFichier.getPath());
        this.urlFichier = urlFichier;
        this.urlEnregistrement = urlEnregistrement;
        if (nouveau) {
            try {
                this.doc = new JaxeDocument(new Config(urlCfg, true));
                this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
                this.doc.nouveau();
                this.doc.furl = urlFichier;
            }
            catch (JaxeException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), rb.getString("erreur.Erreur"), 0);
                this.doc = new JaxeDocument();
                this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            }
        } else {
            this.doc = new JaxeDocument();
            this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            this.doc.lire(urlFichier, urlCfg);
        }
        this.initGUI();
        if (!nouveau) {
            this.sidepane.setSelectedComponent(this.arbrexml);
        }
    }

    public JaxeAppletFrame(URL urlCfg, Document documentDOM) {
        super("Jaxe");
        this.urlFichier = null;
        this.urlEnregistrement = null;
        if (documentDOM != null) {
            this.doc = new JaxeDocument();
            this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            this.doc.setDOMDoc(documentDOM, urlCfg);
        } else {
            try {
                this.doc = new JaxeDocument(new Config(urlCfg, true));
            }
            catch (JaxeException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), rb.getString("erreur.Erreur"), 0);
                this.doc = new JaxeDocument();
            }
            this.textPane = new JaxeTextPane(this.doc, this, iconeValide);
            this.doc.nouveau();
        }
        this.initGUI();
        if (documentDOM != null) {
            this.sidepane.setSelectedComponent(this.arbrexml);
        }
    }

    public Document getDocumentDOM() {
        return this.doc.DOMdoc;
    }

    public URL getURLEnregistrement() {
        return this.urlEnregistrement;
    }

    public AppletSourceFrame getSourceFrame() {
        return this.fenetreSource;
    }

    public void setSourceFrame(AppletSourceFrame sourceFrame) {
        this.fenetreSource = sourceFrame;
    }

    public Reader getReader() throws IOException {
        return this.doc.getReader();
    }

    public void sendToWriter(Writer destination) {
        this.doc.sendToWriter(destination);
    }

    public void setActionFermeture(Action actionFermeture) {
        this.actionFermeture = actionFermeture;
    }

    protected void initGUI() {
        int hauteur;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JaxeAppletFrame.this.fermer();
            }
        });
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.caretListenerLabel = new CaretListenerLabel(" ", this.doc);
        contentPane.add((Component)this.caretListenerLabel, "South");
        if (this.doc.cfg != null) {
            this.setupMenuBar();
        }
        this.textPane.ajouterEcouteurAnnulation(this);
        this.paneScrollPane = new JScrollPane(this.textPane);
        this.paneScrollPane.setVerticalScrollBarPolicy(22);
        this.paneScrollPane.setPreferredSize(new Dimension(500, 400));
        this.paneScrollPane.setMinimumSize(new Dimension(100, 50));
        this.modifierSide();
        this.textPane.addCaretListener(this.caretListenerLabel);
        Dimension ecran = this.getToolkit().getScreenSize();
        int largeur = ecran.width * 2 / 3;
        if (largeur < 750) {
            largeur = ecran.width - 20;
        }
        if ((hauteur = ecran.height * 3 / 4) < 550) {
            hauteur = ecran.height - 50;
        }
        this.setSize(new Dimension(largeur, hauteur));
        this.setLocation((ecran.width - largeur) / 2, (ecran.height - hauteur) / 2);
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                JaxeAppletFrame.this.textPane.requestFocusInWindow();
            }
        });
    }

    protected void setupMenuBar() {
        this.barreInsertion = this.doc.cfg.makeMenus(this.doc);
        int cmdMenu = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menuFichier = new JMenu(rb.getString("menus.Fichier"));
        if (this.urlEnregistrement != null) {
            JMenuItem miEnregistrer = menuFichier.add(new ActionEnregistrer());
            miEnregistrer.setAccelerator(KeyStroke.getKeyStroke(83, cmdMenu));
            menuFichier.addSeparator();
        }
        JMenuItem miSource = menuFichier.add(new ActionSource());
        JMenuItem miValider = menuFichier.add(new ActionValider());
        menuFichier.addSeparator();
        JMenuItem miFermer = menuFichier.add(new ActionFermer());
        miFermer.setAccelerator(KeyStroke.getKeyStroke(87, cmdMenu));
        this.barreInsertion.add((Component)menuFichier, 0);
        JMenu menuEdition = new JMenu(rb.getString("menus.Edition"));
        this.monActionAnnuler = new UndoAction();
        JMenuItem miAnnuler = menuEdition.add(this.monActionAnnuler);
        miAnnuler.setAccelerator(KeyStroke.getKeyStroke(90, cmdMenu));
        this.monActionRetablir = new RedoAction();
        JMenuItem miRetablir = menuEdition.add(this.monActionRetablir);
        miRetablir.setAccelerator(KeyStroke.getKeyStroke(82, cmdMenu));
        menuEdition.addSeparator();
        DefaultEditorKit.CutAction actionCouper = new DefaultEditorKit.CutAction();
        actionCouper.putValue("Name", rb.getString("menus.Couper"));
        JMenuItem miCouper = menuEdition.add(actionCouper);
        miCouper.setAccelerator(KeyStroke.getKeyStroke(88, cmdMenu));
        DefaultEditorKit.CopyAction actionCopier = new DefaultEditorKit.CopyAction();
        actionCopier.putValue("Name", rb.getString("menus.Copier"));
        JMenuItem miCopier = menuEdition.add(actionCopier);
        miCopier.setAccelerator(KeyStroke.getKeyStroke(67, cmdMenu));
        DefaultEditorKit.PasteAction actionColler = new DefaultEditorKit.PasteAction();
        actionColler.putValue("Name", rb.getString("menus.Coller"));
        JMenuItem miColler = menuEdition.add(actionColler);
        miColler.setAccelerator(KeyStroke.getKeyStroke(86, cmdMenu));
        JMenuItem miToutSelectionner = menuEdition.add(new ActionToutSelectionner());
        miToutSelectionner.setAccelerator(KeyStroke.getKeyStroke(65, cmdMenu));
        menuEdition.addSeparator();
        JMenuItem miRechercher = menuEdition.add(new ActionRechercher());
        miRechercher.setAccelerator(KeyStroke.getKeyStroke(70, cmdMenu));
        JMenuItem miSuivant = menuEdition.add(new ActionSuivant());
        miSuivant.setAccelerator(KeyStroke.getKeyStroke(71, cmdMenu));
        if (this.urlDictionnaire != null) {
            menuEdition.addSeparator();
            menuEdition.add(new ActionOrthographe());
        }
        this.barreInsertion.add((Component)menuEdition, 1);
        if (this.barreInsertion != null) {
            this.setJMenuBar(this.barreInsertion);
        }
    }

    @Override
    public void miseAJour() {
        this.monActionAnnuler.updateUndoState();
        this.monActionRetablir.updateRedoState();
    }

    public void majMenus(int pos) {
        if (this.doc.cfg == null || this.barreInsertion == null || this.textPane.getIgnorerEdition()) {
            return;
        }
        JaxeElement parent = null;
        if (this.doc.rootJE != null) {
            parent = this.doc.rootJE.elementA(pos);
        }
        if (parent != null && parent.debut.getOffset() == pos && !(parent instanceof JESwing)) {
            parent = parent.getParent();
        }
        if (parent != null && parent.noeud.getNodeType() == 3) {
            parent = parent.getParent();
        }
        ArrayList<Element> autorisees = null;
        Config parentconf = null;
        if (parent == null) {
            parentconf = this.doc.cfg;
            autorisees = this.doc.cfg.listeElementsRacines();
        } else if (parent.noeud.getNodeType() == 8) {
            parentconf = this.doc.cfg;
            autorisees = new ArrayList();
        } else {
            Element parentref = parent.refElement;
            if (parentref == null) {
                return;
            }
            parentconf = this.doc.cfg.getRefConf(parentref);
            ArrayList<Element> sousElements = parentconf.listeSousElements(parentref);
            if (sousElements != null) {
                autorisees = new ArrayList();
                int debutSelection = this.textPane.getSelectionStart();
                int finSelection = this.textPane.getSelectionEnd();
                for (Element ref : sousElements) {
                    if (parentconf != null && parent != null && !parentconf.insertionPossible(parent, debutSelection, finSelection, ref)) continue;
                    autorisees.add(ref);
                }
            }
        }
        for (int i = 2; i < this.barreInsertion.getMenuCount(); ++i) {
            JMenu menu = this.barreInsertion.getMenu(i);
            this.majMenu(menu, parentconf, autorisees);
        }
    }

    protected boolean majMenu(JMenu menu, Config parentconf, ArrayList<Element> autorisees) {
        boolean anyenab = false;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            Action action = item.getAction();
            if (action instanceof ActionInsertionBalise) {
                Element refElement = ((ActionInsertionBalise)action).getRefElement();
                if (refElement == null) continue;
                Config conf = this.doc.cfg.getRefConf(refElement);
                String nomElement = conf.nomElement(refElement);
                if (conf == parentconf) {
                    boolean enable = false;
                    for (Element ref : autorisees) {
                        if (!nomElement.equals(this.doc.cfg.nomElement(ref))) continue;
                        enable = true;
                        anyenab = true;
                        if (refElement == ref) break;
                        ((ActionInsertionBalise)action).setRefElement(ref);
                        break;
                    }
                    action.setEnabled(enable);
                    continue;
                }
                action.setEnabled(true);
                continue;
            }
            if (!(item instanceof JMenu)) continue;
            anyenab = this.majMenu((JMenu)item, parentconf, autorisees) || anyenab;
        }
        if (!menu.isTopLevelMenu()) {
            menu.setEnabled(anyenab);
        }
        return anyenab;
    }

    public void setAffichageSide(boolean visible) {
        if (this.afficherSide != visible) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherSide = visible;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageSide() {
        return this.afficherSide;
    }

    public void setAffichageArbre(boolean visible) {
        if (this.afficherArbre != visible) {
            if (!visible) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherArbre = visible;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageArbre() {
        return this.afficherArbre;
    }

    public void setAffichageAllowed(boolean visible) {
        if (this.afficherAllowed != visible) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (!visible) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (this.afficherAttributs) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherAllowed = visible;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageAllowed() {
        return this.afficherAllowed;
    }

    public void setAffichageAttributs(boolean visible) {
        if (this.afficherAttributs != visible) {
            if (this.afficherArbre) {
                this.textPane.retirerEcouteurArbre(this.arbrexml);
            }
            if (this.afficherAllowed) {
                this.textPane.retirerEcouteurArbre(this.allowed);
            }
            if (!visible) {
                this.textPane.retirerEcouteurArbre(this.attpane);
            }
            if (!this.afficherSide) {
                this.getContentPane().remove(this.paneScrollPane);
            } else {
                this.getContentPane().remove(this.split);
            }
            this.afficherAttributs = visible;
            this.afficherSide = this.afficherArbre || this.afficherAllowed || this.afficherAttributs;
            this.modifierSide();
            this.validate();
            this.textPane.getCaret().setVisible(true);
        }
    }

    public boolean getAffichageAttributs() {
        return this.afficherAttributs;
    }

    protected void modifierSide() {
        if (this.afficherSide) {
            this.sidepane = new JTabbedPane();
            if (this.afficherAllowed) {
                this.allowed = new AllowedElementsPanel((JaxeDocument)this.textPane.getDocument());
                this.textPane.addCaretListener(this.allowed);
                this.textPane.ajouterEcouteurArbre(this.allowed);
                this.sidepane.addTab(rb.getString("tabs.insertion"), this.allowed);
            } else {
                this.allowed = null;
            }
            if (this.afficherArbre) {
                this.arbrexml = new ArbreXML(this.doc);
                this.textPane.ajouterEcouteurArbre(this.arbrexml);
                this.sidepane.addTab(rb.getString("tabs.arbre"), this.arbrexml);
            } else {
                this.arbrexml = null;
            }
            if (this.afficherAttributs) {
                this.attpane = new AttributePanel((JaxeDocument)this.textPane.getDocument());
                this.textPane.addCaretListener(this.attpane);
                this.textPane.ajouterEcouteurArbre(this.attpane);
                this.sidepane.addTab(rb.getString("tabs.attributs"), this.attpane);
            } else {
                this.attpane = null;
            }
            this.split = new JSplitPane(1);
            this.split.setLeftComponent(this.sidepane);
            this.split.setRightComponent(this.paneScrollPane);
            this.split.setDividerLocation(275);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.sidepane = null;
            this.arbrexml = null;
            this.allowed = null;
            this.attpane = null;
            this.getContentPane().add((Component)this.paneScrollPane, "Center");
        }
    }

    protected void fermer() {
        if (this.doc != null && this.doc.modif && this.urlEnregistrement != null) {
            JaxeAppletFrame parent = System.getProperty("os.name").startsWith("Mac OS") ? null : this;
            int r = JOptionPane.showConfirmDialog(parent, rb.getString("fermeture.EnregistrerAvant"), rb.getString("fermeture.Fermeture"), 1);
            if (r == 0) {
                this.enregistrer();
            } else if (r == 2) {
                return;
            }
        }
        if (this.fenetreSource != null) {
            this.fenetreSource.setVisible(false);
        }
        if (this.fenetreValidation != null) {
            this.fenetreValidation.setVisible(false);
        }
        this.setVisible(false);
        if (this.actionFermeture != null) {
            this.actionFermeture.actionPerformed(new ActionEvent(this, 1001, "fermer"));
        }
        ImageKeeper.flushImages();
    }

    private static void write(OutputStream out, String s) throws IOException {
        out.write(s.getBytes("US-ASCII"));
    }

    public void enregistrer() {
        try {
            URLConnection urlConn = this.urlEnregistrement.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            String bound = "AaB03x";
            urlConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=AaB03x");
            BufferedOutputStream out = new BufferedOutputStream(urlConn.getOutputStream());
            JaxeAppletFrame.write(out, "--AaB03x\r\n");
            String chemin = URLDecoder.decode(this.urlFichier.getPath(), "UTF-8");
            JaxeAppletFrame.write(out, "Content-Disposition: form-data; name=\"chemin\"\r\n");
            JaxeAppletFrame.write(out, "Content-type: text/plain; charset=UTF-8\r\n");
            JaxeAppletFrame.write(out, "Content-transfer-encoding: 8bit\r\n\r\n");
            out.write(chemin.getBytes("UTF-8"));
            JaxeAppletFrame.write(out, "\r\n--AaB03x\r\n");
            JaxeAppletFrame.write(out, "Content-Disposition: form-data; name=\"contenu\"; filename=\"");
            out.write(chemin.getBytes("UTF-8"));
            JaxeAppletFrame.write(out, "\"\r\n");
            JaxeAppletFrame.write(out, "Content-Type: application/octet-stream\r\n\r\n");
            OutputStreamWriter nos = new OutputStreamWriter((OutputStream)out, this.doc.encodage);
            this.sendToWriter(nos);
            nos.flush();
            JaxeAppletFrame.write(out, "\r\n--AaB03x--\r\n\r\n");
            out.flush();
            out.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), "UTF-8"));
            String reponse = rd.readLine();
            if (reponse == null) {
                JOptionPane.showMessageDialog(null, "Erreur \u00e0 l'enregistrement: aucune r\u00e9ponse du serveur.", "Enregistrement", 0);
            } else if ("erreur".equals(reponse)) {
                String message = "<html><body><p>Erreur \u00e0 l'enregistrement:</p>";
                String ligne2 = rd.readLine();
                if (ligne2 != null) {
                    message = message + "<p>" + ligne2 + "</p>";
                    String ligne3 = rd.readLine();
                    if (ligne3 != null) {
                        message = message + "<p>" + ligne3 + "</p>";
                    }
                }
                message = message + "</body></html>";
                JOptionPane.showMessageDialog(null, message, "Enregistrement", 0);
            } else if ("ok".equals(reponse)) {
                JOptionPane.showMessageDialog(null, "Le fichier a bien \u00e9t\u00e9 enregistr\u00e9.", "Enregistrement", 1);
                this.doc.modif = false;
            } else {
                String message = "<html><body><p>Erreur \u00e0 l'enregistrement: r\u00e9ponse \u00e9trange du serveur:</p>";
                message = message + "<p>" + reponse + "</p>";
                String ligne2 = rd.readLine();
                if (ligne2 != null) {
                    message = message + "<p>" + ligne2 + "</p>";
                }
                message = message + "</body></html>";
                JOptionPane.showMessageDialog(null, message, "Enregistrement", 0);
            }
            rd.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Enregistrement", 0);
        }
    }

    class ActionOrthographe
    extends AbstractAction {
        public ActionOrthographe() {
            super(rb.getString("menus.Orthographe"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JaxeAppletFrame.this.urlDictionnaire == null) {
                JOptionPane.showMessageDialog(JaxeAppletFrame.this, JaxeResourceBundle.getRB().getString("erreur.Dictionnaire"));
                return;
            }
            String encoding = "ISO-8859-1";
            try {
                SpellDictionaryDichoMem dictionary = JaxeAppletFrame.this.urlPhonetique != null ? new SpellDictionaryDichoMem(JaxeAppletFrame.this.urlDictionnaire, JaxeAppletFrame.this.urlPhonetique, "ISO-8859-1") : new SpellDictionaryDichoMem(JaxeAppletFrame.this.urlDictionnaire, "ISO-8859-1");
                JTextComponentSpellChecker sc = new JTextComponentSpellChecker(dictionary);
                int status = sc.spellCheck(JaxeAppletFrame.this.textPane);
                if (status == -1) {
                    JOptionPane.showMessageDialog(JaxeAppletFrame.this, JaxeResourceBundle.getRB().getString("orthographe.aucuneErreur"));
                }
            }
            catch (Exception ex) {
                System.err.println("ActionOrthographe: " + ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
    }

    protected class ActionToutSelectionner
    extends TextAction {
        public ActionToutSelectionner() {
            super(rb.getString("menus.ToutSelectionner"));
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target instanceof JaxeTextPane) {
                ((JaxeTextPane)target).toutSelectionner();
            } else if (target != null) {
                target.selectAll();
            }
        }
    }

    protected class ActionSuivant
    extends TextAction {
        public ActionSuivant() {
            super(rb.getString("menus.RechercherSuivant"));
        }

        public void actionPerformed(ActionEvent e) {
            JaxeAppletFrame.this.textPane.suivant();
        }
    }

    protected class ActionRechercher
    extends TextAction {
        public ActionRechercher() {
            super(rb.getString("menus.Rechercher"));
        }

        public void actionPerformed(ActionEvent e) {
            JaxeAppletFrame.this.textPane.rechercher();
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        private JaxeDocument doc;

        public CaretListenerLabel(String label, JaxeDocument doc) {
            super(label);
            this.doc = doc;
        }

        public void caretUpdate(CaretEvent e) {
            int mark;
            int dot = e.getDot();
            if (dot == (mark = e.getMark())) {
                this.setText(dot + ": " + this.doc.getPathAsString(dot));
            }
            JaxeAppletFrame.this.majMenus(dot);
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(rb.getString("menus.Retablir"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            UndoManager undo = JaxeAppletFrame.this.textPane.getUndo();
            try {
                undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Impossible de r\u00e9tablir: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            JaxeAppletFrame.this.monActionAnnuler.updateUndoState();
        }

        protected void updateRedoState() {
            UndoManager undo = JaxeAppletFrame.this.textPane.getUndo();
            if (undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", rb.getString("menus.Retablir"));
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(rb.getString("menus.Annuler"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            JaxeAppletFrame.this.textPane.undo();
        }

        protected void updateUndoState() {
            UndoManager undo = JaxeAppletFrame.this.textPane.getUndo();
            if (undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", rb.getString("menus.Annuler"));
            }
        }
    }

    protected class ActionFermer
    extends AbstractAction {
        public ActionFermer() {
            super(rb.getString("menus.Fermer"));
        }

        public void actionPerformed(ActionEvent e) {
            JaxeAppletFrame.this.fermer();
        }
    }

    protected class ActionValider
    extends AbstractAction {
        public ActionValider() {
            super(rb.getString("menus.Validation"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JaxeAppletFrame.this.fenetreValidation == null) {
                JaxeAppletFrame.this.fenetreValidation = new AppletValidationFrame(JaxeAppletFrame.this.doc, JaxeAppletFrame.this);
            } else {
                JaxeAppletFrame.this.fenetreValidation.miseAJour();
            }
        }
    }

    protected class ActionSource
    extends AbstractAction {
        public ActionSource() {
            super(rb.getString("menus.Source"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JaxeAppletFrame.this.fenetreSource == null) {
                JaxeAppletFrame.this.fenetreSource = new AppletSourceFrame(JaxeAppletFrame.this.doc, JaxeAppletFrame.this);
            } else {
                JaxeAppletFrame.this.fenetreSource.miseAJour();
            }
        }
    }

    protected class ActionEnregistrer
    extends AbstractAction {
        public ActionEnregistrer() {
            super(rb.getString("menus.Enregistrer"));
        }

        public void actionPerformed(ActionEvent e) {
            JaxeAppletFrame.this.enregistrer();
        }
    }
}

