/*
 * Decompiled with CFR 0.152.
 */
package jaxeapplet;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jaxe.Jaxe;
import jaxeapplet.JaxeAppletFrame;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class JaxeApplet
extends JApplet {
    protected String scriptEnregistrement;
    protected String cheminConfig;
    protected JaxeAppletFrame frame;
    protected boolean editing;
    protected String fichierAEditer;
    protected boolean nouveau;
    protected String cheminDictionnaire;
    protected String cheminPhonetique;

    public void init() {
        if ("1.6.0_22".equals(System.getProperty("java.version"))) {
            ParserDelegator workaround = new ParserDelegator();
        }
        this.cheminConfig = this.getParameter("config");
        this.fichierAEditer = this.getParameter("fichier");
        String sNouveau = this.getParameter("nouveau");
        this.cheminDictionnaire = this.getParameter("dictionnaire");
        this.cheminPhonetique = this.getParameter("phonetique");
        this.scriptEnregistrement = this.getParameter("enregistrement");
        this.nouveau = sNouveau != null && !"".equals(sNouveau) && "oui".equals(sNouveau);
        this.editing = false;
        if (System.getProperty("os.name").startsWith("Mac OS") && System.getProperty("os.version").startsWith("10.5")) {
            UIManager.put("Panel.background", new Color(232, 232, 232));
            UIManager.put("Label.background", new Color(232, 232, 232));
            UIManager.put("SplitPane.background", new Color(232, 232, 232));
        }
        try {
            Class<?> catalogResolver = Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
            Constructor<?> cons = catalogResolver.getConstructor(null);
            Jaxe.setResolver(cons.newInstance(null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void start() {
        if (this.fichierAEditer != null) {
            this.editerFichier(this.fichierAEditer);
        }
    }

    public void stop() {
        if (this.frame != null) {
            if (this.editing) {
                this.frame.fermer();
            }
            this.frame.setActionFermeture(null);
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void editer(String texte) {
        this.editing = true;
        SwingUtilities.invokeLater(new Edition(texte));
    }

    protected void editer2(String texte) {
        Document ddoc = null;
        if (texte != null && !"".equals(texte)) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder docbuilder = dbf.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(texte));
                ddoc = docbuilder.parse(is);
            }
            catch (Exception ex) {
                String msg = "JaxeApplet : " + ex.getClass().getName() + " : " + ex.getMessage();
                JOptionPane.showMessageDialog(null, msg, "Lecture document", 0);
                return;
            }
        }
        try {
            URL urlCfg = new URL(this.getDocumentBase(), this.cheminConfig);
            this.frame = new JaxeAppletFrame(urlCfg, ddoc);
            this.frame.setActionFermeture(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    JaxeApplet.this.fermetureEdition();
                }
            });
            this.frame.setVisible(true);
        }
        catch (MalformedURLException ex) {
            String msg = ex.getClass().getName() + " : " + ex.getMessage();
            JOptionPane.showMessageDialog(null, msg, "Lecture config", 0);
        }
    }

    public void editerFichier(String nomFichier) {
        URL urlEnregistrement;
        URL urlCfg;
        URL urlFichier;
        URL urlPhonetique;
        URL urlDictionnaire;
        block11: {
            this.editing = true;
            urlDictionnaire = null;
            urlPhonetique = null;
            try {
                urlFichier = new URL(new URI(nomFichier).toASCIIString());
            }
            catch (Exception ex) {
                String msg = ex.getClass().getName() + " : " + ex.getMessage();
                msg = msg + "\n (nomFichier:" + nomFichier + ")";
                JOptionPane.showMessageDialog(null, msg, "URL du fichier", 0);
                return;
            }
            try {
                urlCfg = new URL(this.getDocumentBase(), this.cheminConfig);
            }
            catch (MalformedURLException ex) {
                String msg = ex.getClass().getName() + " : " + ex.getMessage();
                msg = msg + "\n (cheminConfig:" + this.cheminConfig + ")";
                JOptionPane.showMessageDialog(null, msg, "URL config de Jaxe", 0);
                return;
            }
            try {
                urlEnregistrement = new URL(this.getDocumentBase(), this.scriptEnregistrement);
            }
            catch (MalformedURLException ex) {
                String msg = ex.getClass().getName() + " : " + ex.getMessage();
                msg = msg + "\n (scriptEnregistrement:" + this.scriptEnregistrement + ")";
                JOptionPane.showMessageDialog(null, msg, "URL du script d'enregistrement", 0);
                return;
            }
            if (this.cheminDictionnaire != null && !"".equals(this.cheminDictionnaire)) {
                try {
                    urlDictionnaire = new URL(this.getDocumentBase(), this.cheminDictionnaire);
                    if (this.cheminPhonetique == null || "".equals(this.cheminPhonetique)) break block11;
                    try {
                        urlPhonetique = new URL(this.getDocumentBase(), this.cheminPhonetique);
                    }
                    catch (MalformedURLException ex) {
                        String msg = ex.getClass().getName() + " : " + ex.getMessage();
                        msg = msg + "\n (cheminPhonetique:" + this.cheminPhonetique + ")";
                        JOptionPane.showMessageDialog(null, msg, "URL phonetique", 0);
                        return;
                    }
                }
                catch (MalformedURLException ex) {
                    String msg = ex.getClass().getName() + " : " + ex.getMessage();
                    msg = msg + "\n (cheminDictionnaire:" + this.cheminDictionnaire + ")";
                    JOptionPane.showMessageDialog(null, msg, "URL dictionnaire", 0);
                    return;
                }
            }
        }
        this.frame = new JaxeAppletFrame(urlCfg, urlFichier, urlEnregistrement, urlDictionnaire, urlPhonetique, this.nouveau);
        this.frame.setActionFermeture(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JaxeApplet.this.fermetureEdition();
            }
        });
        this.frame.setVisible(true);
    }

    public void fermetureEdition() {
        this.editing = false;
    }

    public String getTexte() {
        if (this.frame == null) {
            System.err.println("JaxeApplet.getTexte : frame est null");
            return null;
        }
        StringWriter sw = new StringWriter();
        this.frame.sendToWriter(sw);
        return sw.toString();
    }

    public boolean getEditing() {
        return this.editing;
    }

    class Edition
    implements Runnable {
        private String texte;

        public Edition(String texte) {
            this.texte = texte;
        }

        public void run() {
            JaxeApplet.this.editer2(this.texte);
        }
    }
}

