/*
 * Decompiled with CFR 0.152.
 */
package jaxeapplet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.wxs.JaxeWXS;
import jaxeapplet.AppletSourceFrame;
import jaxeapplet.JaxeAppletFrame;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AppletValidationFrame
extends JFrame
implements MouseListener,
ActionListener {
    JaxeDocument doc;
    JaxeAppletFrame jframe;
    JEditorPane editorPane;
    String contenu;
    ArrayList<Erreur> erreurs;

    public AppletValidationFrame(JaxeDocument doc, JaxeAppletFrame jframe) {
        super(JaxeResourceBundle.getRB().getString("validation.Validation"));
        this.jframe = jframe;
        this.newdoc(doc);
    }

    public void newdoc(JaxeDocument doc) {
        this.doc = doc;
        if (doc.cfg == null) {
            JOptionPane.showMessageDialog(this.jframe, JaxeResourceBundle.getRB().getString("validation.Schema"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return;
        }
        Rectangle fr = this.jframe.getBounds();
        this.setLocation(fr.x + fr.width / 2, fr.y + fr.height / 2);
        this.setSize(new Dimension(620, 460));
        this.affichage();
        this.miseAJour();
    }

    protected void affichage() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(this.editorPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(600, 400));
        JPanel boutonsP = new JPanel();
        boutonsP.setLayout(new FlowLayout());
        JButton boutonMAJ = new JButton(JaxeResourceBundle.getRB().getString("validation.MiseAJour"));
        boutonMAJ.addActionListener(this);
        boutonsP.add(boutonMAJ);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)paneScrollPane, "Center");
        contentPane.add((Component)boutonsP, "North");
        this.setContentPane(contentPane);
        this.editorPane.addMouseListener(this);
    }

    protected void print(String s) {
        this.contenu = this.contenu + s;
    }

    protected void println(String s) {
        this.contenu = this.contenu + s + "\n";
    }

    public void miseAJour() {
        if (this.doc.cfg.schemaURL == null) {
            return;
        }
        this.contenu = "";
        this.erreurs = new ArrayList();
        if (this.doc.cfg.getSchema() instanceof JaxeWXS) {
            boolean[] terreur = new boolean[1];
            try {
                Document docClone = (Document)this.doc.DOMdoc.cloneNode(true);
                DOMConfiguration config = docClone.getDomConfig();
                config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
                config.setParameter("schema-location", this.doc.cfg.schemaURL.toURI().toString());
                config.setParameter("validate", Boolean.TRUE);
                terreur[0] = false;
                ErrorStorer ef = new ErrorStorer(terreur);
                config.setParameter("error-handler", ef);
                docClone.normalizeDocument();
            }
            catch (Exception e) {
                System.err.println("miseAJour(): " + e.getMessage());
                terreur[0] = true;
                this.print(e.getMessage());
            }
            if (!terreur[0]) {
                this.print(JaxeResourceBundle.getRB().getString("validation.parfait"));
            }
        } else {
            this.contenu = "Type de sch\u00e9ma non reconnu";
        }
        this.editorPane.setText(this.contenu);
        this.setVisible(true);
        this.editorPane.repaint();
    }

    protected Node chercherOriginal(Node clone) {
        Node n1;
        ArrayList<Integer> numeros = new ArrayList<Integer>();
        for (n1 = clone; n1 != null && n1.getNodeType() != 9; n1 = n1.getParentNode()) {
            int i = 0;
            for (Node n2 = n1.getPreviousSibling(); n2 != null; n2 = n2.getPreviousSibling()) {
                ++i;
            }
            numeros.add(i);
        }
        n1 = this.doc.DOMdoc;
        for (int i = numeros.size() - 1; i >= 0; --i) {
            if ((n1 = n1.getFirstChild()) == null) {
                System.err.println("AppletValidationFrame.chercherOriginal : impossible de retrouver le noeud d'origine (1)");
                System.err.println("numeros: " + numeros);
                return null;
            }
            int nb = (Integer)numeros.get(i);
            for (int j = 0; j < nb; ++j) {
                if (n1 == null) {
                    System.err.println("AppletValidationFrame.chercherOriginal : impossible de retrouver le noeud d'origine (2)");
                    System.err.println("numeros: " + numeros);
                    return null;
                }
                n1 = n1.getNextSibling();
            }
        }
        return n1;
    }

    public void actionPerformed(ActionEvent e) {
        this.miseAJour();
    }

    public void mouseClicked(MouseEvent e) {
        int pos = this.editorPane.viewToModel(e.getPoint());
        int p1 = 0;
        int p2 = 0;
        Node noeud = null;
        int ligne = 0;
        for (Erreur err : this.erreurs) {
            if (err.p1 > pos) {
                p2 = err.p1;
                break;
            }
            p1 = err.p1;
            noeud = err.noeud;
            ligne = err.ligne;
        }
        if (noeud == null) {
            if (ligne > 0) {
                if (this.jframe.getSourceFrame() == null) {
                    this.jframe.setSourceFrame(new AppletSourceFrame(this.doc, this.jframe));
                } else {
                    this.jframe.getSourceFrame().miseAJour();
                }
                this.jframe.getSourceFrame().selectLigne(ligne);
            }
            return;
        }
        if (p2 == 0) {
            p2 = this.contenu.length();
        }
        this.editorPane.setCaretPosition(p1);
        this.editorPane.moveCaretPosition(p2);
        if (noeud.getNodeType() != 1) {
            return;
        }
        final Element elsel = (Element)noeud;
        this.doc.textPane.selectElement(elsel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppletValidationFrame.this.doc.textPane.allerElement(elsel);
            }
        });
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class Erreur {
        public Node noeud;
        public int ligne;
        public int p1;

        public Erreur(Node noeud, int ligne, int p1) {
            this.noeud = noeud;
            this.ligne = ligne;
            this.p1 = p1;
        }
    }

    class ErrorStorer
    implements DOMErrorHandler {
        boolean[] terreur;

        public ErrorStorer(boolean[] terreur) {
            this.terreur = terreur;
        }

        public boolean handleError(DOMError err) {
            String severity;
            DOMLocator loc = err.getLocation();
            AppletValidationFrame.this.erreurs.add(new Erreur(AppletValidationFrame.this.chercherOriginal(loc.getRelatedNode()), loc.getLineNumber(), AppletValidationFrame.this.contenu.length()));
            this.terreur[0] = true;
            switch (err.getSeverity()) {
                case 1: {
                    severity = "Warning";
                    break;
                }
                case 2: {
                    severity = "Error";
                    break;
                }
                case 3: {
                    severity = "Fatal Error";
                    break;
                }
                default: {
                    severity = "?";
                }
            }
            AppletValidationFrame.this.print(severity);
            if (loc.getLineNumber() != -1) {
                AppletValidationFrame.this.println("  at line number " + loc.getLineNumber());
            }
            AppletValidationFrame.this.println(" : " + err.getMessage() + "\n");
            return true;
        }
    }
}

