/*
 * Decompiled with CFR 0.152.
 */
package jaxeapplet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;

public class AppletSourceFrame
extends JFrame
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AppletSourceFrame.class);
    private JaxeDocument jdoc;
    private final JFrame jframe;
    private StyledDocument srcdoc;
    JTextPane textPane;
    private Style styleElement;
    private Style styleNomAttribut;
    private Style styleValeurAttribut;
    private Style styleTexte;
    private Style styleEntite;
    private Style styleCommentaire;

    public AppletSourceFrame(JaxeDocument jdoc, JFrame jframe) {
        this.jframe = jframe;
        this.newdoc(jdoc);
    }

    public void newdoc(JaxeDocument jdoc) {
        int hauteur;
        this.jdoc = jdoc;
        Rectangle fr = this.jframe.getBounds();
        this.setLocation(fr.x + fr.width / 4 + 50, fr.y + fr.height / 4 + 50);
        Dimension ecran = this.getToolkit().getScreenSize();
        int largeur = ecran.width / 2;
        if (largeur < 620) {
            largeur = ecran.width - 20;
        }
        if ((hauteur = ecran.height * 2 / 3) < 460) {
            hauteur = ecran.height - 50;
        }
        this.setSize(new Dimension(largeur, hauteur));
        this.affichage();
        this.miseAJour();
    }

    protected void affichage() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(this.textPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        JPanel boutonsP = new JPanel();
        boutonsP.setLayout(new FlowLayout());
        JButton boutonMAJ = new JButton(JaxeResourceBundle.getRB().getString("source.MiseAJour"));
        boutonMAJ.addActionListener(this);
        boutonsP.add(boutonMAJ);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)paneScrollPane, "Center");
        contentPane.add((Component)boutonsP, "North");
        this.setContentPane(contentPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                AppletSourceFrame.this.textPane.requestFocus();
            }
        });
    }

    public void miseAJour() {
        Style defaultStyle;
        try {
            BufferedReader in = new BufferedReader(this.jdoc.getReader());
            this.textPane.read(in, null);
        }
        catch (IOException ex) {
            LOG.error("miseAJour()", ex);
            return;
        }
        this.srcdoc = (StyledDocument)this.textPane.getDocument();
        this.setTabs(4);
        String[] fontnames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        boolean trouv = false;
        for (String element : fontnames) {
            if (!"Monaco".equals(element)) continue;
            trouv = true;
            break;
        }
        if (trouv) {
            defaultStyle = this.textPane.getStyle("default");
            StyleConstants.setFontFamily(defaultStyle, "Monaco");
            StyleConstants.setFontSize(defaultStyle, 12);
        }
        defaultStyle = this.textPane.getStyle("default");
        this.styleElement = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleElement, new Color(150, 0, 0));
        this.styleNomAttribut = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleNomAttribut, new Color(0, 0, 150));
        this.styleValeurAttribut = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleValeurAttribut, new Color(0, 100, 0));
        this.styleEntite = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleEntite, new Color(0, 100, 100));
        this.styleCommentaire = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleCommentaire, Color.gray);
        this.styleTexte = this.textPane.addStyle(null, defaultStyle);
        StyleConstants.setForeground(this.styleTexte, Color.black);
        this.toutColorier();
        if (this.jdoc.fsave != null) {
            this.setTitle(this.jdoc.fsave.getName());
        } else {
            this.setTitle(JaxeResourceBundle.getRB().getString("menus.Source"));
        }
        this.setVisible(true);
    }

    public void colorier(int debut, int fin) {
        int ic;
        Buffer buff = new Buffer();
        if (buff.subEquals("\n", debut)) {
            if (fin - debut > 1) {
                this.srcdoc.setCharacterAttributes(debut + 1, fin - debut - 1, this.styleTexte, false);
            }
        } else {
            this.srcdoc.setCharacterAttributes(debut, fin - debut, this.styleTexte, false);
        }
        boolean dansNomElement = false;
        boolean dansNomAttribut = false;
        boolean avantValeurAttribut = false;
        char carValeurAttribut = '\"';
        boolean dansValeurAttribut = false;
        boolean dansEntite = false;
        boolean dansCommentaire = false;
        int debutzone = debut;
        for (ic = debut; ic < fin; ++ic) {
            char c;
            if (dansCommentaire) {
                if (!buff.subEquals("-->", ic)) continue;
                dansCommentaire = false;
                this.srcdoc.setCharacterAttributes(debutzone, (ic += 2) - debutzone + 1, this.styleCommentaire, false);
                continue;
            }
            if (dansNomElement) {
                c = buff.getChar(ic);
                if (c == ' ' || c == '\n') {
                    dansNomElement = false;
                    this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone, this.styleElement, false);
                    dansNomAttribut = true;
                    debutzone = ic + 1;
                    continue;
                }
                if (c != '>' && ic != fin - 1) continue;
                dansNomElement = false;
                this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone + 1, this.styleElement, false);
                continue;
            }
            if (dansNomAttribut) {
                c = buff.getChar(ic);
                if (c == '>' || ic == fin - 1) {
                    dansNomAttribut = false;
                    this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone + 1, this.styleElement, false);
                    continue;
                }
                if (c != '=') continue;
                dansNomAttribut = false;
                this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone, this.styleNomAttribut, false);
                avantValeurAttribut = true;
                continue;
            }
            if (avantValeurAttribut) {
                c = buff.getChar(ic);
                if (c != '\"' && c != '\'') continue;
                avantValeurAttribut = false;
                dansValeurAttribut = true;
                carValeurAttribut = c;
                debutzone = ic;
                continue;
            }
            if (dansValeurAttribut) {
                c = buff.getChar(ic);
                if (c != carValeurAttribut && ic != fin - 1) continue;
                dansValeurAttribut = false;
                this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone + 1, this.styleValeurAttribut, false);
                dansNomAttribut = true;
                debutzone = ic + 1;
                continue;
            }
            if (dansEntite) {
                c = buff.getChar(ic);
                if (c != ';' && c != ' ' && c != '\n' && ic != fin - 1) continue;
                dansEntite = false;
                this.srcdoc.setCharacterAttributes(debutzone, ic - debutzone + 1, this.styleEntite, false);
                continue;
            }
            c = buff.getChar(ic);
            if (c == '<') {
                if (buff.subEquals("<!--", ic)) {
                    dansCommentaire = true;
                } else {
                    dansNomElement = true;
                }
                debutzone = ic;
                continue;
            }
            if (c == '>') {
                this.srcdoc.setCharacterAttributes(ic, 1, this.styleElement, false);
                continue;
            }
            if (c != '&' && c != '%') continue;
            dansEntite = true;
            debutzone = ic;
        }
        if (dansCommentaire) {
            for (ic = fin; ic < this.srcdoc.getLength() && dansCommentaire; ++ic) {
                if (!buff.subEquals("-->", ic)) continue;
                dansCommentaire = false;
                this.srcdoc.setCharacterAttributes(debutzone, (ic += 2) - debutzone + 1, this.styleCommentaire, false);
            }
            if (dansCommentaire) {
                this.srcdoc.setCharacterAttributes(debutzone, this.srcdoc.getLength() - debutzone, this.styleCommentaire, false);
            }
        }
    }

    public void toutColorier() {
        this.colorier(0, this.srcdoc.getLength());
    }

    public void actionPerformed(ActionEvent e) {
        this.miseAJour();
    }

    public void allerLigne(int ligne) {
        ligne = ligne > 0 ? --ligne : 0;
        int pos = this.srcdoc.getDefaultRootElement().getElement(ligne).getStartOffset();
        try {
            this.textPane.scrollRectToVisible(this.textPane.modelToView(this.srcdoc.getLength()));
            this.textPane.scrollRectToVisible(this.textPane.modelToView(pos));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void selectLigne(int ligne) {
        ligne = ligne > 0 ? --ligne : 0;
        Element ligneel = this.srcdoc.getDefaultRootElement().getElement(ligne);
        try {
            this.textPane.scrollRectToVisible(this.textPane.modelToView(ligneel.getStartOffset()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textPane.setCaretPosition(ligneel.getStartOffset());
        if (ligneel.getEndOffset() <= this.srcdoc.getLength()) {
            this.textPane.moveCaretPosition(ligneel.getEndOffset());
        } else {
            this.textPane.moveCaretPosition(this.srcdoc.getLength());
        }
    }

    public void setTabs(int charactersPerTab) {
        FontMetrics fm = this.textPane.getFontMetrics(this.textPane.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.srcdoc.getLength();
        this.srcdoc.setParagraphAttributes(0, length, attributes, false);
    }

    class Buffer {
        int tailleMax = 200;
        String sbuff;
        int debut;
        int fin;

        public Buffer() {
            this.lire(0);
        }

        public void lire(int ind) {
            int lg = this.tailleMax;
            if (ind + lg > AppletSourceFrame.this.srcdoc.getLength()) {
                lg = AppletSourceFrame.this.srcdoc.getLength() - ind;
            }
            try {
                this.sbuff = AppletSourceFrame.this.srcdoc.getText(ind, lg);
            }
            catch (BadLocationException ex) {
                LOG.error("Buffer.lire: BadLocationException", ex);
            }
            if (this.sbuff.length() != lg) {
                LOG.error("Buffer.lire: erreur: " + this.sbuff.length() + " != " + lg);
            }
            this.debut = ind;
            this.fin = ind + lg;
        }

        public char getChar(int p) {
            if (p >= AppletSourceFrame.this.srcdoc.getLength()) {
                return ' ';
            }
            if (p >= this.fin) {
                this.lire(p);
            } else if (p < this.debut) {
                int p2 = p - this.tailleMax + 1;
                if (p2 < 0) {
                    p2 = 0;
                }
                this.lire(p2);
            }
            return this.sbuff.charAt(p - this.debut);
        }

        public boolean subEquals(String s, int ind) {
            int lg;
            if (ind >= AppletSourceFrame.this.srcdoc.getLength()) {
                LOG.error("erreur dans Buffer.subEquals: ind >= srcdoc.getLength() : " + ind + " >= " + AppletSourceFrame.this.srcdoc.getLength());
            }
            if (ind + (lg = s.length()) >= AppletSourceFrame.this.srcdoc.getLength()) {
                return false;
            }
            if (lg > this.tailleMax) {
                LOG.error("erreur dans Buffer.subEquals: " + lg + " > taille maxi (" + this.tailleMax + ")");
            }
            if (ind < this.debut || ind + lg > this.fin) {
                this.lire(ind);
            }
            int i = 0;
            int j = ind - this.debut;
            while (i < lg) {
                if (s.charAt(i) != this.sbuff.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
    }
}

