/*
 * Decompiled with CFR 0.152.
 */
package jaxe.wxs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jaxe.wxs.AvecSousElements;
import jaxe.wxs.JaxeWXS;
import jaxe.wxs.Parent;
import jaxe.wxs.ToutElement;
import jaxe.wxs.WXSAnnotated;
import jaxe.wxs.WXSAny;
import jaxe.wxs.WXSAttribute;
import jaxe.wxs.WXSComplexType;
import jaxe.wxs.WXSKey;
import jaxe.wxs.WXSKeyref;
import jaxe.wxs.WXSSchema;
import jaxe.wxs.WXSSimpleType;
import jaxe.wxs.WXSThing;
import jaxe.wxs.WXSType;
import jaxe.wxs.WXSUnique;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXSElement
extends WXSAnnotated
implements ToutElement,
AvecSousElements,
Parent {
    private static final Logger LOG = Logger.getLogger(WXSElement.class);
    protected WXSSimpleType simpleType = null;
    protected WXSComplexType complexType = null;
    protected List<WXSThing> identityConstraints;
    protected String name = null;
    protected String ref = null;
    protected String type = null;
    protected String substitutionGroup = null;
    protected int minOccurs = 1;
    protected int maxOccurs = 1;
    protected String defaultAtt = null;
    protected String fixed = null;
    protected boolean abstractAtt = false;
    protected String form = null;
    protected WXSElement wxsRef = null;
    protected WXSElement wxsSubstitutionGroup = null;
    protected Element domElement;
    protected Parent parent;
    protected WXSSchema schema;
    protected List<WXSThing> references;
    protected List<WXSElement> substitutions;
    protected List<WXSElement> correspondant;
    protected ArrayList<ToutElement> sousElements;

    public WXSElement(Element element, Parent parent, WXSSchema wXSSchema) {
        this.parseAnnotation(element);
        this.identityConstraints = new ArrayList<WXSThing>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if ("simpleType".equals(node.getLocalName())) {
                this.simpleType = new WXSSimpleType((Element)node, this, wXSSchema);
                continue;
            }
            if ("complexType".equals(node.getLocalName())) {
                this.complexType = new WXSComplexType((Element)node, this, wXSSchema);
                continue;
            }
            if ("unique".equals(node.getLocalName())) {
                this.identityConstraints.add(new WXSUnique((Element)node));
                continue;
            }
            if ("key".equals(node.getLocalName())) {
                this.identityConstraints.add(new WXSKey((Element)node));
                continue;
            }
            if (!"keyref".equals(node.getLocalName())) continue;
            this.identityConstraints.add(new WXSKeyref((Element)node));
        }
        if (element.getAttributeNode("name") != null) {
            this.name = element.getAttribute("name");
        }
        if (element.getAttributeNode("ref") != null) {
            this.ref = element.getAttribute("ref");
        }
        if (element.getAttributeNode("type") != null) {
            this.type = element.getAttribute("type");
        }
        if (element.getAttributeNode("substitutionGroup") != null) {
            this.substitutionGroup = element.getAttribute("substitutionGroup");
        }
        try {
            if (element.getAttributeNode("minOccurs") != null) {
                this.minOccurs = Integer.parseInt(element.getAttribute("minOccurs"));
            }
            if (element.getAttributeNode("maxOccurs") != null) {
                this.maxOccurs = "unbounded".equals(element.getAttribute("maxOccurs")) ? Integer.MAX_VALUE : Integer.parseInt(element.getAttribute("maxOccurs"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (element.getAttributeNode("default") != null) {
            this.defaultAtt = element.getAttribute("default");
        }
        if (element.getAttributeNode("fixed") != null) {
            this.fixed = element.getAttribute("fixed");
        }
        if (element.getAttributeNode("abstract") != null) {
            boolean bl = this.abstractAtt = "true".equals(element.getAttribute("abstract")) || "1".equals(element.getAttribute("abstract"));
        }
        if (element.getAttributeNode("form") != null) {
            this.form = element.getAttribute("form");
        }
        this.domElement = element;
        this.parent = parent;
        this.schema = wXSSchema;
        this.references = null;
        this.substitutions = null;
        this.sousElements = null;
        this.correspondant = null;
    }

    @Override
    public String getName() {
        if (this.name == null && this.wxsRef != null) {
            return this.wxsRef.getName();
        }
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean getAbstract() {
        return this.abstractAtt;
    }

    @Override
    public Element getDOMElement() {
        return this.domElement;
    }

    @Override
    public String getNamespace() {
        boolean bl = this.schema.getTopElements().contains(this) ? true : (this.form != null ? "qualified".equals(this.form) : "qualified".equals(this.schema.getElementFormDefault()));
        if (bl) {
            return this.schema.getTargetNamespace();
        }
        return null;
    }

    public Parent getParent() {
        return this.parent;
    }

    @Override
    public void resoudreReferences(WXSSchema wXSSchema, WXSThing wXSThing) {
        String string;
        if (this.simpleType != null) {
            this.simpleType.resoudreReferences(wXSSchema, null);
        }
        if (this.complexType != null) {
            this.complexType.resoudreReferences(wXSSchema, wXSThing);
        }
        if (this.ref != null) {
            string = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.ref));
            this.wxsRef = wXSSchema.resoudreReferenceElement(JaxeWXS.valeurLocale(this.ref), string);
            if (this.wxsRef != null) {
                this.wxsRef.ajouterReference(this);
            } else {
                LOG.error("R\u00e9f\u00e9rence d'\u00e9l\u00e9ment introuvable : " + this.ref);
            }
        }
        if (this.complexType == null && this.simpleType == null && this.type != null) {
            string = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.type));
            WXSType wXSType = wXSSchema.resoudreReferenceType(JaxeWXS.valeurLocale(this.type), string, wXSThing);
            if (wXSType instanceof WXSComplexType) {
                this.complexType = (WXSComplexType)wXSType;
                this.complexType.ajouterReference(this);
            } else if (wXSType instanceof WXSSimpleType) {
                this.simpleType = (WXSSimpleType)wXSType;
            }
        }
        if (this.substitutionGroup != null) {
            string = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.substitutionGroup));
            this.wxsSubstitutionGroup = wXSSchema.resoudreReferenceElement(JaxeWXS.valeurLocale(this.substitutionGroup), string);
            this.wxsSubstitutionGroup.ajouterSubstitution(this);
        }
    }

    public void ajouterReference(WXSThing wXSThing) {
        if (this.references == null) {
            this.references = new ArrayList<WXSThing>();
        }
        this.references.add(wXSThing);
    }

    public void ajouterSubstitution(WXSElement wXSElement) {
        if (this.substitutions == null) {
            this.substitutions = new ArrayList<WXSElement>();
        }
        this.substitutions.add(wXSElement);
    }

    public List<WXSElement> getSubstitutions() {
        return this.substitutions;
    }

    @Override
    public Set<WXSElement> listeTousElements() {
        LinkedHashSet<WXSElement> linkedHashSet = new LinkedHashSet<WXSElement>();
        linkedHashSet.add(this);
        if (this.complexType != null) {
            linkedHashSet.addAll(this.complexType.listeTousElements());
        }
        return linkedHashSet;
    }

    public List<WXSElement> listeElementsCorrespondant() {
        if (this.correspondant != null) {
            return this.correspondant;
        }
        this.correspondant = new ArrayList<WXSElement>();
        if (!this.abstractAtt && this.name != null) {
            this.correspondant.add(this);
        }
        if (this.wxsRef != null) {
            this.correspondant.addAll(this.wxsRef.listeElementsCorrespondant());
        }
        if (this.substitutions != null) {
            for (WXSElement wXSElement : this.substitutions) {
                this.correspondant.addAll(wXSElement.listeElementsCorrespondant());
            }
        }
        return this.correspondant;
    }

    @Override
    public ArrayList<ToutElement> listeSousElements() {
        if (this.sousElements != null) {
            return this.sousElements;
        }
        LinkedHashSet<ToutElement> linkedHashSet = new LinkedHashSet<ToutElement>();
        if (this.wxsRef != null) {
            linkedHashSet.addAll(this.wxsRef.listeSousElements());
        } else if (this.complexType != null) {
            linkedHashSet.addAll(this.complexType.listeSousElements());
        } else if (this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            linkedHashSet.addAll(this.wxsSubstitutionGroup.listeSousElements());
        }
        this.sousElements = new ArrayList(linkedHashSet);
        return this.sousElements;
    }

    @Override
    public ArrayList<WXSElement> listeElementsParents() {
        LinkedHashSet<WXSElement> linkedHashSet = new LinkedHashSet<WXSElement>();
        if (this.parent != null) {
            linkedHashSet.addAll(this.parent.listeElementsParents());
        }
        if (this.references != null) {
            for (WXSThing wXSThing : this.references) {
                if (wXSThing instanceof WXSElement) {
                    linkedHashSet.addAll(((WXSElement)wXSThing).listeElementsParents());
                    continue;
                }
                if (!(wXSThing instanceof WXSAny)) continue;
                linkedHashSet.addAll(((WXSAny)wXSThing).listeElementsParents());
            }
        }
        if (this.wxsSubstitutionGroup != null) {
            linkedHashSet.addAll(this.wxsSubstitutionGroup.listeElementsParents());
        }
        return new ArrayList<WXSElement>(linkedHashSet);
    }

    public String expressionReguliereElement() {
        if (this.complexType == null && this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.expressionReguliereElement();
        }
        if (this.complexType == null) {
            return null;
        }
        return this.complexType.expressionReguliere();
    }

    @Override
    public String expressionReguliere() {
        List<WXSElement> list = this.listeElementsCorrespondant();
        if (list.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 1) {
            stringBuilder.append('(');
        }
        Iterator<WXSElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(this.schema.titreElement(iterator.next().getDOMElement()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        if (list.size() > 1) {
            stringBuilder.append(')');
        }
        if (this.minOccurs == 0 && this.maxOccurs == 1) {
            stringBuilder.append('?');
        } else if (this.minOccurs == 0 && this.maxOccurs > 1) {
            stringBuilder.append('*');
        } else if (this.minOccurs > 0 && this.maxOccurs > 1) {
            stringBuilder.append('+');
        }
        return stringBuilder.toString();
    }

    @Override
    public Boolean enfantObligatoire(WXSElement wXSElement) {
        if (this.complexType == null && this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.enfantObligatoire(wXSElement);
        }
        if (this.complexType == null) {
            return null;
        }
        return this.complexType.enfantObligatoire(wXSElement);
    }

    @Override
    public Boolean enfantsMultiples(WXSElement wXSElement) {
        if (this.complexType == null && this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.enfantsMultiples(wXSElement);
        }
        if (this.complexType == null) {
            return null;
        }
        return this.complexType.enfantsMultiples(wXSElement);
    }

    public ArrayList<String> listeValeurs() {
        if (this.fixed != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.fixed);
            return arrayList;
        }
        if (this.simpleType != null) {
            return this.simpleType.listeValeurs();
        }
        if (this.complexType != null) {
            return this.complexType.listeValeurs();
        }
        if (this.type != null) {
            return JaxeWXS.listeValeursBooleen(this.type, this.domElement);
        }
        if (this.simpleType == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.listeValeurs();
        }
        return null;
    }

    public ArrayList<WXSAttribute> listeAttributs() {
        if (this.wxsRef != null) {
            return this.wxsRef.listeAttributs();
        }
        if (this.complexType != null) {
            return this.complexType.listeAttributs();
        }
        if (this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.listeAttributs();
        }
        return new ArrayList<WXSAttribute>();
    }

    public boolean contientDuTexte() {
        if (this.type != null) {
            String string = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.type));
            String string2 = this.domElement.getNamespaceURI();
            if (!string2.equals(this.schema.getTargetNamespace()) && string2.equals(string)) {
                return true;
            }
        }
        if (this.complexType != null) {
            if (this.complexType.getMixed()) {
                return true;
            }
            if (this.complexType.getSimpleContent() != null) {
                return true;
            }
        }
        if (this.simpleType != null) {
            return true;
        }
        if (this.complexType == null && this.type == null && this.wxsSubstitutionGroup != null) {
            return this.wxsSubstitutionGroup.contientDuTexte();
        }
        return false;
    }

    public boolean validerSousElements(List<WXSElement> list, boolean bl) {
        int n;
        if (this.complexType == null) {
            if (this.simpleType == null && this.type == null && this.wxsSubstitutionGroup != null) {
                return this.wxsSubstitutionGroup.validerSousElements(list, bl);
            }
            return list.size() == 0;
        }
        if (list.size() == 0) {
            if (bl) {
                return true;
            }
            if (this.complexType.estOptionnel()) {
                return true;
            }
        }
        return (n = this.complexType.valider(list, 0, bl)) > 0 && n == list.size();
    }

    @Override
    public int valider(List<WXSElement> list, int n, boolean bl) {
        int n2 = 0;
        List<WXSElement> list2 = this.listeElementsCorrespondant();
        for (int i = n; i < list.size(); ++i) {
            if (n2 >= this.maxOccurs) {
                return i;
            }
            boolean bl2 = false;
            for (WXSElement wXSElement : list2) {
                if (wXSElement != list.get(i)) continue;
                bl2 = true;
            }
            if (!bl2) {
                if (!bl && n2 < this.minOccurs) {
                    return n;
                }
                return i;
            }
            ++n2;
        }
        if (!bl && n2 < this.minOccurs) {
            return n;
        }
        return n + n2;
    }

    @Override
    public boolean estOptionnel() {
        return this.minOccurs == 0;
    }

    public boolean validerValeur(String string) {
        if (this.fixed != null) {
            return this.fixed.equals(string);
        }
        if (this.simpleType != null) {
            return this.simpleType.validerValeur(string);
        }
        if (this.complexType != null) {
            return this.complexType.validerValeur(string);
        }
        if (this.type != null) {
            String string2 = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.type));
            if (string2 != null && string2.equals(this.domElement.getNamespaceURI())) {
                return WXSSimpleType.validerValeur(JaxeWXS.valeurLocale(this.type), string);
            }
            return false;
        }
        return true;
    }
}

