/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jaxe.Config;
import jaxe.DialogueAideElement;
import jaxe.EcouteurMAJ;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.elements.JECData;
import jaxe.elements.JECommentaire;
import jaxe.elements.JESwing;
import jaxe.elements.JETexte;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class AttributePanel
extends JPanel
implements EcouteurMAJ,
CaretListener {
    static final Logger LOG = Logger.getLogger(AttributePanel.class);
    JaxeDocument _doc;
    private JaxeElement _elem;

    public AttributePanel(JaxeDocument jaxeDocument) {
        this._doc = jaxeDocument;
        this.miseAJour();
    }

    @Override
    public void miseAJour() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this._doc.rootJE != null && this._doc.cfg != null) {
            JPanel jPanel = new JPanel();
            int n = this._doc.textPane.getCaretPosition();
            this._elem = this._doc.rootJE.elementA(n);
            if (this._elem != null && !(this._elem instanceof JECommentaire) && !(this._elem instanceof JECData)) {
                if (this._elem instanceof JETexte || this._elem.debut.getOffset() == n && !(this._elem instanceof JESwing)) {
                    this._elem = this._elem.getParent();
                }
                if (this._elem != null) {
                    jPanel = this.createInputLists();
                }
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.setPreferredSize(new Dimension(0, 0));
            jPanel2.setMinimumSize(new Dimension(0, 0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
            this.add((Component)jScrollPane, "Center");
            this.validate();
        }
    }

    private JPanel createInputLists() {
        Element element = (Element)this._elem.noeud;
        Element element2 = this._elem.refElement;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (element2 != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            Config config = this._doc.cfg.getRefConf(element2);
            ArrayList<Element> arrayList = config.listeAttributs(element2);
            for (Element element3 : arrayList) {
                Object object;
                Serializable serializable;
                JComponent jComponent;
                String string;
                String string2 = config.nomAttribut(element3);
                String string3 = config.titreAttribut(element2, element3);
                String string4 = config.espaceAttribut(element3);
                String string5 = string2;
                if (string4 != null && (string = config.prefixeAttribut(element, element3)) != null) {
                    string5 = string + ":" + string2;
                }
                string = element.getAttribute(string5);
                String string6 = config.documentationAttribut(element2, element3);
                if (string6 != null) {
                    jComponent = new JButton(new ActionAide(element3, element2));
                    jComponent.setFont(jComponent.getFont().deriveFont(9.0f));
                    if (System.getProperty("os.name").startsWith("Mac OS")) {
                        ((AbstractButton)jComponent).setText("?");
                        if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                            jComponent.putClientProperty("JButton.buttonType", "help");
                        } else {
                            jComponent.putClientProperty("JButton.buttonType", "toolbar");
                        }
                    } else {
                        ((AbstractButton)jComponent).setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
                        ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
                        ((AbstractButton)jComponent).setBorderPainted(false);
                        ((AbstractButton)jComponent).setContentAreaFilled(false);
                    }
                    jPanel.add((Component)jComponent, gridBagConstraints2);
                    string6 = "<html><body>" + string6.replaceAll("\n", "<br>") + "</body></html>";
                    jComponent.setToolTipText(string6);
                }
                jComponent = new JLabel(string3);
                boolean bl = config.attributObligatoire(element2, element3);
                if (bl) {
                    jComponent.setForeground(new Color(150, 0, 0));
                } else {
                    jComponent.setForeground(new Color(0, 100, 0));
                }
                jPanel.add((Component)jComponent, gridBagConstraints2);
                ArrayList<String> arrayList2 = config.listeValeursAttribut(element3);
                String string7 = config.valeurParDefaut(element3);
                if ("".equals(string) && string7 != null && element.getAttributeNode(string5) == null) {
                    string = string7;
                }
                if (arrayList2 != null) {
                    serializable = new ElementComboBox(element, string5, string4, string7, bl);
                    if (string7 == null && !bl) {
                        ((ElementComboBox)serializable).addValue("", "");
                    }
                    for (String string8 : arrayList2) {
                        ((ElementComboBox)serializable).addValue(string8, config.titreValeurAttribut(element2, element3, string8));
                    }
                    ((ElementComboBox)serializable).setValue(string);
                    ((ElementComboBox)serializable).startListener();
                    jPanel.add((Component)serializable, gridBagConstraints);
                    continue;
                }
                serializable = config.listeValeursSuggereesAttribut(element2, element3);
                if (serializable != null && ((ArrayList)serializable).size() > 0) {
                    object = new ElementComboBox(element, string5, string4, string7, bl);
                    ((JComboBox)object).setEditable(true);
                    if (string7 == null && !bl) {
                        ((ElementComboBox)object).addValue("", "");
                    }
                    Iterator iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        String string9 = (String)iterator.next();
                        ((ElementComboBox)object).addValue(string9, config.titreValeurAttribut(element2, element3, string9));
                    }
                    ((ElementComboBox)object).setValue(string);
                    ((ElementComboBox)object).startListener();
                    jPanel.add((Component)object, gridBagConstraints);
                    continue;
                }
                object = new JTextField(string);
                ((JTextComponent)object).getDocument().addDocumentListener(new FieldListener(element, string5, string4, string7, bl));
                jPanel.add((Component)object, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this._doc.textPane.getCaretPosition();
        JaxeElement jaxeElement = null;
        if (this._doc.rootJE != null) {
            jaxeElement = this._doc.rootJE.elementA(n);
        }
        if (jaxeElement != null && (jaxeElement instanceof JETexte || jaxeElement.debut.getOffset() == n && !(jaxeElement instanceof JESwing))) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement != this._elem) {
            this.miseAJour();
        }
    }

    class ActionAide
    extends AbstractAction {
        Element refAttribut;
        Element refElementParent;

        ActionAide(Element element, Element element2) {
            this.refAttribut = element;
            this.refElementParent = element2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DialogueAideElement dialogueAideElement = new DialogueAideElement(this.refAttribut, this.refElementParent, AttributePanel.this._doc.cfg.getRefConf(this.refElementParent), (JFrame)AttributePanel.this._doc.textPane.getTopLevelAncestor());
            dialogueAideElement.setVisible(true);
        }
    }

    class FieldListener
    implements DocumentListener {
        private final Element _el;
        private final String _attr;
        private final String _ns;
        private final String _defaut;
        private final boolean _req;

        public FieldListener(Element element, String string, String string2, String string3, boolean bl) {
            this._el = element;
            this._attr = string;
            this._ns = string2;
            this._defaut = string3;
            this._req = bl;
        }

        public void changed(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                if (!this._req && (this._defaut == null && "".equals(string) || this._defaut != null && this._defaut.equals(string))) {
                    this._el.removeAttribute(this._attr);
                } else {
                    this._el.setAttributeNS(this._ns, this._attr, string);
                }
                JaxeElement jaxeElement = AttributePanel.this._doc.getElementForNode(this._el);
                if (jaxeElement != null) {
                    jaxeElement.majAffichage();
                }
            }
            catch (Exception exception) {
                LOG.error("changed(DocumentEvent)", exception);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.changed(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changed(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changed(documentEvent);
        }
    }

    class ElementComboBox
    extends JComboBox {
        private final Element _el;
        private final String _attr;
        private final String _ns;
        private boolean _listen;
        private final ArrayList<String> _values;
        private final String _defaut;
        private final boolean _req;

        public ElementComboBox(Element element, String string, String string2, String string3, boolean bl) {
            this._el = element;
            this._attr = string;
            this._ns = string2;
            this._listen = false;
            this._values = new ArrayList();
            this._defaut = string3;
            this._req = bl;
        }

        public void startListener() {
            this._listen = true;
        }

        @Override
        public void selectedItemChanged() {
            super.selectedItemChanged();
            if (this._listen) {
                int n = this.getSelectedIndex();
                String string = n == -1 ? (String)this.getSelectedItem() : this._values.get(n);
                if (!this._req && (this._defaut == null && "".equals(string) || this._defaut != null && this._defaut.equals(string))) {
                    this._el.removeAttribute(this._attr);
                } else {
                    this._el.setAttributeNS(this._ns, this._attr, string);
                }
            }
        }

        public void addValue(String string, String string2) {
            this._values.add(string);
            this.addItem(string2);
        }

        public void setValue(String string) {
            int n = this._values.indexOf(string);
            if (n != -1) {
                this.setSelectedIndex(n);
            } else if (this.isEditable()) {
                this.setSelectedItem(string);
            }
        }
    }
}

