/*
 * Decompiled with CFR 0.152.
 */
package jaxe.wxs;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jaxe.wxs.AvecSousElements;
import jaxe.wxs.JaxeWXS;
import jaxe.wxs.Parent;
import jaxe.wxs.ToutElement;
import jaxe.wxs.WXSAll;
import jaxe.wxs.WXSAnnotated;
import jaxe.wxs.WXSChoice;
import jaxe.wxs.WXSElement;
import jaxe.wxs.WXSSchema;
import jaxe.wxs.WXSSequence;
import jaxe.wxs.WXSThing;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXSGroup
extends WXSAnnotated
implements AvecSousElements,
Parent {
    private static final Logger LOG = Logger.getLogger(WXSGroup.class);
    protected AvecSousElements modele = null;
    protected String name = null;
    protected String ref = null;
    protected WXSGroup wxsRef = null;
    protected int minOccurs = 1;
    protected int maxOccurs = 1;
    protected Element domElement;
    protected Parent parent;
    protected WXSSchema schema;
    protected List<WXSGroup> references;

    public WXSGroup(Element element, Parent parent, WXSSchema wXSSchema) {
        this.parseAnnotation(element);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if ("all".equals(node.getLocalName())) {
                this.modele = new WXSAll((Element)node, this, wXSSchema);
                continue;
            }
            if ("choice".equals(node.getLocalName())) {
                this.modele = new WXSChoice((Element)node, this, wXSSchema);
                continue;
            }
            if (!"sequence".equals(node.getLocalName())) continue;
            this.modele = new WXSSequence((Element)node, this, wXSSchema);
        }
        if (element.getAttributeNode("name") != null) {
            this.name = element.getAttribute("name");
        }
        if (element.getAttributeNode("ref") != null) {
            this.ref = element.getAttribute("ref");
        }
        try {
            if (element.getAttributeNode("minOccurs") != null) {
                this.minOccurs = Integer.parseInt(element.getAttribute("minOccurs"));
            }
            if (element.getAttributeNode("maxOccurs") != null) {
                this.maxOccurs = "unbounded".equals(element.getAttribute("maxOccurs")) ? Integer.MAX_VALUE : Integer.parseInt(element.getAttribute("maxOccurs"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.domElement = element;
        this.parent = parent;
        this.schema = wXSSchema;
        this.references = null;
    }

    public String getName() {
        if (this.name == null && this.wxsRef != null) {
            return this.wxsRef.getName();
        }
        return this.name;
    }

    public String getNamespace() {
        return this.schema.getTargetNamespace();
    }

    public Parent getParent() {
        return this.parent;
    }

    @Override
    public void resoudreReferences(WXSSchema wXSSchema, WXSThing wXSThing) {
        if (this.modele != null) {
            this.modele.resoudreReferences(wXSSchema, wXSThing);
        }
        if (this.ref != null) {
            String string = this.domElement.lookupNamespaceURI(JaxeWXS.prefixeNom(this.ref));
            this.wxsRef = wXSSchema.resoudreReferenceGroupe(JaxeWXS.valeurLocale(this.ref), string, wXSThing);
            if (this.wxsRef != null) {
                this.wxsRef.ajouterReference(this);
            } else {
                LOG.error("R\u00e9f\u00e9rence de groupe introuvable : " + this.ref);
            }
        }
    }

    public void ajouterReference(WXSGroup wXSGroup) {
        if (this.references == null) {
            this.references = new ArrayList<WXSGroup>();
        }
        this.references.add(wXSGroup);
    }

    @Override
    public Set<WXSElement> listeTousElements() {
        if (this.modele != null) {
            return this.modele.listeTousElements();
        }
        return new LinkedHashSet<WXSElement>();
    }

    @Override
    public ArrayList<ToutElement> listeSousElements() {
        if (this.wxsRef != null) {
            return this.wxsRef.listeSousElements();
        }
        if (this.modele != null) {
            return this.modele.listeSousElements();
        }
        return new ArrayList<ToutElement>();
    }

    @Override
    public ArrayList<WXSElement> listeElementsParents() {
        ArrayList<WXSElement> arrayList = new ArrayList<WXSElement>();
        if (this.parent != null) {
            arrayList.addAll(this.parent.listeElementsParents());
        }
        if (this.references != null) {
            for (WXSGroup wXSGroup : this.references) {
                arrayList.addAll(wXSGroup.listeElementsParents());
            }
        }
        return arrayList;
    }

    @Override
    public String expressionReguliere() {
        String string = this.wxsRef != null ? this.wxsRef.expressionReguliere() : (this.modele != null ? this.modele.expressionReguliere() : "()");
        if (this.minOccurs == 0 && this.maxOccurs == 1) {
            return string + '?';
        }
        if (this.minOccurs == 0 && this.maxOccurs > 1) {
            return string + '*';
        }
        if (this.minOccurs > 0 && this.maxOccurs > 1) {
            return string + '+';
        }
        return string;
    }

    @Override
    public Boolean enfantObligatoire(WXSElement wXSElement) {
        if (this.wxsRef != null) {
            return this.wxsRef.enfantObligatoire(wXSElement);
        }
        Boolean bl = null;
        if (this.modele != null) {
            bl = this.modele.enfantObligatoire(wXSElement);
        }
        return bl;
    }

    @Override
    public Boolean enfantsMultiples(WXSElement wXSElement) {
        if (this.wxsRef != null) {
            return this.wxsRef.enfantsMultiples(wXSElement);
        }
        Boolean bl = null;
        if (this.modele != null) {
            bl = this.modele.enfantsMultiples(wXSElement);
        }
        return bl;
    }

    @Override
    public int valider(List<WXSElement> list, int n, boolean bl) {
        if (!bl && list.size() < this.minOccurs) {
            return n;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 < list.size()) {
            if (n2 >= this.maxOccurs) {
                return n3;
            }
            int n4 = n3;
            if (this.wxsRef != null) {
                n4 = this.wxsRef.valider(list, n3, bl);
            } else if (this.modele != null) {
                n4 = this.modele.valider(list, n3, bl);
            }
            if (n4 == n3) {
                return n3;
            }
            n3 = n4;
            ++n2;
        }
        return list.size();
    }

    @Override
    public boolean estOptionnel() {
        if (this.minOccurs == 0) {
            return true;
        }
        if (this.wxsRef != null) {
            return this.wxsRef.estOptionnel();
        }
        if (this.modele != null) {
            return this.modele.estOptionnel();
        }
        return true;
    }
}

