/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations.element;

import java.awt.Color;
import java.awt.Graphics;
import jaxe.equations.element.MathElement;

public class MathRootElement
extends MathElement {
    public static final String ELEMENT = "math";
    public static final String ATTRIBUTE_MODE = "mode";
    public static final int INLINE = 0;
    public static final int DISPLAY = 1;
    private int mode = 0;
    private boolean debug = false;

    public void setMode(int n) {
        if (n == 0 || n == 1) {
            this.mode = n;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void paint(Graphics graphics) {
        if (this.debug) {
            graphics.setColor(Color.blue);
            graphics.drawLine(0, 0, this.getWidth() - 1, 0);
            graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.drawLine(0, 0, 0, this.getHeight() - 1);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            graphics.setColor(Color.cyan);
            graphics.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
            graphics.setColor(Color.black);
        }
        if (this.getMathElement(0) != null) {
            int n;
            int n2 = this.getMathElement(0).getAscentHeight(true) - this.getMiddleShift();
            if (n2 >= (n = this.getMathElement(0).getDescentHeight(true) + this.getMiddleShift())) {
                this.paint(graphics, 0, this.getAscentHeight(true));
            } else {
                this.paint(graphics, 0, n + this.getMiddleShift());
            }
        }
    }

    public int getWidth() {
        return this.getWidth(true);
    }

    public int getHeight() {
        return this.getHeight(true);
    }

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        if (this.getMathElement(0) != null) {
            this.getMathElement(0).paint(graphics, n, n2);
        }
    }

    @Override
    public int getWidth(boolean bl) {
        if (this.getMathElement(0) == null) {
            return 0;
        }
        return this.getMathElement(0).getWidth(true) + 1;
    }

    @Override
    public int getHeight(boolean bl) {
        if (this.getMathElement(0) == null) {
            return 0;
        }
        if (this.mode == 1) {
            return this.getMathElement(0).getHeight(true) + 2;
        }
        int n = this.getMathElement(0).getAscentHeight(true) - this.getMiddleShift();
        int n2 = this.getMathElement(0).getDescentHeight(true) + this.getMiddleShift();
        return Math.max(n, n2) * 2;
    }

    @Override
    public int getAscentHeight(boolean bl) {
        if (this.getMathElement(0) == null) {
            return 0;
        }
        if (this.mode == 1) {
            return this.getMathElement(0).getAscentHeight(true);
        }
        return Math.max(this.getMathElement(0).getAscentHeight(true), this.getMathElement(0).getDescentHeight(true));
    }

    @Override
    public int getDescentHeight(boolean bl) {
        if (this.getMathElement(0) == null) {
            return 0;
        }
        if (this.mode == 1) {
            return this.getMathElement(0).getDescentHeight(true);
        }
        return Math.max(this.getMathElement(0).getAscentHeight(true), this.getMathElement(0).getDescentHeight(true));
    }
}

