/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations.element;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import jaxe.equations.MathBase;

public class MathElement {
    public static final String URI = "http://www.w3.org/1998/Math/MathML";
    private MathBase base;
    private MathElement parent;
    private int fontsize = 14;
    private final Vector<MathElement> children = new Vector();
    private final StringBuilder text = new StringBuilder();

    public MathElement(MathBase mathBase, int n) {
        this.setMathBase(mathBase);
        this.setParent(this.parent);
        this.setFontSize(n);
    }

    public MathElement(MathBase mathBase) {
        this.setMathBase(mathBase);
    }

    public MathElement() {
    }

    public void addMathElement(MathElement mathElement) {
        if (mathElement != null) {
            this.children.addElement(mathElement);
            mathElement.setMathBase(this.base);
            mathElement.setParent(this);
            mathElement.setFontSize(this.fontsize);
        }
    }

    public MathElement getMathElement(int n) {
        if (n >= 0 && n < this.children.size()) {
            return this.children.elementAt(n);
        }
        return null;
    }

    public void setMathElementAt(MathElement mathElement, int n) {
        if (n >= 0 && n < this.children.size()) {
            this.children.setElementAt(mathElement, n);
        }
    }

    public int getMathElementCount() {
        return this.children.size();
    }

    public void addText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (" \t\n\r".indexOf(string.charAt(i)) < 0) {
                this.text.append(string.charAt(i));
                continue;
            }
            if (' ' != string.charAt(i) || i <= 0 || ' ' == string.charAt(i - 1)) continue;
            this.text.append(string.charAt(i));
        }
    }

    public String getText() {
        return this.text.toString().trim();
    }

    public void setMathBase(MathBase mathBase) {
        this.base = mathBase;
        for (MathElement mathElement : this.children) {
            mathElement.setMathBase(mathBase);
        }
    }

    public MathBase getMathBase() {
        return this.base;
    }

    public void setParent(MathElement mathElement) {
        this.parent = mathElement;
    }

    public MathElement getParent() {
        return this.parent;
    }

    public void setFontSize(int n) {
        this.fontsize = Math.max(n, 8);
        for (MathElement mathElement : this.children) {
            mathElement.setFontSize(this.fontsize);
        }
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public Font getFont() {
        if (this.base != null) {
            return this.base.getFont(this.fontsize);
        }
        return null;
    }

    public Font getItalicFont() {
        if (this.base != null) {
            return this.base.getItalicFont(this.fontsize);
        }
        return null;
    }

    public Font getBoldFont() {
        if (this.base != null) {
            return this.base.getBoldFont(this.fontsize);
        }
        return null;
    }

    public Font getBoldItalicFont() {
        if (this.base != null) {
            return this.base.getBoldItalicFont(this.fontsize);
        }
        return null;
    }

    public FontMetrics getFontMetrics() {
        if (this.base != null) {
            return this.base.getFontMetrics(this.fontsize);
        }
        return null;
    }

    public void debug(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.blue);
        graphics.drawLine(n, n2 - this.getAscentHeight(true), n + this.getWidth(true), n2 - this.getAscentHeight(true));
        graphics.drawLine(n + this.getWidth(true), n2 - this.getAscentHeight(true), n + this.getWidth(true), n2 + this.getDescentHeight(true));
        graphics.drawLine(n, n2 + this.getDescentHeight(true), n + this.getWidth(true), n2 + this.getDescentHeight(true));
        graphics.drawLine(n, n2 - this.getAscentHeight(true), n, n2 + this.getDescentHeight(true));
        graphics.setColor(Color.red);
        graphics.drawLine(n, n2, n + this.getWidth(true), n2);
        graphics.setColor(Color.black);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.base.isDebug()) {
            this.debug(graphics, n, n2);
        }
        int n3 = n;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            MathElement mathElement = this.getMathElement(i);
            mathElement.paint(graphics, n3, n2);
            n3 += mathElement.getWidth(true) + 2;
        }
        n3 -= 2;
    }

    public int getWidth(boolean bl) {
        int n = 0;
        for (MathElement mathElement : this.children) {
            n += mathElement.getWidth(bl) + 2;
        }
        return n - 2;
    }

    public int getHeight(boolean bl) {
        return this.getAscentHeight(bl) + this.getDescentHeight(bl);
    }

    public int getRealAscentHeight(Graphics graphics) {
        return this.getAscentHeight(true);
    }

    public int getAscentHeight(boolean bl) {
        int n = 0;
        for (MathElement mathElement : this.children) {
            n = Math.max(n, mathElement.getAscentHeight(bl));
        }
        return n;
    }

    public int getDescentHeight(boolean bl) {
        int n = 0;
        for (MathElement mathElement : this.children) {
            n = Math.max(n, mathElement.getDescentHeight(bl));
        }
        return n;
    }

    protected int getMiddleShift() {
        return (int)((double)this.base.getFontMetrics(this.getFontSize()).getAscent() * 0.3);
    }
}

