/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jaxe.Config;
import jaxe.InterfaceSchema;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.wxs.WXSSimpleType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaRelaxNG
implements InterfaceSchema {
    private static final Logger LOG = Logger.getLogger(SchemaRelaxNG.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    private Config cfg;
    private final Element schema;
    private String schemaNamespace;
    private String targetNamespace;
    private final ArrayList<Element> ltouselements;
    private final ArrayList<Element> elementsNommes;
    private final ArrayList<Element> ltousref;
    private final ArrayList<Element> ltousdefine;
    private HashMap<String, String> hashPrefixes = null;
    private final ArrayList<URI> fichiersInclus;
    private ValidationDriver jingValidation;
    private ValidationDriver jingInsertion;

    public SchemaRelaxNG(URL uRL, Config config) {
        Object object;
        this.cfg = config;
        this.ltouselements = new ArrayList();
        this.elementsNommes = new ArrayList();
        this.ltousref = new ArrayList();
        this.ltousdefine = new ArrayList();
        this.hashPrefixes = new HashMap();
        this.fichiersInclus = new ArrayList();
        this.schema = this.inclusion1(uRL);
        for (Element object2 : this.elementsNommes) {
            String iOException = this.espaceElement(object2);
            String string = object2.lookupPrefix(iOException);
            if (iOException == null || string == null) continue;
            this.hashPrefixes.put(iOException, string);
        }
        try {
            object = ValidationDriver.uriOrFileInputSource(uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            LOG.error("Erreur au chargement du sch\u00e9ma avec Jing", malformedURLException);
            object = null;
        }
        if (object != null) {
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
            RngProperty.DATATYPE_LIBRARY_FACTORY.put(propertyMapBuilder, new DatatypeLibraryFactoryImpl());
            propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, new DraconianErrorHandler());
            try {
                this.jingValidation = new ValidationDriver(propertyMapBuilder.toPropertyMap());
                if (!this.jingValidation.loadSchema((InputSource)object)) {
                    LOG.error("Erreur au chargement du sch\u00e9ma avec Jing (jingValidation)");
                }
                object = ValidationDriver.uriOrFileInputSource(uRL.toExternalForm());
                propertyMapBuilder.put(RngProperty.FEASIBLE, Flag.PRESENT);
                this.jingInsertion = new ValidationDriver(propertyMapBuilder.toPropertyMap());
                if (!this.jingInsertion.loadSchema((InputSource)object)) {
                    LOG.error("Erreur au chargement du sch\u00e9ma avec Jing (jingInsertion)");
                }
            }
            catch (SAXException sAXException) {
                LOG.error("Erreur au chargement du sch\u00e9ma avec Jing", sAXException);
            }
            catch (IOException iOException) {
                LOG.error("Erreur au chargement du sch\u00e9ma avec Jing", iOException);
            }
        }
    }

    private Element inclusion1(URL uRL) {
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = uRL.toURI().normalize();
            if (this.fichiersInclus.indexOf(object3) != -1) {
                return null;
            }
            this.fichiersInclus.add((URI)object3);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.error("SchemaRelaxNG.inclusion1(URL) : URISyntaxException for " + uRL.toString(), uRISyntaxException);
        }
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object3 = ((DocumentBuilder)object).parse(uRL.toExternalForm());
        }
        catch (Exception exception) {
            LOG.error("inclusion1: lecture de " + uRL.toExternalForm(), exception);
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, exception.getMessage(), rb.getString("erreur.Fatale"), 0);
            return null;
        }
        object2 = object3.getDocumentElement();
        if (this.schemaNamespace == null) {
            this.schemaNamespace = object2.getNamespaceURI();
        }
        if (this.targetNamespace == null) {
            this.targetNamespace = object2.getAttribute("ns");
        }
        object = SchemaRelaxNG.getParentURL(uRL);
        this.inclusion2((Element)object2, (URL)object);
        return object2;
    }

    private static URL getParentURL(URL uRL) {
        int n = uRL.toExternalForm().lastIndexOf("/");
        if (n >= 0) {
            try {
                return new URL(uRL.toExternalForm().substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.error("getParentURL(" + uRL + ") : MalformedURLException", malformedURLException);
                return null;
            }
        }
        return null;
    }

    private void inclusion2(Element element, URL uRL) {
        if ("element".equals(element.getLocalName())) {
            this.ltouselements.add(element);
        }
        ArrayList<Element> arrayList = this.listeTous(element, "element");
        this.ltouselements.addAll(arrayList);
        for (Element object2 : arrayList) {
            if (this.nomElement(object2) == null) continue;
            this.elementsNommes.add(object2);
        }
        this.ltousref.addAll(this.listeTous(element, "ref"));
        this.ltousdefine.addAll(this.listeTous(element, "define"));
        ArrayList<Element> arrayList2 = this.listeTous(element, "include");
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            URL uRL2;
            Element element2 = (Element)iterator.next();
            String string = element2.getAttribute("href");
            try {
                uRL2 = uRL != null && !string.startsWith("http://") ? new URL(uRL.toExternalForm() + "/" + string) : new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.error("include : MalformedURLException: " + malformedURLException.getMessage(), malformedURLException);
                uRL2 = null;
            }
            this.inclusion1(uRL2);
        }
    }

    @Override
    public boolean elementDansSchema(Element element) {
        return this.ltouselements.contains(element);
    }

    @Override
    public Element referenceElement(String string) {
        return this.chercherPremier(TypeObjetSchema.ELEMENT, string);
    }

    @Override
    public Element referenceElement(Element element) {
        String string = element.getPrefix() == null ? element.getNodeName() : element.getLocalName();
        String string2 = element.getNamespaceURI();
        return this.referenceElement(string, string2);
    }

    private Element referenceElement(String string, String string2) {
        return this.chercherPremier(TypeObjetSchema.ELEMENT, string, string2);
    }

    @Override
    public Element referenceElement(Element element, Element element2) {
        if (element2 == null) {
            return this.referenceElement(element);
        }
        ArrayList<Element> arrayList = this.listeSousElements(element2);
        String string = element.getLocalName();
        String string2 = element.getNamespaceURI();
        for (Element element3 : arrayList) {
            if (!this.nomElement(element3).equals(string)) continue;
            String string3 = this.espaceElement(element3);
            if ((string2 != null || string3 != null) && (string2 == null || !string2.equals(string3))) continue;
            return element3;
        }
        return null;
    }

    @Override
    public String nomElement(Element element) {
        if (!"".equals(element.getAttribute("name"))) {
            return SchemaRelaxNG.localValue(element.getAttribute("name"));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1 || !(string = node.getLocalName()).equals("name")) continue;
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public String espaceElement(Element element) {
        if (!"".equals(element.getAttribute("ns"))) {
            return element.getAttribute("ns");
        }
        if (SchemaRelaxNG.prefixeString(element.getAttribute("name")) != null) {
            return element.lookupNamespaceURI(SchemaRelaxNG.prefixeString(element.getAttribute("name")));
        }
        if (element.getParentNode() != null) {
            return this.espaceElement((Element)element.getParentNode());
        }
        return null;
    }

    @Override
    public String documentationElement(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1 || !(string = node.getLocalName()).equals("documentation")) continue;
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public ArrayList<String> listeValeursElement(Element element) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("choice")) {
                ArrayList<String> arrayList = this.listeValeursAttribut((Element)node);
                if (arrayList == null) continue;
                linkedHashSet.addAll(arrayList);
                continue;
            }
            if (!string.equals("value")) continue;
            linkedHashSet.add(node.getFirstChild().getNodeValue());
        }
        if (linkedHashSet.size() == 0) {
            return null;
        }
        return new ArrayList<String>(linkedHashSet);
    }

    @Override
    public boolean valeurElementValide(Element element, String string) {
        return this.verifType(element, string);
    }

    private boolean verifType(Element element, String string) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        ArrayList<Element> arrayList = this.enfants(element, "data");
        if (arrayList.size() > 1) {
            return true;
        }
        if (arrayList.size() == 0) {
            object3 = this.enfants(element, "ref");
            if (((ArrayList)object3).size() != 1) {
                return true;
            }
            object2 = (Element)((ArrayList)object3).get(0);
            string2 = object2.getAttribute("name");
            object = this.ltousdefine.iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                if (!element2.getAttribute("name").equals(string2)) continue;
                return this.verifType(element2, string);
            }
        }
        object3 = arrayList.get(0);
        object2 = object3.getAttribute("type");
        string2 = null;
        for (object = object3; object != null; object = (Element)object.getParentNode()) {
            if ("".equals(object.getAttribute("datatypeLibrary"))) continue;
            string2 = object.getAttribute("datatypeLibrary");
            break;
        }
        if ("http://www.w3.org/2001/XMLSchema-datatypes".equals(string2)) {
            return WXSSimpleType.validerValeur((String)object2, string);
        }
        return true;
    }

    @Override
    public String prefixeElement(Element element) {
        String string = this.espaceElement(element);
        if (string == null) {
            return null;
        }
        return this.hashPrefixes.get(string);
    }

    @Override
    public ArrayList<String> listeEspaces() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.targetNamespace != null) {
            linkedHashSet.add(this.targetNamespace);
        }
        for (String string : this.hashPrefixes.keySet()) {
            linkedHashSet.add(string);
        }
        return new ArrayList<String>(linkedHashSet);
    }

    @Override
    public boolean aEspace(String string) {
        if (string == null) {
            if (this.targetNamespace == null || this.targetNamespace.equals("")) {
                return true;
            }
            if (this.hashPrefixes.containsKey("")) {
                return true;
            }
        } else {
            if (string.equals(this.targetNamespace)) {
                return true;
            }
            if (this.hashPrefixes.containsKey(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String prefixeEspace(String string) {
        return this.hashPrefixes.get(string);
    }

    @Override
    public String espaceCible() {
        return this.targetNamespace;
    }

    @Override
    public ArrayList<Element> listeElementsHorsEspace(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.elementsNommes) {
            String string2 = this.espaceElement(element);
            if (string2 == null || string2.equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Element> listeElementsDansEspaces(Set<String> set) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.elementsNommes) {
            String string = this.espaceElement(element);
            if (string == null || !set.contains(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Element> listeTousElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.elementsNommes) {
            arrayList.add(element);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Element> listeElementsRacines() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if ("element".equals(this.schema.getLocalName())) {
            arrayList.add(this.schema);
        } else {
            ArrayList<Element> arrayList2 = this.enfants(this.schema, "start");
            for (Element element : arrayList2) {
                arrayList.addAll(this.listeSousElements(element));
            }
        }
        return arrayList;
    }

    @Override
    public boolean elementObligatoire(Element element, Element element2) {
        Boolean bl = this.trucObligatoire(element, element2, null);
        if (bl == null) {
            LOG.error("enfant non trouv\u00e9 sous un parent: " + this.nomElement(element2) + " sous " + this.nomElement(element));
            return false;
        }
        return bl;
    }

    @Override
    public boolean enfantsMultiples(Element element, Element element2) {
        return true;
    }

    @Override
    public ArrayList<Element> listeSousElements(Element element) {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            Object object2;
            Object object3;
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("element") && !"".equals(((Element)node).getAttribute("name"))) {
                linkedHashSet.add((Element)node);
                continue;
            }
            if (string.equals("zeroOrMore") || string.equals("oneOrMore") || string.equals("choice") || string.equals("group") || string.equals("optional") || string.equals("interleave")) {
                linkedHashSet.addAll(this.listeSousElements((Element)node));
                continue;
            }
            if (string.equals("ref")) {
                object3 = ((Element)node).getAttribute("name");
                object2 = this.ltousdefine.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!object.getAttribute("name").equals(object3)) continue;
                    linkedHashSet.addAll(this.listeSousElements((Element)object));
                }
                continue;
            }
            if (string.equals("anyName")) {
                object3 = new ArrayList();
                ((ArrayList)object3).addAll(this.elementsNommes);
                object2 = this.enfants((Element)node, "except");
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    Element element2 = (Element)object.next();
                    ArrayList<Element> arrayList = this.listeSousElements(element2);
                    ((ArrayList)object3).removeAll(arrayList);
                }
                linkedHashSet.addAll((Collection<Element>)object3);
                continue;
            }
            if (!string.equals("nsName")) continue;
            object3 = ((Element)node).getAttribute("ns");
            if ("".equals(object3)) {
                for (object2 = node.getParentNode(); object2 != null; object2 = object2.getParentNode()) {
                    if ("".equals(((Element)object2).getAttribute("ns"))) continue;
                    object3 = ((Element)object2).getAttribute("ns");
                    break;
                }
            }
            object2 = new HashSet<String>();
            ((HashSet)object2).add(object3);
            linkedHashSet.addAll(this.listeElementsDansEspaces((Set<String>)object2));
        }
        return new ArrayList<Element>(linkedHashSet);
    }

    @Override
    public String expressionReguliere(Element element, boolean bl, boolean bl2) {
        ArrayList<Element> arrayList = this.listeSousElements(element);
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append("|");
            }
            if (bl) {
                stringBuilder.append(this.cfg.titreElement(arrayList.get(i)));
            } else {
                stringBuilder.append(this.nomElement(arrayList.get(i)));
            }
            if (bl) continue;
            stringBuilder.append(",");
        }
        if (n != 0) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(")*");
        }
        return stringBuilder.toString();
    }

    public boolean documentValide(Document document, boolean bl) {
        String string = JaxeDocument.DOMVersXML(document);
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        ValidationDriver validationDriver = bl ? this.jingInsertion : this.jingValidation;
        try {
            return validationDriver.validate(inputSource);
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            LOG.error("Validation Jing : IOException", iOException);
            return false;
        }
    }

    @Override
    public ArrayList<Element> listeElementsParents(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element.getParentNode() == null) {
            return arrayList;
        }
        Element element2 = (Element)element.getParentNode();
        String string = element2.getLocalName();
        if ("element".equals(string)) {
            arrayList.add(element2);
        } else if (string.equals("zeroOrMore") || string.equals("oneOrMore") || string.equals("choice") || string.equals("group") || string.equals("optional") || string.equals("interleave")) {
            arrayList.addAll(this.listeElementsParents(element2));
        } else if (string.equals("define")) {
            String string2 = element2.getAttribute("name");
            for (Element element3 : this.ltousref) {
                if (!string2.equals(element3.getAttribute("name"))) continue;
                arrayList.addAll(this.listeElementsParents(element3));
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Element> listeAttributs(Element element) {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("attribute")) {
                linkedHashSet.add((Element)node);
                continue;
            }
            if (string.equals("optional") || string.equals("choice") || string.equals("interleave")) {
                linkedHashSet.addAll(this.listeAttributs((Element)node));
                continue;
            }
            if (!string.equals("ref")) continue;
            String string2 = ((Element)node).getAttribute("name");
            for (Element element2 : this.ltousdefine) {
                if (!element2.getAttribute("name").equals(string2)) continue;
                linkedHashSet.addAll(this.listeAttributs(element2));
            }
        }
        return new ArrayList<Element>(linkedHashSet);
    }

    @Override
    public String nomAttribut(Element element) {
        return SchemaRelaxNG.localValue(element.getAttribute("name"));
    }

    @Override
    public String espaceAttribut(Element element) {
        if (!"".equals(element.getAttribute("ns"))) {
            return element.getAttribute("ns");
        }
        if (SchemaRelaxNG.prefixeString(element.getAttribute("name")) != null) {
            return element.lookupNamespaceURI(SchemaRelaxNG.prefixeString(element.getAttribute("name")));
        }
        return null;
    }

    @Override
    public String documentationAttribut(Element element) {
        return null;
    }

    @Override
    public String espaceAttribut(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SchemaRelaxNG.prefixeString(string);
        if (string2 == null) {
            return null;
        }
        if ("xml".equals(string2)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String string3 = this.schema.getAttributeNS("http://www.w3.org/2000/xmlns/", string2);
        return string3;
    }

    @Override
    @Deprecated
    public boolean estObligatoire(Element element) {
        Element element2 = (Element)element.getParentNode();
        return !"optional".equals(element2.getLocalName());
    }

    @Override
    public boolean attributObligatoire(Element element, Element element2) {
        Boolean bl = this.trucObligatoire(element, element2, null);
        if (bl == null) {
            LOG.error("attribut non trouv\u00e9 sous un parent: " + this.nomAttribut(element2) + " sous " + this.nomElement(element));
            return false;
        }
        return bl;
    }

    private Boolean trucObligatoire(Element element, Element element2, ArrayList<Element> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList.contains(element)) {
            return null;
        }
        arrayList.add(element);
        block0: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            if (node == element2) {
                return Boolean.TRUE;
            }
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if ("optional".equals(string) || "zeroOrMore".equals(string) || "choice".equals(string)) {
                object = this.trucObligatoire((Element)node, element2, arrayList);
                if (object == null) continue;
                return Boolean.FALSE;
            }
            if ("ref".equals(string)) {
                object = ((Element)node).getAttribute("name");
                for (Element element3 : this.ltousdefine) {
                    if (!element3.getAttribute("name").equals(object)) continue;
                    Boolean bl = this.trucObligatoire(element3, element2, arrayList);
                    if (bl == null) continue block0;
                    return bl;
                }
                continue;
            }
            object = this.trucObligatoire((Element)node, element2, arrayList);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public ArrayList<String> listeValeursAttribut(Element element) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            ArrayList<String> arrayList;
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("choice")) {
                arrayList = this.listeValeursAttribut((Element)node);
                if (arrayList == null) continue;
                linkedHashSet.addAll(arrayList);
                continue;
            }
            if (string.equals("value")) {
                linkedHashSet.add(node.getFirstChild().getNodeValue());
                continue;
            }
            if (!string.equals("ref")) continue;
            arrayList = ((Element)node).getAttribute("name");
            for (Element element2 : this.ltousdefine) {
                ArrayList<String> arrayList2;
                if (!element2.getAttribute("name").equals(arrayList) || (arrayList2 = this.listeValeursAttribut(element2)) == null) continue;
                linkedHashSet.addAll(arrayList2);
            }
        }
        if (linkedHashSet.size() == 0) {
            return null;
        }
        return new ArrayList<String>(linkedHashSet);
    }

    @Override
    public String valeurParDefaut(Element element) {
        return null;
    }

    @Override
    public boolean attributValide(Element element, String string) {
        if ((string == null || "".equals(string)) && this.estObligatoire(element)) {
            return false;
        }
        return this.verifType(element, string);
    }

    @Override
    public Element parentAttribut(Element element) {
        return (Element)element.getParentNode();
    }

    @Override
    public boolean contientDuTexte(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("text") || string.equals("data") || string.equals("mixed")) {
                return true;
            }
            if (string.equals("ref")) {
                String string2 = ((Element)node).getAttribute("name");
                for (Element element2 : this.ltousdefine) {
                    if (!element2.getAttribute("name").equals(string2) || !this.contientDuTexte(element2)) continue;
                    return true;
                }
                continue;
            }
            if (!string.equals("interleave") && !string.equals("choice") && !string.equals("group") && !string.equals("zeroOrMore") && !string.equals("oneOrMore") || !this.contientDuTexte((Element)node)) continue;
            return true;
        }
        return false;
    }

    private Element chercherPremier(TypeObjetSchema typeObjetSchema, String string, String string2) {
        if (string == null) {
            return null;
        }
        switch (typeObjetSchema) {
            case ELEMENT: {
                for (Element element : this.elementsNommes) {
                    if (!string.equals(this.nomElement(element))) continue;
                    String string3 = this.espaceElement(element);
                    if ((string2 != null || string3 != null) && (string2 == null || !string2.equals(string3))) continue;
                    return element;
                }
                return null;
            }
        }
        return null;
    }

    private Element chercherPremier(TypeObjetSchema typeObjetSchema, String string) {
        if (string == null) {
            return null;
        }
        switch (typeObjetSchema) {
            case ELEMENT: {
                for (Element element : this.elementsNommes) {
                    if (!string.equals(this.nomElement(element))) continue;
                    return element;
                }
                return null;
            }
        }
        return null;
    }

    private static String localValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String prefixeString(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private static void addNodeList(ArrayList<Element> arrayList, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add((Element)nodeList.item(i));
        }
    }

    private ArrayList<Element> enfants(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getLocalName())) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private ArrayList<Element> listeTous(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagNameNS(this.schemaNamespace, string);
        SchemaRelaxNG.addNodeList(arrayList, nodeList);
        return arrayList;
    }

    private static enum TypeObjetSchema {
        ELEMENT;

    }
}

