/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.elements.JECData;
import jaxe.elements.JECommentaire;
import jaxe.elements.JEDivision;
import jaxe.elements.JEEquation;
import jaxe.elements.JEFichier;
import jaxe.elements.JEFormulaire;
import jaxe.elements.JEInconnu;
import jaxe.elements.JEItem;
import jaxe.elements.JEListe;
import jaxe.elements.JEListeChamps;
import jaxe.elements.JESauf;
import jaxe.elements.JEString;
import jaxe.elements.JEStyle;
import jaxe.elements.JESymbole;
import jaxe.elements.JESymbole2;
import jaxe.elements.JETable;
import jaxe.elements.JETableTexte;
import jaxe.elements.JETypeSimple;
import jaxe.elements.JEVide;
import jaxe.elements.JEZone;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JEFactory {
    private static final Logger LOG = Logger.getLogger(JEFactory.class);
    private static final ClassLoader pluginClassLoader = JEFactory.getPluginClassLoader();

    public static ClassLoader getPluginClassLoader() {
        ClassLoader classLoader;
        if (pluginClassLoader != null) {
            return pluginClassLoader;
        }
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = JEFactory.class.getClassLoader();
        }
        File file = new File("plugins");
        try {
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                ArrayList<URL> arrayList = new ArrayList<URL>();
                for (File file2 : fileArray) {
                    if (!file2.getName().endsWith(".jar")) continue;
                    arrayList.add(file2.toURI().toURL());
                }
                Serializable[] serializableArray = arrayList.toArray(new URL[arrayList.size()]);
                classLoader = new URLClassLoader((URL[])serializableArray, classLoader);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return classLoader;
    }

    public static JaxeElement createJE(JaxeDocument jaxeDocument, Element element, String string, String string2, Node node) {
        JaxeElement jaxeElement;
        block16: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("createJE(JaxeDocument, Element, String, String, Node) - doc=" + jaxeDocument + ", refElement=" + element + ", nom=" + string + ", typeNoeud=" + string2 + ", el=" + node);
            }
            if (jaxeDocument.cfg == null) {
                if ("instruction".equals(string2)) {
                    JESauf jESauf = new JESauf(jaxeDocument);
                    jESauf.setTarget(string);
                    return jESauf;
                }
                if ("commentaire".equals(string2)) {
                    return new JECommentaire(jaxeDocument);
                }
                if ("cdata".equals(string2)) {
                    return new JECData(jaxeDocument);
                }
                return new JEInconnu(jaxeDocument);
            }
            String string3 = jaxeDocument.cfg.typeAffichageNoeud(element, string, string2);
            if ("plugin".equals(string3)) {
                String string4 = jaxeDocument.cfg.valeurParametreElement(element, string2, string, "classe", null);
                try {
                    Class<?> clazz = Class.forName(string4, true, pluginClassLoader);
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz.getConstructor(JaxeDocument.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (constructor != null) {
                        Object[] objectArray = new Object[]{jaxeDocument};
                        jaxeElement = (JaxeElement)constructor.newInstance(objectArray);
                        break block16;
                    }
                    jaxeElement = (JaxeElement)clazz.newInstance();
                    jaxeElement.doc = jaxeDocument;
                }
                catch (Exception exception) {
                    LOG.error("JEFactory.createJE() - Plugin not found", exception);
                    if (string2.equals("commentaire")) {
                        jaxeElement = new JECommentaire(jaxeDocument);
                        break block16;
                    }
                    if (string2.equals("instruction")) {
                        jaxeElement = new JESauf(jaxeDocument);
                        ((JESauf)jaxeElement).setTarget(string);
                        break block16;
                    }
                    jaxeElement = new JEInconnu(jaxeDocument);
                }
            } else if (string2.equals("instruction")) {
                jaxeElement = new JESauf(jaxeDocument);
                ((JESauf)jaxeElement).setTarget(string);
            } else {
                jaxeElement = string2.equals("commentaire") ? new JECommentaire(jaxeDocument) : (string2.equals("cdata") ? new JECData(jaxeDocument) : (string3.equals("division") ? new JEDivision(jaxeDocument) : (string3.equals("liste") ? new JEListe(jaxeDocument) : (string3.equals("listechamps") ? new JEListeChamps(jaxeDocument) : (string3.equals("item") ? new JEItem(jaxeDocument) : (string3.equals("tableau") ? (node != null && node instanceof Element && JETable.preferreZone(jaxeDocument, (Element)node) ? new JEZone(jaxeDocument) : new JETable(jaxeDocument)) : (string3.equals("zone") ? new JEZone(jaxeDocument) : (string3.equals("string") ? new JEString(jaxeDocument) : (string3.equals("vide") ? new JEVide(jaxeDocument) : (string3.equals("fichier") ? new JEFichier(jaxeDocument) : (string3.equals("style") ? new JEStyle(jaxeDocument) : (string3.equals("symbole") ? new JESymbole(jaxeDocument) : (string3.equals("symbole2") ? new JESymbole2(jaxeDocument) : (string3.equals("equation") ? new JEEquation(jaxeDocument) : (string3.equals("tabletexte") ? new JETableTexte(jaxeDocument) : (string3.equals("typesimple") ? new JETypeSimple(jaxeDocument) : (string3.equals("formulaire") ? new JEFormulaire(jaxeDocument) : new JEInconnu(jaxeDocument))))))))))))))))));
            }
        }
        jaxeElement.refElement = element;
        return jaxeElement;
    }
}

