/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextesAttribut
extends JDialog {
    private org.w3c.dom.Document doc;
    private Element racine;
    private JPanel panelAffichage;
    private Node monNoeud;
    private String attributSelectionne;

    public TextesAttribut(org.w3c.dom.Document document, Node node, String string) {
        super((Frame)new JFrame(), Strings.get("titre.TextePourUnAttribut"));
        this.setModal(true);
        this.doc = document;
        this.monNoeud = node;
        this.attributSelectionne = string;
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(Strings.get("label.TextePourLAttribut") + " " + this.attributSelectionne), "North");
        this.panelAffichage = new JPanel();
        this.panelAffichage.setLayout(new BoxLayout(this.panelAffichage, 1));
        JScrollPane jScrollPane = new JScrollPane(this.panelAffichage);
        jScrollPane.setPreferredSize(new Dimension(400, 700));
        jPanel.add((Component)jScrollPane, "Center");
        this.creerPanelLangues();
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                TextesAttribut.this.nettoyerDOM();
                TextesAttribut.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(TextesAttribut.this.doc);
            }
        });
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void afficherTextesAttribut(Element element, Element element2, JPanel jPanel) {
        Element element3 = this.enregistrerStringsAttribut(element, element2.getAttribute("attribut"));
        this.afficherTitreDocumentation(element3, jPanel);
        for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"VALEUR_SUGGEREE".equals(node.getNodeName())) continue;
            this.afficherTitreValeur(element3, (Element)node, jPanel);
        }
    }

    private void afficherTitreDocumentation(final Element element, JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.Titre") + ": ");
        JTextField jTextField = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 != null) {
            jTextField.setText(Outils.getValeurElement(element2).trim());
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitre(documentEvent, element);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitre(documentEvent, element);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitre(documentEvent, element);
            }
        });
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(Strings.get("label.Documentation") + ": ");
        JTextArea jTextArea = new JTextArea(4, 12);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel3.add(jLabel2);
        jPanel3.add(jScrollPane);
        Element element3 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element3 != null) {
            jTextArea.setText(Outils.getValeurElement(element3).trim());
        }
        jTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurDocumentation(documentEvent, element);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurDocumentation(documentEvent, element);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurDocumentation(documentEvent, element);
            }
        });
    }

    private void afficherTitreValeur(final Element element, Element element2, JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        final String string = Outils.getValeurElement(element2);
        JLabel jLabel = new JLabel(Strings.get("label.TitreValeur") + " '" + string + "'");
        JTextField jTextField = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        Element element3 = Outils.getElementSelectionne(element, "TITRE_VALEUR", string, "valeur");
        if (element3 != null) {
            jTextField.setText(Outils.getValeurElement(element3));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitreValeur(documentEvent, element, string);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitreValeur(documentEvent, element, string);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TextesAttribut.this.ecouteurTitreValeur(documentEvent, element, string);
            }
        });
    }

    private void creerPanelLangues() {
        this.racine = this.doc.getDocumentElement();
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS");
        int n = nodeList.getLength();
        JPanel[] jPanelArray = new JPanel[n];
        for (int i = 0; i < n; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            Element element2 = this.enregistrerStringsElement(element);
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new BoxLayout(jPanelArray[i], 1));
            this.panelAffichage.add(jPanelArray[i]);
            jPanelArray[i].setBorder(new TitledBorder(element.getAttribute("langue").toUpperCase()));
            Element element3 = Outils.premierEnfantDeNom(this.racine, "AFFICHAGE_NOEUDS");
            Element element4 = (Element)this.monNoeud;
            Element element5 = Outils.getElementSelectionne(element4, "AFFICHAGE_ATTRIBUT", this.attributSelectionne, "attribut");
            if (element5 == null) continue;
            this.afficherTextesAttribut(element2, element5, jPanelArray[i]);
        }
    }

    private void ecouteurTitre(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerTitre(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurDocumentation(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerDocumentation(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void ecouteurTitreValeur(DocumentEvent documentEvent, Element element, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            this.enregistrerTitreValeur(element, string, string2);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private Element enregistrerStringsElement(Element element) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_ELEMENT", ((Element)this.monNoeud).getAttribute("element"), "element");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_ELEMENT");
            element.appendChild(element2);
            EditeurFichierConfig.setModif(true);
        }
        element2.setAttribute("element", ((Element)this.monNoeud).getAttribute("element"));
        return element2;
    }

    private void enregistrerTitre(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private void enregistrerDocumentation(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element2 == null) {
            element2 = this.doc.createElement("DOCUMENTATION");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private Element enregistrerStringsAttribut(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_ATTRIBUT", string, "attribut");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_ATTRIBUT");
            element.appendChild(element2);
            EditeurFichierConfig.setModif(true);
        }
        element2.setAttribute("attribut", string);
        return element2;
    }

    private Element enregistrerTitreValeur(Element element, String string, String string2) {
        Element element2 = Outils.getElementSelectionne(element, "TITRE_VALEUR", string, "valeur");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE_VALEUR");
            element.appendChild(element2);
        }
        element2.setAttribute("valeur", string);
        Outils.setValeurElement(this.doc, element2, string2);
        return element2;
    }

    private void nettoyerDOM() {
        this.nettoyer_STRINGS_ATTRIBUT();
    }

    private void nettoyer_STRINGS_ATTRIBUT() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_ATTRIBUT");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }
}

