/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.ChoixDuSchema;
import editeurconfig.ChoixRacine;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParcourirSchema {
    private EditeurFichierConfig appl;
    private Document doc;
    private Element racine;
    private Element langage;
    private Element fichier_schema;
    private String extension;

    public ParcourirSchema(EditeurFichierConfig editeurFichierConfig, Document document, Element element, String string) {
        this.appl = editeurFichierConfig;
        this.doc = document;
        this.racine = element;
        this.extension = string;
        this.afficher(string);
    }

    private void afficher(final String string) {
        File file = null;
        if (System.getProperty("os.name").indexOf("Linux") != -1 && System.getProperty("java.version").compareTo("1.7") < 0) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    return n > 0 && n < string2.length() - 1 && string2.substring(n + 1).toLowerCase().equals(string);
                }

                public String getDescription() {
                    return Strings.get("texte.Fichiers" + string.toUpperCase());
                }
            });
            if (jFileChooser.showOpenDialog(null) == 0) {
                file = jFileChooser.getSelectedFile();
            }
        } else {
            FileDialog fileDialog = new FileDialog((Frame)new JFrame(), null, 0);
            fileDialog.setVisible(true);
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                file = new File(fileDialog.getDirectory(), string2);
            }
        }
        if (file != null) {
            this.charger(file);
        } else {
            new ChoixDuSchema(this.appl, this.doc, this.racine);
        }
    }

    private void charger(File file) {
        ListeElements listeElements = null;
        try {
            URL uRL = file.toURI().toURL();
            listeElements = new ListeElements(uRL, null, null);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Erreur urlFichier " + malformedURLException);
        }
        this.enregistrerElementLangage();
        this.enregistrerElementSchema(file);
        new ChoixRacine(this.appl, true, this.doc, this.racine, listeElements);
    }

    private void enregistrerElementLangage() {
        this.langage = this.doc.createElement("LANGAGE");
        this.racine.insertBefore(this.langage, Outils.premierEnfantDeNom(this.racine, "STRINGS"));
    }

    private void enregistrerElementSchema(File file) {
        this.fichier_schema = this.doc.createElement("FICHIER_SCHEMA");
        this.fichier_schema.setAttribute("nom", file.getName());
        this.langage.appendChild(this.fichier_schema);
        EditeurFichierConfig.setModif(true);
    }
}

