/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetrePrincipale;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EditeurEnregistrement
extends JFrame {
    private FenetrePrincipale fe;
    private org.w3c.dom.Document doc;
    private Element racine;
    private Element enregistrement;
    private JPanel panelBoutonsBas;
    private JPanel panelEnregistrement;
    private JPanel listePanelPrefixeEspace;

    public EditeurEnregistrement(FenetrePrincipale fenetrePrincipale, org.w3c.dom.Document document, Element element) {
        super(Strings.get("titre.EditeurEnregistrement"));
        this.fe = fenetrePrincipale;
        this.doc = document;
        this.racine = element;
        Element element2 = Outils.premierEnfantDeNom(element, "LANGAGE");
        this.enregistrement = Outils.premierEnfantDeNom(element, "ENREGISTREMENT");
        if (this.enregistrement == null) {
            this.enregistrement = document.createElement("ENREGISTREMENT");
            if (element2.getNextSibling() != null) {
                element.insertBefore(this.enregistrement, element2.getNextSibling());
            } else {
                element.appendChild(this.enregistrement);
            }
        }
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        this.setLayout(new BorderLayout());
        this.panelEnregistrement = new JPanel();
        this.panelEnregistrement.setLayout(new BoxLayout(this.panelEnregistrement, 1));
        JScrollPane jScrollPane = new JScrollPane(this.panelEnregistrement);
        this.add((Component)jScrollPane, "Center");
        this.creerPanelEnregistrement();
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(EditeurEnregistrement.this.doc);
            }
        });
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurEnregistrement.this.nettoyerDOM();
                EditeurEnregistrement.this.setVisible(false);
                EditeurEnregistrement.this.fe.setVisible(true);
            }
        });
        jPanel.add(jButton2);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelEnregistrement() {
        this.creerPanelEncodage();
        this.creerPanelDoctype();
        this.creerPanelSchemaLocation();
        this.listePanelPrefixeEspace = new JPanel();
        this.listePanelPrefixeEspace.setLayout(new BoxLayout(this.listePanelPrefixeEspace, 1));
        this.panelEnregistrement.add(this.listePanelPrefixeEspace);
        this.recupererPrefixeEspace();
    }

    private void creerPanelEncodage() {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "ENCODAGE");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.panelEnregistrement.add(jPanel);
        JLabel jLabel = new JLabel(Strings.get("label.Encodage"));
        JTextField jTextField = new JTextField(15);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        if (element != null) {
            jTextField.setText(Outils.getValeurElement(element));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurEncodage(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurEncodage(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurEncodage(documentEvent);
            }
        });
    }

    private void creerPanelDoctype() {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "DOCTYPE");
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.panelEnregistrement.add(jPanel);
        jPanel.setBorder(new TitledBorder(Strings.get("label.Doctype")));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.PublicId"));
        JTextField jTextField = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        if (element != null) {
            jTextField.setText(element.getAttribute("publicId"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "publicId");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "publicId");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "publicId");
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(Strings.get("label.SystemId"));
        JTextField jTextField2 = new JTextField(15);
        jPanel3.add(jLabel2);
        jPanel3.add(jTextField2);
        if (element != null) {
            jTextField2.setText(element.getAttribute("systemId"));
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "systemId");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "systemId");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurDoctype(documentEvent, "systemId");
            }
        });
    }

    private void creerPanelSchemaLocation() {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "SCHEMALOCATION");
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.panelEnregistrement.add(jPanel);
        jPanel.setBorder(new TitledBorder(Strings.get("label.SchemaLocation")));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.schemaLocation"));
        JTextField jTextField = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        if (element != null) {
            jTextField.setText(element.getAttribute("schemaLocation"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "schemaLocation");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "schemaLocation");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "schemaLocation");
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(Strings.get("label.NoNameSpaceShemaLocation"));
        JTextField jTextField2 = new JTextField(15);
        jPanel3.add(jLabel2);
        jPanel3.add(jTextField2);
        if (element != null) {
            jTextField2.setText(element.getAttribute("noNamespaceSchemaLocation"));
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "noNamespaceSchemaLocation");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "noNamespaceSchemaLocation");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurSchemaLocation(documentEvent, "noNamespaceSchemaLocation");
            }
        });
    }

    private void creerPanelPrefixeEspace(Element element, final int n) {
        final JPanel jPanel = new JPanel(new FlowLayout(0));
        this.listePanelPrefixeEspace.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel.add(jPanel2);
        jPanel2.setBorder(new TitledBorder(Strings.get("label.PrefixeEspace")));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel3);
        JLabel jLabel = new JLabel(Strings.get("label.Prefixe"));
        final JTextField jTextField = new JTextField(15);
        jPanel3.add(jLabel);
        jPanel3.add(jTextField);
        if (element != null) {
            jTextField.setText(element.getAttribute("prefixe"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "prefixe");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "prefixe");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "prefixe");
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel4);
        JLabel jLabel2 = new JLabel(Strings.get("label.URI"));
        final JTextField jTextField2 = new JTextField(15);
        jPanel4.add(jLabel2);
        jPanel4.add(jTextField2);
        if (element != null) {
            jTextField2.setText(element.getAttribute("uri"));
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "uri");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "uri");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurEnregistrement.this.ecouteurPrefixeEspace(documentEvent, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentZOrder(jPanel), "uri");
            }
        });
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel.add(jPanel5);
        JButton jButton = new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!"".equals(jTextField.getText()) && !"".equals(jTextField2.getText())) {
                    EditeurEnregistrement.this.creerPanelPrefixeEspace(null, EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentCount());
                    EditeurEnregistrement.this.listePanelPrefixeEspace.revalidate();
                }
            }
        });
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurEnregistrement.this.listePanelPrefixeEspace.getComponentCount() > 1) {
                    EditeurEnregistrement.this.listePanelPrefixeEspace.remove(jPanel);
                    EditeurEnregistrement.this.listePanelPrefixeEspace.revalidate();
                    Element element = EditeurEnregistrement.this.trouverPrefixeEspace(n);
                    if (element != null) {
                        element.getParentNode().removeChild(element);
                    }
                }
            }
        });
        jPanel5.add(jButton2);
    }

    private void ecouteurEncodage(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerEncodage(string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurDoctype(DocumentEvent documentEvent, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            if ("publicId".equals(string)) {
                this.enregistrerDoctype(string2, null);
            }
            if ("systemId".equals(string)) {
                this.enregistrerDoctype(null, string2);
            }
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurSchemaLocation(DocumentEvent documentEvent, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            if ("schemaLocation".equals(string)) {
                this.enregistrerSchemaLocation(string2, null);
            }
            if ("noNamespaceSchemaLocation".equals(string)) {
                this.enregistrerSchemaLocation(null, string2);
            }
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurPrefixeEspace(DocumentEvent documentEvent, int n, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            if ("prefixe".equals(string)) {
                this.enregistrerPrefixeEspace(n, string2, null);
            }
            if ("uri".equals(string)) {
                this.enregistrerPrefixeEspace(n, null, string2);
            }
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private Element enregistrerEncodage(String string) {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "DOCTYPE");
        Element element2 = Outils.premierEnfantDeNom(this.enregistrement, "ENCODAGE");
        if (element2 == null) {
            element2 = this.doc.createElement("ENCODAGE");
            if (element != null) {
                this.enregistrement.insertBefore(element2, element);
            } else {
                this.enregistrement.appendChild(element2);
            }
        }
        if (string != null) {
            Outils.setValeurElement(this.doc, element2, string);
        }
        return element2;
    }

    private Element enregistrerDoctype(String string, String string2) {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "SCHEMALOCATION");
        Element element2 = Outils.premierEnfantDeNom(this.enregistrement, "DOCTYPE");
        if (element2 == null) {
            element2 = this.doc.createElement("DOCTYPE");
            if (element != null) {
                this.enregistrement.insertBefore(element2, element);
            } else {
                this.enregistrement.appendChild(element2);
            }
        }
        if (string != null) {
            element2.setAttribute("publicId", string);
        }
        if (string2 != null) {
            element2.setAttribute("systemId", string2);
        }
        return element2;
    }

    private Element enregistrerSchemaLocation(String string, String string2) {
        Element element = Outils.premierEnfantDeNom(this.enregistrement, "PREFIXE_ESPACE");
        Element element2 = Outils.premierEnfantDeNom(this.enregistrement, "SCHEMALOCATION");
        if (element2 == null) {
            element2 = this.doc.createElement("SCHEMALOCATION");
            if (element != null) {
                this.enregistrement.insertBefore(element2, element);
            } else {
                this.enregistrement.appendChild(element2);
            }
        }
        if (string != null) {
            element2.setAttribute("schemaLocation", string);
        }
        if (string2 != null) {
            element2.setAttribute("noNamespaceSchemaLocation", string2);
        }
        return element2;
    }

    private Element enregistrerPrefixeEspace(int n, String string, String string2) {
        Element element = this.trouverPrefixeEspace(n);
        if (element == null) {
            element = this.doc.createElement("PREFIXE_ESPACE");
            this.enregistrement.appendChild(element);
        }
        if (string != null) {
            element.setAttribute("prefixe", string);
        }
        if (string2 != null) {
            element.setAttribute("uri", string2);
        }
        return element;
    }

    private Element trouverPrefixeEspace(int n) {
        if (n == -1) {
            return null;
        }
        if (this.enregistrement == null) {
            return null;
        }
        int n2 = 0;
        for (Node node = this.enregistrement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"PREFIXE_ESPACE".equals(node.getNodeName())) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private void recupererPrefixeEspace() {
        this.listePanelPrefixeEspace.removeAll();
        if (this.enregistrement != null) {
            Element element = Outils.premierEnfantDeNom(this.enregistrement, "PREFIXE_ESPACE");
            this.creerPanelPrefixeEspace(element, 0);
            int n = this.enregistrement.getChildNodes().getLength();
            for (int i = 1; i < n; ++i) {
                if ((element = Outils.enfantSuivantDeMemeNom(element)) == null) continue;
                this.creerPanelPrefixeEspace(element, i);
            }
        }
    }

    private void nettoyerDOM() {
        if (!this.enregistrement.hasChildNodes()) {
            this.racine.removeChild(this.enregistrement);
        } else {
            Node node;
            for (node = this.enregistrement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"ENCODAGE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                this.enregistrement.removeChild(node);
            }
            for (node = this.enregistrement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCTYPE".equals(node.getNodeName()) || ((Element)node).hasAttribute("publicId") && ((Element)node).hasAttribute("systemId") && !"".equals(((Element)node).getAttribute("publicId")) && !"".equals(((Element)node).getAttribute("systemId"))) continue;
                this.enregistrement.removeChild(node);
            }
            for (node = this.enregistrement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"SCHEMALOCATION".equals(node.getNodeName()) || ((Element)node).hasAttribute("noNamespaceSchemaLocation") && ((Element)node).hasAttribute("schemaLocation") && !"".equals(((Element)node).getAttribute("noNamespaceSchemaLocation")) && !"".equals(((Element)node).getAttribute("schemaLocation"))) continue;
                this.enregistrement.removeChild(node);
            }
            for (node = this.enregistrement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"PREFIXE_ESPACE".equals(node.getNodeName()) || ((Element)node).hasAttribute("prefixe") && ((Element)node).hasAttribute("uri") && !"".equals(((Element)node).getAttribute("prefixe")) && !"".equals(((Element)node).getAttribute("uri"))) continue;
                this.enregistrement.removeChild(node);
            }
        }
    }
}

