/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetrePrincipale;
import editeurconfig.InfosNoeud;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditeurDesTextes
extends JFrame {
    private String laSelection = "";
    private ArrayList<String> listeAttributs = new ArrayList();
    private InfosNoeud infosNoeud;
    private Node monNoeud;
    private FenetrePrincipale fe;
    private ListeElements listeElements;
    private org.w3c.dom.Document doc;
    private Element racine;
    private Element menus;
    private Element affichage_noeuds;
    private Element exports;
    private JPanel panelAF;
    private JPanel panelFormulaire;
    private JPanel panelArbres;
    private JButton bRetirer;
    private JButton bOKK;

    public EditeurDesTextes(FenetrePrincipale fenetrePrincipale, org.w3c.dom.Document document, Element element, ListeElements listeElements) {
        super(Strings.get("titre.EditeurDesTextes"));
        this.fe = fenetrePrincipale;
        this.doc = document;
        this.racine = element;
        this.listeElements = listeElements;
        this.menus = Outils.premierEnfantDeNom(element, "MENUS");
        this.affichage_noeuds = Outils.premierEnfantDeNom(element, "AFFICHAGE_NOEUDS");
        this.exports = Outils.premierEnfantDeNom(element, "EXPORTS");
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        Object object;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.add((Component)jPanel, "North");
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.AjouterLangue")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesTextes.this.ajouterLangue();
            }
        });
        jPanel.add(jButton);
        this.bRetirer = new JButton(new AbstractAction(Strings.get("bouton.RetirerLangue")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesTextes.this.retirer();
            }
        });
        this.bRetirer.setEnabled(false);
        jPanel.add(this.bRetirer);
        this.panelAF = new JPanel(new GridLayout(1, 2));
        this.add((Component)this.panelAF, "Center");
        this.panelArbres = new JPanel();
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            object = (Element)nodeList.item(i);
            this.remplirDOM((Element)object);
            this.creerArbre((Element)object);
        }
        this.panelArbres.setLayout(new BoxLayout(this.panelArbres, 1));
        this.panelArbres.setBorder(new TitledBorder(Strings.get("label.DefinirLesTextes")));
        this.panelAF.add(this.panelArbres);
        this.panelFormulaire = new JPanel();
        this.panelFormulaire.setLayout(new BoxLayout(this.panelFormulaire, 1));
        JScrollPane jScrollPane = new JScrollPane(this.panelFormulaire);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(500, 800));
        this.panelAF.add(jScrollPane);
        object = new JPanel(new FlowLayout());
        this.add((Component)object, "South");
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesTextes.this.nettoyerDOM();
                EditeurDesTextes.this.setVisible(false);
                EditeurDesTextes.this.fe.setVisible(true);
            }
        });
        ((Container)object).add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(EditeurDesTextes.this.doc);
            }
        });
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void remplirDOM(Element element) {
        Node node;
        this.remplirStringMenu(this.menus, element);
        if (this.affichage_noeuds != null) {
            for (node = this.affichage_noeuds.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"AFFICHAGE_ELEMENT".equals(node.getNodeName())) continue;
                this.enregistrerStringsElement(element, ((Element)node).getAttribute("element"));
            }
        }
        if (this.exports != null) {
            for (node = this.exports.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"EXPORT".equals(node.getNodeName())) continue;
                this.enregistrerStringsExport(element, ((Element)node).getAttribute("nom"));
            }
        }
    }

    private void remplirStringMenu(Node node, Element element) {
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!"MENU".equals(node2.getNodeName())) continue;
                Element element2 = this.enregistrerStringsMenu(element, ((Element)node2).getAttribute("nom"));
                this.remplirStringMenu(node2, element2);
            }
        }
    }

    private void creerArbre(final Element element) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new InfosNoeud(element));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        final JTree jTree = new JTree(defaultTreeModel);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setShowsRootHandles(true);
        this.remplirArbre(defaultMutableTreeNode, defaultTreeModel, element);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.panelArbres.add(jScrollPane);
        this.panelArbres.revalidate();
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = jTree.getLastSelectedPathComponent();
                if (object != null) {
                    EditeurDesTextes.this.laSelection = object.toString();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    EditeurDesTextes.this.deselectionner(jTree);
                    if (defaultMutableTreeNode.getUserObject() instanceof InfosNoeud) {
                        if (defaultMutableTreeNode.isRoot()) {
                            EditeurDesTextes.this.panelFormulaire.setVisible(false);
                            EditeurDesTextes.this.bRetirer.setEnabled(true);
                        } else {
                            EditeurDesTextes.this.panelFormulaire.setVisible(true);
                            EditeurDesTextes.this.bRetirer.setEnabled(false);
                        }
                        EditeurDesTextes.this.infosNoeud = (InfosNoeud)defaultMutableTreeNode.getUserObject();
                        EditeurDesTextes.this.monNoeud = EditeurDesTextes.this.infosNoeud.getNoeud();
                        if ("DESCRIPTION_CONFIG".equals(EditeurDesTextes.this.monNoeud.getNodeName())) {
                            EditeurDesTextes.this.afficherTextesDescriptionConfig(element);
                        }
                        if ("STRINGS_MENU".equals(EditeurDesTextes.this.monNoeud.getNodeName())) {
                            EditeurDesTextes.this.afficherTextesMenu(element);
                        }
                        if ("STRINGS_ELEMENT".equals(EditeurDesTextes.this.monNoeud.getNodeName())) {
                            EditeurDesTextes.this.afficherTextesElement(element);
                        }
                        if ("STRINGS_EXPORT".equals(EditeurDesTextes.this.monNoeud.getNodeName())) {
                            EditeurDesTextes.this.afficherTextesExport(element);
                        }
                    } else {
                        EditeurDesTextes.this.panelFormulaire.setVisible(false);
                    }
                } else {
                    EditeurDesTextes.this.panelFormulaire.setVisible(false);
                    EditeurDesTextes.this.bRetirer.setEnabled(false);
                }
            }
        });
    }

    private void deselectionner(JTree jTree) {
        for (int i = 0; i < this.panelArbres.getComponentCount(); ++i) {
            Component component = this.panelArbres.getComponent(i);
            for (int j = 0; j < ((JScrollPane)component).getComponentCount(); ++j) {
                Component component2 = ((JScrollPane)component).getComponent(j);
                if (!(component2 instanceof JViewport)) continue;
                for (int k = 0; k < ((JViewport)component2).getComponentCount(); ++k) {
                    Component component3 = ((JViewport)component2).getComponent(k);
                    if (!(component3 instanceof JTree) || (JTree)component3 == jTree) continue;
                    ((JTree)component3).clearSelection();
                }
            }
        }
    }

    private void remplirArbre(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel, Element element) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        Element element2 = Outils.premierEnfantDeNom(element, "DESCRIPTION_CONFIG");
        if (element2 == null) {
            element2 = this.enregistrerDescriptionConfig(element, null);
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new InfosNoeud(element2));
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        if (this.menus != null) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(Strings.get("texte.textesMenu"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.remplirTextesMenu(element, defaultMutableTreeNode2);
        }
        if (this.affichage_noeuds != null) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(Strings.get("texte.textesElement"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.remplirTextesElement(element, defaultMutableTreeNode2);
        }
        if (this.exports != null) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(Strings.get("texte.textesExport"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.remplirTextesExport(element, defaultMutableTreeNode2);
        }
        defaultTreeModel.reload();
    }

    private void remplirTextesMenu(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!"STRINGS_MENU".equals(node2.getNodeName())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new InfosNoeud(node2));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.remplirTextesMenu(node2, defaultMutableTreeNode2);
        }
    }

    private void remplirTextesElement(Element element, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"STRINGS_ELEMENT".equals(node.getNodeName())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new InfosNoeud(node));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void remplirTextesExport(Element element, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"STRINGS_EXPORT".equals(node.getNodeName())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new InfosNoeud(node));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void ajouterLangue() {
        final JDialog jDialog = new JDialog(this, Strings.get("titre.SaisirLaLangue"), true);
        JPanel jPanel = new JPanel(new FlowLayout());
        final JTextField jTextField = new JTextField(6);
        jPanel.add(jTextField);
        jTextField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    EditeurDesTextes.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    EditeurDesTextes.this.bOKK.setEnabled(true);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    EditeurDesTextes.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    EditeurDesTextes.this.bOKK.setEnabled(true);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (jTextField.getText().length() > 2 || jTextField.getText().length() < 2) {
                    jTextField.setForeground(Color.red);
                    EditeurDesTextes.this.bOKK.setEnabled(false);
                } else {
                    jTextField.setForeground(Color.black);
                    EditeurDesTextes.this.bOKK.setEnabled(true);
                }
            }
        });
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel.add(jButton);
        this.bOKK = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!EditeurDesTextes.this.codeLangueValide(jTextField.getText())) {
                    JOptionPane.showMessageDialog(jDialog, Strings.get("message.CodeLangueNonValide"));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                } else {
                    Element element = EditeurDesTextes.this.enregistrerStrings(jTextField.getText());
                    if (element == null) {
                        JOptionPane.showMessageDialog(jDialog, Strings.get("message.LangueExiste"));
                        jTextField.requestFocus();
                        jTextField.selectAll();
                    } else {
                        jDialog.setVisible(false);
                        EditeurDesTextes.this.remplirDOM(element);
                        EditeurDesTextes.this.creerArbre(element);
                    }
                }
            }
        });
        jPanel.add(this.bOKK);
        this.bOKK.setEnabled(false);
        jDialog.add(jPanel);
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void retirer() {
        if (JOptionPane.showConfirmDialog(this, Strings.get("message.SupprimerCetteLangue"), Strings.get("titre.Message"), 0) == 0) {
            Element element = (Element)this.monNoeud;
            if (element != null) {
                this.racine.removeChild(element);
                EditeurFichierConfig.setModif(true);
                for (int i = 0; i < this.panelArbres.getComponentCount(); ++i) {
                    Component component = this.panelArbres.getComponent(i);
                    for (int j = 0; j < ((JScrollPane)component).getComponentCount(); ++j) {
                        Component component2 = ((JScrollPane)component).getComponent(j);
                        if (!(component2 instanceof JViewport)) continue;
                        for (int k = 0; k < ((JViewport)component2).getComponentCount(); ++k) {
                            Component component3 = ((JViewport)component2).getComponent(k);
                            if (!(component3 instanceof JTree) || !((JTree)component3).getModel().getRoot().toString().equals(element.getAttribute("langue"))) continue;
                            this.panelArbres.remove(component);
                            this.panelArbres.revalidate();
                            this.panelArbres.repaint();
                        }
                    }
                }
            } else {
                System.out.println("strings NULL");
            }
        }
    }

    private void afficherTextesDescriptionConfig(final Element element) {
        this.panelFormulaire.removeAll();
        this.panelFormulaire.setBorder(new TitledBorder(Strings.get("label.TextePour") + " " + this.laSelection));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.panelFormulaire.add(jPanel);
        JLabel jLabel = new JLabel(Strings.get("label.DescriptionConfig") + ": ");
        JTextArea jTextArea = new JTextArea(4, 6);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        Element element2 = Outils.premierEnfantDeNom(element, "DESCRIPTION_CONFIG");
        if (element2 != null) {
            jTextArea.setText(Outils.getValeurElement(element2).trim());
        }
        jTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDescription(documentEvent, element);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDescription(documentEvent, element);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDescription(documentEvent, element);
            }
        });
        this.panelFormulaire.revalidate();
    }

    private void afficherTextesMenu(Element element) {
        this.panelFormulaire.removeAll();
        this.panelFormulaire.setBorder(new TitledBorder(Strings.get("label.TextePour") + " " + this.laSelection));
        Element element2 = (Element)this.monNoeud;
        this.afficherTitreDocumentation(element2, this.panelFormulaire);
        this.panelFormulaire.revalidate();
    }

    private void afficherTextesElement(Element element) {
        this.panelFormulaire.removeAll();
        this.panelFormulaire.setBorder(new TitledBorder(Strings.get("label.TextePour") + " " + this.laSelection));
        Element element2 = (Element)this.monNoeud;
        Element element3 = Outils.getElementSelectionne(this.affichage_noeuds, "AFFICHAGE_ELEMENT", this.infosNoeud.toString(), "element");
        this.afficherTitreDocumentation(element2, this.panelFormulaire);
        for (Node node = element3.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"VALEUR_SUGGEREE".equals(node.getNodeName())) continue;
            this.afficherTitreValeur(element2, (Element)node, this.panelFormulaire);
        }
        if (this.listeAttributs != null) {
            this.listeAttributs.clear();
        }
        this.listeAttributs = this.listeElements.getAttributElement(this.listeElements.getReferenceElement(this.infosNoeud.toString()));
        if (this.listeAttributs != null) {
            for (int i = 0; i < this.listeAttributs.size(); ++i) {
                this.afficherTextesAttribut(element2, element3, this.listeAttributs.get(i).toString());
            }
        }
        this.panelFormulaire.revalidate();
    }

    private void afficherTitreDocumentation(final Element element, JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.Titre") + ": ");
        JTextField jTextField = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 != null) {
            jTextField.setText(Outils.getValeurElement(element2).trim());
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitre(documentEvent, element);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitre(documentEvent, element);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitre(documentEvent, element);
            }
        });
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(Strings.get("label.Documentation") + ": ");
        JTextArea jTextArea = new JTextArea(4, 12);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel3.add(jLabel2);
        jPanel3.add(jScrollPane);
        Element element3 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element3 != null) {
            jTextArea.setText(Outils.getValeurElement(element3).trim());
        }
        jTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDocumentation(documentEvent, element);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDocumentation(documentEvent, element);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurDocumentation(documentEvent, element);
            }
        });
    }

    private void afficherTitreValeur(final Element element, Element element2, JPanel jPanel) {
        Element element3;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        final String string = Outils.getValeurElement(element2);
        JLabel jLabel = new JLabel(Strings.get("label.TitreValeur") + " '" + string + "'");
        JTextField jTextField = new JTextField(15);
        if (string != null) {
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
        }
        if ((element3 = Outils.getElementSelectionne(element, "TITRE_VALEUR", string, "valeur")) != null) {
            jTextField.setText(Outils.getValeurElement(element3));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitreValeur(documentEvent, element, string);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitreValeur(documentEvent, element, string);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesTextes.this.ecouteurTitreValeur(documentEvent, element, string);
            }
        });
    }

    private void afficherTextesAttribut(Element element, Element element2, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(Strings.get("label.TextesAttribut") + " '" + string + "'"));
        this.panelFormulaire.add(jPanel);
        Element element3 = this.enregistrerStringsAttribut(element, string);
        this.afficherTitreDocumentation(element3, jPanel);
        Element element4 = Outils.getElementSelectionne(element2, "AFFICHAGE_ATTRIBUT", string, "attribut");
        if (element4 != null) {
            for (Node node = element4.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !"VALEUR_SUGGEREE".equals(node.getNodeName())) continue;
                this.afficherTitreValeur(element3, (Element)node, jPanel);
            }
        }
    }

    private void afficherTextesExport(Element element) {
        this.panelFormulaire.removeAll();
        this.panelFormulaire.setBorder(new TitledBorder(Strings.get("label.TextePour") + " " + this.laSelection));
        Element element2 = (Element)this.monNoeud;
        this.afficherTitreDocumentation(element2, this.panelFormulaire);
        this.panelFormulaire.revalidate();
    }

    private void ecouteurDescription(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerDescriptionConfig(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurTitre(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerTitre(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurDocumentation(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerDocumentation(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void ecouteurTitreValeur(DocumentEvent documentEvent, Element element, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            this.enregistrerTitreValeur(element, string, string2);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private Element enregistrerStrings(String string) {
        Element element = Outils.getElementSelectionne(this.racine, "STRINGS", string.toLowerCase(), "langue");
        if (element == null) {
            Element element2 = this.doc.createElement("STRINGS");
            this.racine.appendChild(element2);
            if (string != null) {
                element2.setAttribute("langue", string.toLowerCase());
            }
            EditeurFichierConfig.setModif(true);
            return element2;
        }
        return null;
    }

    private Element enregistrerDescriptionConfig(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "DESCRIPTION_CONFIG");
        if (element2 == null) {
            element2 = this.doc.createElement("DESCRIPTION_CONFIG");
            element.insertBefore(element2, Outils.premierEnfantDeNom(element, "STRINGS_MENU"));
        }
        if (string != null) {
            Outils.setValeurElement(this.doc, element2, string);
        }
        EditeurFichierConfig.setModif(true);
        return element2;
    }

    private Element enregistrerStringsMenu(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_MENU", string, "menu");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_MENU");
            if (Outils.premierEnfantDeNom(element, "STRINGS_ELEMENT") != null) {
                element.insertBefore(element2, Outils.premierEnfantDeNom(element, "STRINGS_ELEMENT"));
            } else {
                element.appendChild(element2);
            }
            element2.setAttribute("menu", string);
            EditeurFichierConfig.setModif(true);
        }
        return element2;
    }

    private Element enregistrerStringsElement(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_ELEMENT", string, "element");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_ELEMENT");
            element.appendChild(element2);
            element2.setAttribute("element", string);
            EditeurFichierConfig.setModif(true);
        }
        return element2;
    }

    private void enregistrerTitre(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private void enregistrerDocumentation(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element2 == null) {
            element2 = this.doc.createElement("DOCUMENTATION");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private Element enregistrerStringsAttribut(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_ATTRIBUT", string, "attribut");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_ATTRIBUT");
            element.appendChild(element2);
        }
        element2.setAttribute("attribut", string);
        return element2;
    }

    private Element enregistrerTitreValeur(Element element, String string, String string2) {
        Element element2 = Outils.getElementSelectionne(element, "TITRE_VALEUR", string, "valeur");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE_VALEUR");
            element.appendChild(element2);
        }
        element2.setAttribute("valeur", string);
        Outils.setValeurElement(this.doc, element2, string2);
        return element2;
    }

    private Element enregistrerStringsExport(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_EXPORT", string, "export");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_EXPORT");
            element.appendChild(element2);
            element2.setAttribute("export", string);
            EditeurFichierConfig.setModif(true);
        }
        return element2;
    }

    private boolean codeLangueValide(String string) {
        String[] stringArray = Locale.getISOLanguages();
        return Arrays.asList(stringArray).contains(string);
    }

    private void nettoyerDOM() {
        this.nettoyer_STRINGS_MENU();
        this.nettoyer_STRINGS_ELEMENT();
        this.nettoyer_STRINGS_ATTRIBUT();
        this.nettoyer_STRINGS_EXPORT();
    }

    private void nettoyer_STRINGS_MENU() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_MENU");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }

    private void nettoyer_STRINGS_ELEMENT() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_ELEMENT");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }

    private void nettoyer_STRINGS_ATTRIBUT() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_ATTRIBUT");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }

    private void nettoyer_STRINGS_EXPORT() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_EXPORT");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }
}

