/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetrePrincipale;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EditeurDesExports
extends JFrame {
    private FenetrePrincipale fe;
    private org.w3c.dom.Document doc;
    private Element racine;
    private Element exports;
    private File fichierXML;
    private static final String[] sorties = new String[]{"HTML", "XML", "PDF"};
    private JPanel listePanelExport;

    public EditeurDesExports(FenetrePrincipale fenetrePrincipale, org.w3c.dom.Document document, Element element, File file) {
        super(Strings.get("titre.EditeurDesExports"));
        this.fe = fenetrePrincipale;
        this.doc = document;
        this.racine = element;
        this.fichierXML = file;
        this.exports = Outils.premierEnfantDeNom(element, "EXPORTS");
        if (this.exports == null) {
            this.exports = document.createElement("EXPORTS");
            element.insertBefore(this.exports, Outils.premierEnfantDeNom(element, "STRINGS"));
        }
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        this.setLayout(new BorderLayout());
        this.listePanelExport = new JPanel();
        this.listePanelExport.setLayout(new BoxLayout(this.listePanelExport, 1));
        JScrollPane jScrollPane = new JScrollPane(this.listePanelExport);
        this.add((Component)jScrollPane, "Center");
        this.recupererExport();
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(EditeurDesExports.this.doc);
            }
        });
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesExports.this.nettoyerDOM();
                EditeurDesExports.this.setVisible(false);
                EditeurDesExports.this.fe.setVisible(true);
            }
        });
        jPanel.add(jButton2);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelExport(Element element, final int n) {
        final JPanel jPanel = new JPanel(new FlowLayout(0));
        this.listePanelExport.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new TitledBorder(Strings.get("label.Export")));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel3);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        JTextField jTextField = new JTextField(15);
        jPanel3.add(jLabel);
        jPanel3.add(jTextField);
        if (element != null) {
            jTextField.setText(element.getAttribute("nom"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurExport(documentEvent, EditeurDesExports.this.listePanelExport.getComponentZOrder(jPanel));
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurExport(documentEvent, EditeurDesExports.this.listePanelExport.getComponentZOrder(jPanel));
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurExport(documentEvent, EditeurDesExports.this.listePanelExport.getComponentZOrder(jPanel));
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel4);
        JLabel jLabel2 = new JLabel(Strings.get("label.Sortie"));
        final JComboBox<String> jComboBox = new JComboBox<String>(sorties);
        jPanel4.add(jLabel2);
        jPanel4.add(jComboBox);
        jComboBox.setSelectedIndex(0);
        if (element != null) {
            jComboBox.setSelectedItem(element.getAttribute("sortie"));
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (jComboBox.getSelectedItem() != null) {
                    EditeurDesExports.this.enregistrerExport(n, null, jComboBox.getSelectedItem().toString());
                }
            }
        });
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel.add(jPanel5);
        JButton jButton = new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                Element element = EditeurDesExports.this.enregistrerExport(EditeurDesExports.this.listePanelExport.getComponentCount(), null, null);
                EditeurDesExports.this.creerPanelExport(element, EditeurDesExports.this.listePanelExport.getComponentCount());
                EditeurDesExports.this.listePanelExport.revalidate();
            }
        });
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurDesExports.this.listePanelExport.getComponentCount() > 1) {
                    EditeurDesExports.this.listePanelExport.remove(jPanel);
                    EditeurDesExports.this.listePanelExport.revalidate();
                    Element element = EditeurDesExports.this.trouverExport(n);
                    if (element != null) {
                        element.getParentNode().removeChild(element);
                        EditeurFichierConfig.setModif(true);
                    }
                }
            }
        });
        jPanel5.add(jButton2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel2.add(jPanel6);
        this.recupererFichierXSL(jPanel6, element);
    }

    private void creerPanelFichierXSL(final JPanel jPanel, final Element element, final Element element2, final int n) {
        final JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new TitledBorder(Strings.get("label.FichierXSL")));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        final JTextField jTextField = new JTextField(15);
        jTextField.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EditeurDesExports.this.parcourir(element2, jTextField);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Parcourir")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesExports.this.parcourir(element2, jTextField);
            }
        });
        jPanel4.add(jLabel);
        jPanel4.add(jTextField);
        jPanel4.add(jButton);
        if (element2 != null) {
            jTextField.setText(element2.getAttribute("nom"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurFichierXSL(documentEvent, element, jPanel.getComponentZOrder(jPanel2), jTextField);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurFichierXSL(documentEvent, element, jPanel.getComponentZOrder(jPanel2), jTextField);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurFichierXSL(documentEvent, element, jPanel.getComponentZOrder(jPanel2), jTextField);
            }
        });
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel5);
        JButton jButton2 = new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                Element element2 = EditeurDesExports.this.enregistrerFichierXSL(element, jPanel.getComponentCount(), null);
                EditeurDesExports.this.creerPanelFichierXSL(jPanel, element, element2, jPanel.getComponentCount());
                jPanel.revalidate();
            }
        });
        jPanel5.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jPanel.getComponentCount() > 1) {
                    jPanel.remove(jPanel2);
                    jPanel.revalidate();
                    Element element2 = EditeurDesExports.this.trouverFichierXSL(element, n);
                    if (element2 != null) {
                        element2.getParentNode().removeChild(element2);
                        EditeurFichierConfig.setModif(true);
                    }
                }
            }
        });
        jPanel5.add(jButton3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel3.add(jPanel6);
        this.recupererParametre(jPanel6, element2);
    }

    private void creerPanelParametre(final JPanel jPanel, final Element element, Element element2, final int n) {
        final JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(jPanel3);
        jPanel3.setBorder(new TitledBorder(Strings.get("label.Parametre")));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        JTextField jTextField = new JTextField(15);
        jPanel4.add(jLabel);
        jPanel4.add(jTextField);
        if (element2 != null) {
            jTextField.setText(element2.getAttribute("nom"));
        }
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "nom");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "nom");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "nom");
            }
        });
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel5);
        JLabel jLabel2 = new JLabel(Strings.get("label.valeurParametre"));
        JTextField jTextField2 = new JTextField(15);
        jPanel5.add(jLabel2);
        jPanel5.add(jTextField2);
        if (element2 != null) {
            jTextField2.setText(element2.getAttribute("valeur"));
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "valeur");
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "valeur");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurDesExports.this.ecouteurParametre(documentEvent, element, jPanel.getComponentZOrder(jPanel2), "valeur");
            }
        });
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel6);
        JButton jButton = new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurDesExports.this.creerPanelParametre(jPanel, element, null, jPanel.getComponentCount());
                jPanel.revalidate();
            }
        });
        jPanel6.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jPanel.getComponentCount() > 1) {
                    jPanel.remove(jPanel2);
                    jPanel.revalidate();
                    Element element2 = EditeurDesExports.this.trouverParametre(element, n);
                    if (element2 != null) {
                        element2.getParentNode().removeChild(element2);
                        EditeurFichierConfig.setModif(true);
                    }
                }
            }
        });
        jPanel6.add(jButton2);
    }

    private void parcourir(Element element, JTextField jTextField) {
        File file;
        File file2 = null;
        file2 = !"".equals(element.getAttribute("nom")) ? new File(this.fichierXML.getParentFile(), element.getAttribute("nom")) : this.fichierXML;
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setApproveButtonText("OK");
        if (!"".equals(element.getAttribute("nom"))) {
            jFileChooser.setSelectedFile(file2);
        }
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n > 0 && n < string.length() - 1 && string.substring(n + 1).toLowerCase().equals("xsl");
            }

            public String getDescription() {
                return Strings.get("texte.FichiersXSL");
            }
        });
        if (jFileChooser.showOpenDialog(null) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            URI uRI = null;
            URI uRI2 = null;
            try {
                uRI = new URI(file.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
            try {
                uRI2 = new URI(this.fichierXML.getParentFile().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
            try {
                URI uRI3 = uRI2.relativize(uRI);
                jTextField.setText(uRI3.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(nullPointerException);
            }
        }
    }

    private void ecouteurExport(DocumentEvent documentEvent, int n) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerExport(n, string, null);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurFichierXSL(DocumentEvent documentEvent, Element element, int n, JTextField jTextField) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerFichierXSL(element, n, jTextField.getText());
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurParametre(DocumentEvent documentEvent, Element element, int n, String string) {
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            if ("nom".equals(string)) {
                this.enregistrerParametre(element, n, string2, null);
            }
            if ("valeur".equals(string)) {
                this.enregistrerParametre(element, n, null, string2);
            }
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private Element enregistrerExport(int n, String string, String string2) {
        Element element = this.trouverExport(n);
        if (element == null) {
            element = this.doc.createElement("EXPORT");
            this.exports.appendChild(element);
        }
        if (string != null) {
            element.setAttribute("nom", string);
        }
        if (string2 != null) {
            element.setAttribute("sortie", string2);
        }
        return element;
    }

    private Element trouverExport(int n) {
        if (n == -1) {
            return null;
        }
        if (this.exports == null) {
            return null;
        }
        int n2 = 0;
        for (Node node = this.exports.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private Element enregistrerFichierXSL(Element element, int n, String string) {
        Element element2 = this.trouverFichierXSL(element, n);
        if (element2 == null) {
            element2 = this.doc.createElement("FICHIER_XSL");
            element.appendChild(element2);
        }
        if (string != null) {
            element2.setAttribute("nom", string);
        }
        return element2;
    }

    private Element trouverFichierXSL(Element element, int n) {
        if (n == -1) {
            return null;
        }
        if (element == null) {
            return null;
        }
        int n2 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private Element enregistrerParametre(Element element, int n, String string, String string2) {
        Element element2 = this.trouverParametre(element, n);
        if (element2 == null) {
            element2 = this.doc.createElement("PARAMETRE");
            element.appendChild(element2);
        }
        if (string != null) {
            element2.setAttribute("nom", string);
        }
        if (string2 != null) {
            element2.setAttribute("valeur", string2);
        }
        return element2;
    }

    private Element trouverParametre(Element element, int n) {
        if (n == -1) {
            return null;
        }
        if (element == null) {
            return null;
        }
        int n2 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private void recupererExport() {
        this.listePanelExport.removeAll();
        if (this.exports != null) {
            Element element = Outils.premierEnfantDeNom(this.exports, "EXPORT");
            if (element == null) {
                element = this.enregistrerExport(0, null, null);
            }
            this.creerPanelExport(element, 0);
            int n = this.exports.getChildNodes().getLength();
            for (int i = 1; i < n; ++i) {
                if ((element = Outils.enfantSuivantDeMemeNom(element)) == null) continue;
                this.creerPanelExport(element, i);
            }
        }
    }

    private void recupererFichierXSL(JPanel jPanel, Element element) {
        jPanel.removeAll();
        Element element2 = null;
        if (element != null) {
            element2 = Outils.premierEnfantDeNom(element, "FICHIER_XSL");
            if (element2 == null) {
                element2 = this.enregistrerFichierXSL(element, 0, null);
            }
            this.creerPanelFichierXSL(jPanel, element, element2, 0);
            int n = element.getChildNodes().getLength();
            for (int i = 1; i < n; ++i) {
                if ((element2 = Outils.enfantSuivantDeMemeNom(element2)) == null) continue;
                this.creerPanelFichierXSL(jPanel, element, element2, i);
            }
        }
    }

    private void recupererParametre(JPanel jPanel, Element element) {
        jPanel.removeAll();
        if (element != null) {
            Element element2 = Outils.premierEnfantDeNom(element, "PARAMETRE");
            if (element2 == null) {
                element2 = this.enregistrerParametre(element, 0, null, null);
            }
            this.creerPanelParametre(jPanel, element, element2, 0);
            int n = element.getChildNodes().getLength();
            for (int i = 1; i < n; ++i) {
                if ((element2 = Outils.enfantSuivantDeMemeNom(element2)) == null) continue;
                this.creerPanelParametre(jPanel, element, element2, i);
            }
        }
    }

    private void nettoyerDOM() {
        if (!this.exports.hasChildNodes()) {
            this.racine.removeChild(this.exports);
        } else {
            for (Node node = this.exports.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !"EXPORT".equals(node.getNodeName())) continue;
                if (!((Element)node).hasAttribute("nom") || "".equals(((Element)node).getAttribute("nom"))) {
                    this.exports.removeChild(node);
                    continue;
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element) || !"FICHIER_XSL".equals(node2.getNodeName())) continue;
                    for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        if (!"PARAMETRE".equals(node3.getNodeName()) || ((Element)node3).hasAttribute("nom") && ((Element)node3).hasAttribute("valeur") && !"".equals(((Element)node3).getAttribute("nom")) && !"".equals(((Element)node3).getAttribute("valeur"))) continue;
                        node2.removeChild(node3);
                    }
                }
            }
        }
    }
}

