/*
 * Decompiled with CFR 0.152.
 */
package xpages;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartePalette {
    ArrayList<Integer>[][][] cube;
    int[] palette;
    int indtrans;
    int dim;

    public CartePalette(int[] nArray, int n, int n2) {
        this.palette = nArray;
        this.indtrans = n;
        this.dim = n2;
        this.cube = new ArrayList[n2][n2][n2];
        this.remplirCube();
    }

    protected void remplirCube() {
        double d = 3.0 * (256.0 / (double)this.dim) * (256.0 / (double)this.dim);
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                for (int k = 0; k < this.dim; ++k) {
                    int n = (i * 255 + 128) / this.dim;
                    int n2 = (j * 255 + 128) / this.dim;
                    int n3 = (k * 255 + 128) / this.dim;
                    this.cube[i][j][k] = this.rechercheIndex(n, n2, n3, d);
                }
            }
        }
    }

    protected ArrayList<Integer> rechercheIndex(int n, int n2, int n3, double d) {
        int n4;
        ArrayList<Integer> arrayList = null;
        int n5 = -1;
        long l = 0L;
        for (n4 = 0; n4 < this.palette.length; ++n4) {
            if (n4 == this.indtrans) continue;
            int n6 = this.palette[n4];
            int n7 = (n6 >> 16 & 0xFF) - n;
            int n8 = (n6 >> 8 & 0xFF) - n2;
            int n9 = (n6 & 0xFF) - n3;
            long l2 = n7 * n7 + n8 * n8 + n9 * n9;
            if (n5 == -1 || l2 < l) {
                n5 = n4;
                l = l2;
            }
            if (!((double)l2 < d)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new Integer(n4));
        }
        if (arrayList == null) {
            arrayList = new ArrayList<Integer>();
        }
        n4 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((Integer)arrayList.get(i) != n5) continue;
            n4 = 1;
        }
        if (n4 == 0) {
            arrayList.add(new Integer(n5));
        }
        return arrayList;
    }

    public int index(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        ArrayList<Integer> arrayList = this.cube[(int)((double)n2 * ((double)this.dim - 0.1) / 255.0)][(int)((double)n3 * ((double)this.dim - 0.1) / 255.0)][(int)((double)n4 * ((double)this.dim - 0.1) / 255.0)];
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        int n5 = -1;
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n6 = this.palette[arrayList.get(i)];
            int n7 = (n6 >> 16 & 0xFF) - n2;
            int n8 = (n6 >> 8 & 0xFF) - n3;
            int n9 = (n6 & 0xFF) - n4;
            long l2 = n7 * n7 + n8 * n8 + n9 * n9;
            if (n5 != -1 && l2 >= l) continue;
            n5 = i;
            l = l2;
        }
        return arrayList.get(n5);
    }
}

