/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.player.AboutFrame;
import com.fluendo.player.Configure;
import com.fluendo.player.CortadoPipeline;
import com.fluendo.player.Status;
import com.fluendo.player.StatusListener;
import com.fluendo.utils.Debug;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Hashtable;

public class Cortado
extends Applet
implements Runnable,
MouseMotionListener,
MouseListener,
ComponentListener,
BusHandler,
StatusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private Cortado cortado;
    private CortadoPipeline pipeline;
    private String urlString;
    private boolean audio;
    private boolean video;
    private int kateIndex;
    private boolean showSpeaker;
    private boolean keepAspect;
    private boolean ignoreAspect;
    private boolean autoPlay;
    private int bufferSize;
    private String userId;
    private String password;
    private int bufferLow;
    private int bufferHigh;
    private int debug;
    private double durationParam;
    private boolean statusRunning;
    private Thread statusThread;
    public Status status;
    private int statusHeight = 20;
    private boolean inStatus;
    private boolean isBuffering;
    private int desiredState;
    private boolean started = false;
    private boolean isEOS;
    private boolean isError;
    private static final String[] autoBoolVals = new String[]{"auto", "true", "false"};
    private static final int BOOL_AUTO = 0;
    private static final int BOOL_TRUE = 1;
    private static final int BOOL_FALSE = 2;
    private int seekable;
    private int live;
    private int showStatus;
    private static final String[] showStatusVals = new String[]{"auto", "show", "hide"};
    public static final int STATUS_AUTO = 0;
    public static final int STATUS_SHOW = 1;
    public static final int STATUS_HIDE = 2;
    private int hideTimeout;
    private int hideCounter;
    private boolean mayHide;
    public double currentTime = 0.0;
    private double _currentTime;
    public double duration = -1.0;
    public boolean paused;
    public String src;
    private PopupMenu menu;
    private Hashtable params = new Hashtable();
    private Configure configure;
    private Dimension appletDimension;

    public String getAppletInfo() {
        return "Title: Fluendo media player \nAuthor: Wim Taymans \nA Java based network multimedia player.";
    }

    public String getRevision() {
        return "$Revision: 4170 $";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"url", "URL", "The media file to play"}, {"seekable", "enum", "Can you seek in this file (auto|true|false) (default auto)"}, {"live", "enum", "Is this a live stream (disabled PAUSE) (auto|true|false) (default auto)"}, {"duration", "float", "Total duration of the file in seconds (default unknown)"}, {"audio", "boolean", "Enable audio playback (default true)"}, {"video", "boolean", "Enable video playback (default true)"}, {"kateIndex", "boolean", "Enable playback of a particular Kate stream (default -1 (none))"}, {"statusHeight", "int", "The height of the status area (default 12)"}, {"autoPlay", "boolean", "Automatically start playback (default true)"}, {"showStatus", "enum", "Show status area (auto|show|hide) (default auto)"}, {"hideTimeout", "int", "Timeout in seconds to hide the status area when showStatus is auto (default 0)"}, {"showSpeaker", "boolean", "Show a speaker icon when audio is available (default true)"}, {"keepAspect", "boolean", "Use aspect ratio of video (default true)"}, {"ignoreAspect", "boolean", "Ignore the aspect ratio as signalled by the video, always assume square pixels (default false)"}, {"bufferSize", "int", "The size of the prebuffer in Kbytes (default 100)"}, {"bufferLow", "int", "Percent of empty buffer (default 10)"}, {"bufferHigh", "int", "Percent of full buffer (default 70)"}, {"userId", "string", "userId for basic authentication (default null)"}, {"password", "string", "password for basic authentication (default null)"}, {"debug", "int", "Debug level 0 - 4 (default = 3)"}};
        return stringArray;
    }

    public void setParam(String string, String string2) {
        this.params.put(string, string2);
    }

    public void restart() {
        this.stop();
        this.init();
        this.start();
    }

    public String getParam(String string, String string2) {
        String string3 = (String)this.params.get(string);
        if (string3 == null) {
            try {
                string3 = this.getParameter(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public int getEnumParam(String string, String[] stringArray, String string2) {
        int n = -1;
        String string3 = this.getParam(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string3)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            Debug.info("param \"" + string + "\" has enum value \"" + n + "\" (" + stringArray[n] + ")");
        } else {
            Debug.info("param \"" + string + "\" has invalid enum value");
        }
        return n;
    }

    public String getStringParam(String string, String string2) {
        String string3 = this.getParam(string, string2);
        Debug.info("param \"" + string + "\" has string value \"" + string3 + "\"");
        return string3;
    }

    public boolean getBoolParam(String string, boolean bl) {
        String string2 = bl ? "true" : "false";
        String string3 = String.valueOf(this.getParam(string, string2));
        boolean bl2 = string3.equals("true");
        Debug.info("param \"" + string + "\" has boolean value \"" + (bl2 |= string3.equals("1")) + "\"");
        return bl2;
    }

    public double getDoubleParam(String string, double d) {
        double d2 = Double.valueOf(this.getParam(string, "" + d));
        Debug.info("param \"" + string + "\" has double value \"" + d2 + "\"");
        return d2;
    }

    public int getIntParam(String string, int n) {
        int n2 = Integer.valueOf(this.getParam(string, "" + n));
        Debug.info("param \"" + string + "\" has int value \"" + n2 + "\"");
        return n2;
    }

    public void shutDown(Throwable throwable) {
        Debug.log(3, "shutting down: reason: " + throwable.getMessage());
        throwable.printStackTrace();
        this.stop();
    }

    public synchronized void init() {
        URL uRL;
        this.cortado = this;
        Debug.info("init()");
        if (this.pipeline != null) {
            this.stop();
        }
        this.pipeline = new CortadoPipeline(this);
        this.configure = new Configure();
        this.src = this.urlString = this.getStringParam("url", null);
        this.seekable = this.getEnumParam("seekable", autoBoolVals, "auto");
        this.live = this.getEnumParam("live", autoBoolVals, "auto");
        this.durationParam = this.getDoubleParam("duration", -1.0);
        this.audio = this.getBoolParam("audio", true);
        this.video = this.getBoolParam("video", true);
        this.kateIndex = this.getIntParam("kateIndex", -1);
        this.statusHeight = this.getIntParam("statusHeight", 12);
        this.autoPlay = this.getBoolParam("autoPlay", true);
        this.showStatus = this.getEnumParam("showStatus", showStatusVals, "auto");
        this.hideTimeout = this.getIntParam("hideTimeout", 3);
        this.showSpeaker = this.getBoolParam("showSpeaker", true);
        this.keepAspect = this.getBoolParam("keepAspect", true);
        this.ignoreAspect = this.getBoolParam("ignoreAspect", false);
        this.bufferSize = this.getIntParam("bufferSize", 200);
        this.bufferLow = this.getIntParam("bufferLow", 10);
        this.bufferHigh = this.getIntParam("bufferHigh", 70);
        this.debug = this.getIntParam("debug", 3);
        this.userId = this.getStringParam("userId", null);
        this.password = this.getStringParam("password", null);
        if (!this.video) {
            this.hideTimeout = Integer.MAX_VALUE;
        }
        Debug.level = this.debug;
        Debug.log(3, "build info: " + this.configure.buildInfo);
        Debug.log(3, "revision: " + this.getRevision());
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            Debug.log(2, "Found MS JVM, disable seeking.");
            this.seekable = 2;
        }
        this.pipeline.setUrl(this.urlString);
        this.pipeline.setUserId(this.userId);
        this.pipeline.setPassword(this.password);
        this.pipeline.enableAudio(this.audio);
        this.pipeline.enableVideo(this.video);
        this.pipeline.setIgnoreAspect(this.ignoreAspect);
        this.pipeline.enableKateIndex(this.kateIndex);
        this.pipeline.setBufferSize(this.bufferSize);
        this.pipeline.setBufferLow(this.bufferLow);
        this.pipeline.setBufferHigh(this.bufferHigh);
        try {
            uRL = this.getDocumentBase();
            Debug.log(3, "Document base: " + uRL);
        }
        catch (Throwable throwable) {
            uRL = null;
        }
        this.pipeline.setDocumentBase(uRL);
        this.pipeline.setComponent(this);
        this.pipeline.getBus().addHandler(this);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.status = new Status(this);
        this.status.setShowSpeaker(this.showSpeaker);
        this.status.setHaveAudio(this.audio);
        this.status.setHavePercent(true);
        if (this.live == 2) {
            this.status.setLive(false);
        } else {
            this.status.setLive(true);
        }
        if (this.seekable == 1) {
            this.status.setSeekable(true);
        } else {
            this.status.setSeekable(false);
        }
        this.status.setDuration(this.durationParam);
        this.inStatus = false;
        this.mayHide = this.hideTimeout == 0;
        this.hideCounter = 0;
        if (this.showStatus != 2) {
            this.status.setVisible(true);
        } else {
            this.status.setVisible(false);
        }
        this.menu = new PopupMenu();
        this.menu.add("About...");
        this.menu.addActionListener(this);
        this.add(this.menu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("About...")) {
            AboutFrame aboutFrame = new AboutFrame(this.pipeline);
            aboutFrame.d.setVisible(true);
        }
    }

    public Graphics getGraphics() {
        Dimension dimension = this.getSize();
        Graphics graphics = super.getGraphics();
        if (this.status != null && this.status.isVisible()) {
            graphics.setClip(0, 0, dimension.width, dimension.height - this.statusHeight);
        } else {
            graphics.setClip(0, 0, dimension.width, dimension.height);
        }
        return graphics;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.appletDimension = super.getSize();
        if (this.pipeline != null) {
            this.pipeline.resize(this.appletDimension);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.appletDimension = super.getSize();
        Debug.debug("Component shown, size = " + this.appletDimension);
        if (this.pipeline != null) {
            this.pipeline.resize(this.appletDimension);
        }
    }

    public Dimension getSize() {
        if (this.appletDimension == null) {
            this.appletDimension = super.getSize();
        }
        return this.appletDimension;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            this.shutDown(throwable);
        }
    }

    private void realRun() {
        Debug.log(3, "entering status thread");
        while (this.statusRunning) {
            try {
                if (this._currentTime != this.currentTime && this.currentTime >= 0.0 && this.duration > this.currentTime) {
                    this.doSeek(this.currentTime / this.duration);
                }
                this.currentTime = this._currentTime = (double)this.pipeline.getPosition() / 1000000.0;
                long l = this.pipeline.getPosition() / 1000000L;
                this.status.setTime(l);
                Thread.sleep(1000L);
                if (this.hideCounter > 0) {
                    --this.hideCounter;
                    if (this.hideCounter == 0) {
                        this.mayHide = true;
                        this.setStatusVisible(false, false);
                    }
                }
                this.pipeline.enableKateIndex(Integer.valueOf(this.getParam("kateIndex", "-1")));
            }
            catch (Exception exception) {
                if (!this.statusRunning) continue;
                Debug.log(1, "Exception in status thread:");
                exception.printStackTrace();
            }
        }
        Debug.log(3, "exit status thread");
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n <= 0 || n2 < this.statusHeight) {
            this.appletDimension = null;
            Debug.log(2, "paint aborted: appletDimension wrong; dwidth " + n + ", dheight " + n2 + ", statusHeight " + this.statusHeight);
            return;
        }
        if (this.status != null && this.status.isVisible()) {
            this.status.setBounds(0, n2 - this.statusHeight, n, this.statusHeight);
            this.status.paint(graphics);
        }
    }

    private void setStatusVisible(boolean bl, boolean bl2) {
        if (this.status.isVisible() == bl) {
            return;
        }
        if (!bl && !this.mayHide) {
            return;
        }
        if (!bl2) {
            if (this.showStatus == 1 && !bl) {
                return;
            }
            if (this.showStatus == 2 && bl) {
                return;
            }
        }
        if (this.isError && !bl) {
            return;
        }
        if (this.inStatus && !bl) {
            bl = true;
        }
        if (bl != this.status.isVisible()) {
            Debug.log(3, "Status: " + (bl ? "Show" : "Hide"));
        }
        if (bl) {
            this.hideCounter = this.hideTimeout;
        }
        this.status.setVisible(bl);
        this.repaint();
    }

    private boolean intersectStatus(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3 = mouseEvent.getY();
        this.inStatus = n3 > (n2 = (n = this.getSize().height) - this.statusHeight) && n3 < n;
        return this.inStatus;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.inStatus = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            mouseEvent.translatePoint(0, -n);
            this.status.mousePressed(mouseEvent);
        } else if ((mouseEvent.getModifiers() & 4) == 4) {
            this.menu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            mouseEvent.translatePoint(0, -n);
            this.status.mouseReleased(mouseEvent);
        } else {
            this.status.cancelMouseOperation();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            mouseEvent.translatePoint(0, -n);
            this.status.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            mouseEvent.translatePoint(0, -n);
            this.status.mouseMoved(mouseEvent);
        }
        this.setStatusVisible(true, false);
    }

    public void handleMessage(Message message) {
        switch (message.getType()) {
            case 4: {
                Debug.info(message.toString());
                break;
            }
            case 2: {
                Debug.info(message.toString());
                if (this.isError) break;
                this.status.setMessage(message.parseErrorString());
                this.status.setState(0);
                this.pipeline.setState(1);
                this.setStatusVisible(true, true);
                this.isError = true;
                break;
            }
            case 1: {
                Debug.log(3, "EOS: playback ended");
                if (this.isError) break;
                this.status.setState(0);
                this.status.setMessage("Playback ended");
                this.isEOS = true;
                this.pipeline.setState(1);
                this.setStatusVisible(true, false);
                break;
            }
            case 8192: {
                Debug.info(message.toString());
                break;
            }
            case 524288: {
                if (this.isError) break;
                this.status.setMessage(message.parseResourceString());
                this.setStatusVisible(true, false);
                break;
            }
            case 262144: {
                long l = message.parseDurationValue();
                this.status.setByteDuration(l);
                Debug.log(4, "got duration: " + l);
                if (l == -1L) break;
                if (this.seekable == 0) {
                    this.status.setSeekable(true);
                }
                if (this.live != 0) break;
                this.status.setLive(false);
                break;
            }
            case 32: {
                if (this.isError) break;
                boolean bl = message.parseBufferingBusy();
                int n = message.parseBufferingPercent();
                if (bl) {
                    if (!this.isBuffering) {
                        Debug.log(3, "PAUSE: we are buffering");
                        if (this.desiredState == 3) {
                            this.pipeline.setState(2);
                        }
                        this.isBuffering = true;
                        this.setStatusVisible(true, false);
                    }
                    this.status.setBufferPercent(bl, n);
                    break;
                }
                if (this.isBuffering) {
                    Debug.log(3, "PLAY: we finished buffering");
                    if (this.desiredState == 3) {
                        this.pipeline.setState(3);
                    }
                    this.isBuffering = false;
                    this.setStatusVisible(false, false);
                }
                this.status.setBufferPercent(bl, n);
                break;
            }
            case 64: {
                if (message.getSrc() != this.pipeline) break;
                int n = message.parseStateChangedOld();
                int n2 = message.parseStateChangedNext();
                switch (n2) {
                    case 2: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Paused");
                        }
                        this.status.setState(1);
                        break;
                    }
                    case 3: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Playing");
                            this.setStatusVisible(false, false);
                            if (!this.mayHide) {
                                this.hideCounter = this.hideTimeout;
                            }
                        }
                        this.status.setState(2);
                        break;
                    }
                    case 1: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Stopped");
                            this.setStatusVisible(true, false);
                        }
                        this.status.setState(0);
                    }
                }
                break;
            }
            case 0x100000: {
                this.status.setBytePosition(message.parseBytePosition());
                break;
            }
        }
    }

    public void doPause() {
        this.isError = false;
        this.isEOS = false;
        this.paused = true;
        this.status.setMessage("Pause");
        this.desiredState = 2;
        this.pipeline.setState(this.desiredState);
    }

    public void doPlay() {
        this.isError = false;
        this.isEOS = false;
        this.paused = false;
        this.status.setMessage("Play");
        this.desiredState = 3;
        this.pipeline.setState(this.desiredState);
    }

    public void doStop() {
        this.status.setMessage("Stop");
        this.desiredState = 1;
        this.pipeline.setState(this.desiredState);
    }

    public void doSeek(double d) {
        Event event = Event.newSeek(5, (int)(d * 100.0 * 10000.0));
        boolean bl = this.pipeline.sendEvent(event);
        if (!bl) {
            Debug.log(2, "seek failed");
        }
    }

    public double getPlayPosition() {
        return (double)this.pipeline.getPosition() / 1000000.0;
    }

    public void newState(int n) {
        switch (n) {
            case 1: {
                this.doPause();
                break;
            }
            case 2: {
                this.doPlay();
                break;
            }
            case 0: {
                this.doStop();
                break;
            }
        }
    }

    public void newSeek(double d) {
        this.doSeek(d);
    }

    public synchronized void start() {
        Debug.info("Application starting");
        if (this.pipeline == null) {
            this.init();
        }
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.status.addStatusListener(this);
        this.desiredState = this.autoPlay ? 3 : 2;
        int n = this.pipeline.setState(this.desiredState);
        if (this.statusThread != null) {
            throw new RuntimeException("invalid state");
        }
        this.statusThread = new Thread((Runnable)this, "cortado-StatusThread-" + Debug.genId());
        this.statusRunning = true;
        this.statusThread.start();
    }

    public synchronized void stop() {
        Debug.info("Application stopping...");
        this.status.removeStatusListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.removeComponentListener(this);
        this.statusRunning = false;
        this.desiredState = 1;
        if (this.pipeline != null) {
            try {
                this.pipeline.setState(this.desiredState);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pipeline.shutDown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pipeline = null;
        }
        if (this.statusThread != null) {
            try {
                this.statusThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.statusThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.statusThread = null;
        }
        Debug.info("Application stopped");
    }

    public int getStatusHeight() {
        return this.statusHeight;
    }

    public int getShowStatus() {
        return this.showStatus;
    }

    public synchronized void play() {
        this.doPlay();
    }

    public synchronized void pause() {
        this.doPause();
    }
}

