/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.fluendo.utils.MemUtils;

public final class Filter {
    private static final byte[] LoopFilterLimitValuesV1 = new byte[]{30, 25, 20, 20, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] LoopFilterLimits = new byte[64];
    private int[] FiltBoundingValue = new int[512];

    private void SetupBoundingValueArray_Generic(int n) {
        MemUtils.set(this.FiltBoundingValue, 0, 0, 512);
        for (int i = 0; i < n; ++i) {
            this.FiltBoundingValue[256 - i - n] = -n + i;
            this.FiltBoundingValue[256 - i] = -i;
            this.FiltBoundingValue[256 + i] = i;
            this.FiltBoundingValue[256 + i + n] = n - i;
        }
    }

    public void copyFilterTables(Info info) {
        System.arraycopy(info.LoopFilterLimitValues, 0, this.LoopFilterLimits, 0, 64);
    }

    public void InitFilterTables() {
        System.arraycopy(LoopFilterLimitValuesV1, 0, this.LoopFilterLimits, 0, 64);
    }

    public void SetupLoopFilter(int n) {
        byte by = this.LoopFilterLimits[n];
        this.SetupBoundingValueArray_Generic(by);
    }

    private static final short clamp255(int n) {
        n -= 255;
        n = -(255 + (n >> 31 & n));
        return (short)(-(n >> 31 & n));
    }

    private void FilterHoriz(short[] sArray, int n, int n2, int[] nArray) {
        for (int i = 0; i < 8; ++i) {
            int n3 = sArray[0 + n] - sArray[1 + n] * 3 + sArray[2 + n] * 3 - sArray[3 + n];
            n3 = nArray[256 + (n3 + 4 >> 3)];
            sArray[1 + n] = Filter.clamp255(sArray[1 + n] + n3);
            sArray[2 + n] = Filter.clamp255(sArray[2 + n] - n3);
            n += n2;
        }
    }

    private void FilterVert(short[] sArray, int n, int n2, int[] nArray) {
        n -= 2 * n2;
        for (int i = 0; i < 8; ++i) {
            int n3 = sArray[n + 0] - sArray[n + n2] * 3 + sArray[n + 2 * n2] * 3 - sArray[n + 3 * n2];
            n3 = nArray[256 + (n3 + 4 >> 3)];
            sArray[n + n2] = Filter.clamp255(sArray[n + n2] + n3);
            sArray[n + 2 * n2] = Filter.clamp255(sArray[n + 2 * n2] - n3);
            ++n;
        }
    }

    public void LoopFilter(Playback playback) {
        int n = playback.HFragments;
        int n2 = playback.VFragments;
        int n3 = playback.frameQIS[0];
        byte by = this.LoopFilterLimits[n3];
        if (by == 0) {
            return;
        }
        this.SetupBoundingValueArray_Generic(by);
        for (int i = 0; i < 3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            switch (i) {
                case 0: {
                    n8 = 0;
                    n = playback.HFragments;
                    n2 = playback.VFragments;
                    n7 = playback.YStride;
                    n6 = playback.HFragments;
                    break;
                }
                case 1: {
                    n8 = playback.YPlaneFragments;
                    n = playback.HFragments >> 1;
                    n2 = playback.VFragments >> 1;
                    n7 = playback.UVStride;
                    n6 = playback.HFragments / 2;
                    break;
                }
                default: {
                    n8 = playback.YPlaneFragments + playback.UVPlaneFragments;
                    n = playback.HFragments >> 1;
                    n2 = playback.VFragments >> 1;
                    n7 = playback.UVStride;
                    n6 = playback.HFragments / 2;
                }
            }
            int n9 = n8;
            if (playback.display_fragments[n9] != 0) {
                if (playback.display_fragments[n9 + 1] == 0) {
                    this.FilterHoriz(playback.LastFrameRecon, playback.recon_pixel_index_table[n9] + 6, n7, this.FiltBoundingValue);
                }
                if (playback.display_fragments[n9 + n6] == 0) {
                    this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                }
            }
            ++n9;
            for (n5 = 1; n5 < n - 1; ++n5) {
                if (playback.display_fragments[n9] != 0) {
                    n4 = playback.recon_pixel_index_table[n9];
                    this.FilterHoriz(playback.LastFrameRecon, n4 - 2, n7, this.FiltBoundingValue);
                    if (playback.display_fragments[n9 + 1] == 0) {
                        this.FilterHoriz(playback.LastFrameRecon, n4 + 6, n7, this.FiltBoundingValue);
                    }
                    if (playback.display_fragments[n9 + n6] == 0) {
                        this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                    }
                }
                ++n9;
            }
            if (playback.display_fragments[n9] != 0) {
                this.FilterHoriz(playback.LastFrameRecon, playback.recon_pixel_index_table[n9] - 2, n7, this.FiltBoundingValue);
                if (playback.display_fragments[n9 + n6] == 0) {
                    this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                }
            }
            ++n9;
            for (int j = 1; j < n2 - 1; ++j) {
                if (playback.display_fragments[n9] != 0) {
                    n4 = playback.recon_pixel_index_table[n9];
                    this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
                    if (playback.display_fragments[n9 + 1] == 0) {
                        this.FilterHoriz(playback.LastFrameRecon, n4 + 6, n7, this.FiltBoundingValue);
                    }
                    if (playback.display_fragments[n9 + n6] == 0) {
                        this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                    }
                }
                ++n9;
                n5 = 1;
                while (n5 < n - 1) {
                    if (playback.display_fragments[n9] != 0) {
                        n4 = playback.recon_pixel_index_table[n9];
                        this.FilterHoriz(playback.LastFrameRecon, n4 - 2, n7, this.FiltBoundingValue);
                        this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
                        if (playback.display_fragments[n9 + 1] == 0) {
                            this.FilterHoriz(playback.LastFrameRecon, n4 + 6, n7, this.FiltBoundingValue);
                        }
                        if (playback.display_fragments[n9 + n6] == 0) {
                            this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                        }
                    }
                    ++n5;
                    ++n9;
                }
                if (playback.display_fragments[n9] != 0) {
                    n4 = playback.recon_pixel_index_table[n9];
                    this.FilterHoriz(playback.LastFrameRecon, n4 - 2, n7, this.FiltBoundingValue);
                    this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
                    if (playback.display_fragments[n9 + n6] == 0) {
                        this.FilterVert(playback.LastFrameRecon, playback.recon_pixel_index_table[n9 + n6], n7, this.FiltBoundingValue);
                    }
                }
                ++n9;
            }
            if (playback.display_fragments[n9] != 0) {
                n4 = playback.recon_pixel_index_table[n9];
                this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
                if (playback.display_fragments[n9 + 1] == 0) {
                    this.FilterHoriz(playback.LastFrameRecon, n4 + 6, n7, this.FiltBoundingValue);
                }
            }
            ++n9;
            n5 = 1;
            while (n5 < n - 1) {
                if (playback.display_fragments[n9] != 0) {
                    n4 = playback.recon_pixel_index_table[n9];
                    this.FilterHoriz(playback.LastFrameRecon, n4 - 2, n7, this.FiltBoundingValue);
                    this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
                    if (playback.display_fragments[n9 + 1] == 0) {
                        this.FilterHoriz(playback.LastFrameRecon, n4 + 6, n7, this.FiltBoundingValue);
                    }
                }
                ++n5;
                ++n9;
            }
            if (playback.display_fragments[n9] == 0) continue;
            n4 = playback.recon_pixel_index_table[n9];
            this.FilterHoriz(playback.LastFrameRecon, n4 - 2, n7, this.FiltBoundingValue);
            this.FilterVert(playback.LastFrameRecon, n4, n7, this.FiltBoundingValue);
        }
    }
}

