<?php

// renvoie une image PNG pour un texte d'equation TeX

// requiert :
// - un systeme UNIX (dont Linux et MacOS X)
// - latex
// - dvipng : http://sourceforge.net/projects/dvipng/
// (qui requiert libgd, kpathsea, FreeType 2, T1lib, libpng, libz)
// - ImageMagick : http://www.imagemagick.org/
// - le script bash tex2png dans le meme dossier que tex.php

//
// Serveur d'images TeX developpe pour SPIP par
// Philippe Riviere <fil@rezo.net>
// et Benjamin Sonntag <benjamin@sonntag.fr>
// Distribue sous licence GNU/GPL
//  2004 - v0.2
// modifie par Damien pour WebJaxe et XPAGES
//

$chemin_tex2png = "./tex2png";
$chemin_convert = "/usr/bin/convert";

// Cache du serveur
$cache_dir = "CACHE/spiTeX";
if (!is_dir($cache_dir))
	mkdir ($cache_dir);


// Supprimer les codes dangereux pour TeX ;
// extrait de http://www.mayer.dial.pipex.com/tex.htm
function math_ignore_dangerous($texte) {
	$danger = "include|def|command|loop|repeat|open|toks|".
	"output|input|catcode|name|\^\^|every|errhelp|".	
	"errorstopmode|scrollmode|nonstopmode|batchmode|read|".
	"write|csname|newhelp|uppercase|lowercase|relax|".
	"aftergroup|afterassignment|expandafter|noexpand|".
	"special";

	if (ereg("($danger)",$texte,$regs))
	return "\\textrm{\color{red}Don't ``$regs[1]'' me.}";

	return $texte;
}

function math_enhance($tex) {
	// Correction pour forcer la ligne de base
	$tex = "\\setbox1=\\hbox{\$\\displaystyle ".$tex."\$}\n"
		."\\newdimen\\haut\n\\newdimen\prof\n"
		."\\haut=\\ht1\n\\prof=\\dp1\n"
		."\\ifdim\\haut>\\prof\\prof=\\haut\\else\\haut=\\prof\\fi\n"
		."\\advance\haut by .5em\n"
		."\\color{white}\\vrule height \\haut depth \\prof width 0.1pt\\color{black}\\hskip 1pt\\box1";
//		."\\color{white}\\vrule height \\haut depth \\prof width 0.1pt\\color{black}\\box1";
	return $tex;
}

function math_($texte) {
	// Options de tex2im
	// http://www.nought.de/tex2im.php
	
	// -z = fond transparent ; -r = resolution
//	$options = "-r 90x90";
//
//	global $cache_dir;
//
//	$fichier = "$cache_dir/".md5(trim($texte)).'.png';
//
//	if (!file_exists($fichier) OR (filemtime($fichier)<filemtime("spitex.php"))) {
//		$texte = math_ignore_dangerous($texte);
//		$texte = escapeshellarg(math_enhance($texte));
//		$cmd = "/usr/local/bin/tex2im $options -o $fichier $texte";
//		exec($cmd);
//	}

	$options = "-r 100";

	global $chemin_tex2png, $chemin_convert, $cache_dir;

	$fichier = "$cache_dir/".md5(trim($texte)).'.png';
	$fichiertmp = "$cache_dir/".md5(trim($texte)).'_.png';

	if (!file_exists($fichier) OR (filemtime($fichier)<filemtime("spitex.php"))) {
		$texte = math_ignore_dangerous($texte);
		$texte = escapeshellarg(math_enhance($texte));
		exec($chemin_tex2png." $options -o $fichiertmp $texte");
		exec($chemin_convert." -chop 1x0 $fichiertmp $fichier");
		unlink($fichiertmp);
	}

	return $fichier;
}

// Retourner l'image demandee
header("Content-Type: image/png");
readfile(math_(urldecode($_SERVER['QUERY_STRING'])));

?>
