<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// affiche la page de modification d'une contribution, à partir de son id
function page_renommer_contribution($lien_bdd,$id_contribution) {
    
    //to be modified by $lien_bdd
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_profile = verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    if($id_profile == false)
		erreur(PAS_AUTORISE);
    
    debut_html(RENOMMER_CONTRIBUTION, RENOMMER_CONTRIBUTION);
    
    $jeton = getJeton();
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" class="texte" name="id_contribution" value="'.$id_contribution.'">'."\n";
    echo '<input type="hidden" name="action" value="renommer_contribution">'."\n";
    echo '<p>'.NOM_CONTRIBUTION.' <input type="text" class="texte" name="nom" value="'.$nom_contribution.'" size="40" maxlength="40"></p>'."\n";
    echo "<p>\n";
    echo '<input type="reset">'."\n";
    echo '<input type="submit">'."\n";
    echo "</p>\n";
    echo "</form>\n";
    
    echo '<p><a href="index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" target="_parent">'.RETOUR."</a></p>\n";
    
    fin_html();
}

// Change le nom d'une contribution à partir d'une requête POST
function action_renommer_contribution($lien_bdd) {
    
    if (!isset($_POST['id_contribution']) || !isset($_POST['nom']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_POST['id_contribution'];
    verifie_id($id_contribution);
    $nom = $_POST['nom'];
    
    if (contribution_existe($lien_bdd,$nom))
        erreur(CONTRIB_MEME_NOM);
    renommage_contribution($lien_bdd,$id_contribution, $nom);
    page_edition_contribution($lien_bdd,$id_contribution);
}

?>
