<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// recherche par mot clé dans une contribution
function page_rechercher($lien_bdd,$id_proj=false, $resultat='') {
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    debut_html(RECHERCHE, RECHERCHE, "document.formulaire.mot.focus()", $id_proj);
    
    $jeton = getJeton();
    echo '<form name="formulaire" method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<p><input type="hidden" name="action" value="rechercher">'."</p>\n";
    if (isset($_POST['mot']))
        $valeur = $_POST['mot'];
    else
        $valeur = '';
    echo '<p><input type="text" class="texte" name="mot" value="'.$valeur.'" size="30" maxlength="30">'."\n";
    echo PROJET.': ';
    echo '<select name="id_projet">';
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur);
    if ($id_proj != false)
        $id_projet_selectionne = $id_proj;
    else if (isset($_POST['id_projet']))
        $id_projet_selectionne = $_POST['id_projet'];
    else
        $id_projet_selectionne = false;
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id_projet = $liste_projets[$i]['id'];
            $titre_projet = $liste_projets[$i]['titre'];
            echo '<option value="'.$id_projet.'"';
            if ($id_projet == $id_projet_selectionne)
                echo ' selected';
            echo '>'.$titre_projet.'</option>';
        }
    }
    echo '</select> ';
    echo "</p>\n";
    echo "<p>\n";
    echo '<input type="reset" value="'.REINITIALISER.'">'."\n";
    echo '<input type="submit" value="'.RECHERCHE.'">'."\n";
    echo "</p>\n";
    echo "</form>\n";
    if ($resultat != '')
        echo $resultat;
        
    fin_html();
}

// recherche un mot clé dans les contributions à partir d'une requête POST
function action_rechercher($lien_bdd) {
    if (!isset($_POST['mot']) || !isset($_POST['id_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $mot = $_POST['mot'];
    $mot = htmlspecialchars($mot);
    $id_projet = $_POST['id_projet'];
    
    if ($mot == "") {
        $mot_manquant = '<p class="erreur">'.MOT_MANQUANT.'</p>';
        page_rechercher($lien_bdd,$id_projet, $mot_manquant);
    }
    else
        rechercher($lien_bdd,$mot, $id_projet);
}

function rechercher($lien_bdd,$mot, $id_projet) {
    $resultat = '';
    $nbre = 0;
    $liste_contributions = liste_des_contributions_projet_et_sous_projets($lien_bdd,$id_projet);
    
    if ($liste_contributions != FALSE) {
        for ($i=0; $i<count($liste_contributions); $i++) {
            $contribution = $liste_contributions[$i];
            $id_contribution = $contribution['id'];
            $nom_contribution = $contribution['nom'];
            $fichier_xml = "../../contribXML/".$nom_contribution."/".$nom_contribution.".xml";
            
            if (file_exists($fichier_xml)) {
                $existe = FALSE;
                $fp = fopen($fichier_xml, 'r');
                $ligne = fgets($fp, 230);
                preg_match('/encoding=["\']([^"\']+)["\']/', $ligne, $enc);
                $encoding = $enc[1];
                rewind($fp);
                while (!feof($fp) && !$existe) {
                    $ligne = fgets($fp, 230);
                    /*$pos = strrpos($ligne, " ");
                    $ligne = substr($ligne, 0, $pos);*/
                    
                    if (strcasecmp($encoding,"ISO-8859-1") == 0)
                        $ligne = utf8_encode($ligne);
                    else
                        $ligne = mb_convert_encoding($ligne, "UTF-8", $encoding);
                    
                    $ligne = htmlspecialchars($ligne);
                    if (stripos($ligne, $mot) !== FALSE || stripos($nom_contribution, $mot) !== FALSE) {
                        $existe = TRUE;
                        $nbre++;
                    }
                    if ($existe) {
                        $nom_contribution = preg_replace('.(' . preg_quote($mot) . ').i', '<span class="colorer">\1</span>', $nom_contribution);
                        $ligne = preg_replace('.(' . preg_quote($mot) . ').i', '<span class="colorer">\1</span>', $ligne);
                        $resultat .= "<div class=\"source\">\n";
                        $resultat .= "<a href=\"index.php?page=edition_contribution&amp;id_contribution=$id_contribution\" target=\"_blank\">$nom_contribution</a><br>";
                        $resultat .= "$ligne ...<br><br><br><br></div>";
                    }
                }
                fclose($fp);
            }
        }
    }
    if ($nbre == 0) {
        $nombre_contrib = '';
        $resultat .= '<p class="erreur">'.AUCUN_RESULTAT.'</p>';
    }
    
    else
        $nombre_contrib = '<p class="resultat">'.CONTRIB_TROUVEE.': '.$nbre.'</p><br><br><br>';
    page_rechercher($lien_bdd,$id_projet, $nombre_contrib.$resultat);
}

?>
