<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page listant les contributions de l'utilisateur
// nécessite tete_pied.php, contributions.php, base_de_donnees.php, utilisateurs.php
// et l'initialisation des strings et des erreurs
function page_liste_contributions($lien_bdd,$id_proj=false) {

    $id_utilisateur = $_SESSION['id_utilisateur'];
    debut_html(LISTE_CONTRIBUTIONS, LISTE_CONTRIBUTIONS, '', $id_proj);
    $jeton = getJeton();
    $dossier_sites = $_SESSION['chemin_dossier_apercu'];
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur);
    
    if ($liste_projets != false) {
        $foret_projets = construire_foret_projets($liste_projets);
        if (count($foret_projets) > 0)
            afficher_foret($lien_bdd,$foret_projets, $dossier_sites, $jeton);
    }
    
    fin_html();
}

function afficher_foret($lien_bdd,$foret, $dossier_sites, $jeton) {
    echo "<ul>\n";
    for ($i=0; $i<count($foret); $i++) {
        echo "<li>";
        $projet = $foret[$i]['projet'];
        $sous_projets = $foret[$i]['sous-projets'];
        $id_projet = $projet['id'];
        $titre_projet = $projet['titre'];
        $liste_contributions = liste_des_contributions_projet($lien_bdd,$id_projet);
        echo '<p id="p'.$id_projet.'" class="soustitre">'.PROJET.' <em>'.$titre_projet.'</em>';
        if (($liste_contributions == false || count($liste_contributions) == 0) && (count($sous_projets) == 0)) {
            echo ' <a href="index.php?action=supprimer_projet&amp;id='.$id_projet.'&amp;jeton='.$jeton.'" class="petit_bouton">';
            echo '<img src="../../design/icones/poubelle.gif" class="icone" border="0" alt=""> '.SUPPRIMER.'</a>';
        } else {
            echo ' <a href="index.php?action=exporter_projet&amp;id='.$id_projet.'&amp;jeton='.$jeton.'" class="petit_bouton">';
            echo '<img src="../../design/icones/telecharger.gif" class="icone" alt=""> '.EXPORTER.'</a>';
        }
        echo "</p>\n";
        if ($liste_contributions != FALSE) {
            echo '<div class="listecontribution">'."\n";
            echo '<table class="tab_contrib_util">'."\n";
            for ($j=0; $j<count($liste_contributions); $j++) {
                $contribution = $liste_contributions[$j];
                $id_contribution = $contribution['id'];
                $nom_contribution = $contribution['nom'];
                echo '<tr><td style="text-align:center;">';
                echo "<a href=\"index.php?page=edition_contribution&amp;id_contribution=$id_contribution\" class=\"contribution\">$nom_contribution</a>";
                echo "</td><td style=\"text-align:center;\">\n";
                //echo "<a href=\"index.php?page=edition_contribution&amp;id_contribution=$id_contribution\" title=\"".EDITER_CONTRIBUTION."\"><img src=\"../../design/icones/editer.gif\" alt=\"".EDITER_CONTRIBUTION."\" border=\"0\"></a> &nbsp;";
                if (is_file("../../".$dossier_sites."/".$nom_contribution."/index.html"))
                   echo " <a href=\"../../".$dossier_sites."/".$nom_contribution."/index.html\" title=\"".VOIR_APERCU."\" target=\"_blank\"><img src=\"../../design/icones/site.gif\" alt=\"".APERCU."\" border=\"0\"></a>";
                echo "</td></tr>\n";
            }
            echo "</table>\n";
            echo "</div>\n"; // listecontribution
        }
        if (count($sous_projets) > 0)
            afficher_foret($lien_bdd,$sous_projets, $dossier_sites, $jeton);
        echo "</li>\n";
    }
    echo "</ul>\n";
}

// Supprime un projet à partir de son id dans une requête GET
function action_supprimer_projet($lien_bdd) {
    if (!isset($_GET['id']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet= $_GET['id'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    if (!est_participant($lien_bdd,$id_projet, $id_utilisateur))
        erreur(PAS_AUTORISE);
    $liste_contributions = liste_des_contributions_projet($lien_bdd,$id_projet);
    if ($liste_contributions != false && count($liste_contributions) != 0)
        erreur(PAS_AUTORISE);
    if (supprimer_projet($lien_bdd,$id_projet))
        page_liste_contributions($lien_bdd);
}

// Export en zip de toutes les contributions d'un projet
function action_exporter_projet($lien_bdd) {
    if (!isset($_GET['id']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if (!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_projet = $_GET['id'];
    if (!est_participant($lien_bdd,$id_projet, $id_utilisateur) && $_SESSION['status'] != "administrateur")
        erreur(PAS_AUTORISE);
    
    exporter_projet($lien_bdd,$id_projet);
}

?>
