<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();


if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__).'/../include/base_de_donnees.php');
require_once(dirname(__FILE__).'/../include/projets.php');
require_once(dirname(__FILE__).'/../include/contributions.php');
require_once(dirname(__FILE__).'/../include/fichier.php');
require_once(dirname(__FILE__).'/../include/outils.php');
require_once(dirname(__FILE__).'/../include/tete_pied.php');
require_once(dirname(__FILE__)."/../include/utilisateurs.php");
require_once(dirname(__FILE__).'/../include/verification_noms.php');
require_once(dirname(__FILE__).'/../include/pclzip.lib.php');
require_once(dirname(__FILE__)."/preferences.php");
require_once(dirname(__FILE__)."/liste_contributions.php");
require_once(dirname(__FILE__)."/nouvelle_contribution.php");
require_once(dirname(__FILE__)."/nouveau_projet.php");
require_once(dirname(__FILE__)."/edition_contribution.php");
require_once(dirname(__FILE__)."/fichiers_associes.php");
require_once(dirname(__FILE__)."/historique.php");
require_once(dirname(__FILE__)."/renommer_contribution.php");
require_once(dirname(__FILE__)."/rechercher.php");
require_once(dirname(__FILE__).'/../text_diff/Diff.php');
require_once(dirname(__FILE__).'/../text_diff/Diff/Renderer.php');
require_once(dirname(__FILE__).'/../text_diff/Diff/Renderer/inline.php');
require_once(dirname(__FILE__)."/../include/connectes.php");

init_erreurs();

$_SESSION['section'] = 'utilisateur';



if (!isset($_SESSION['id_utilisateur']))
    erreur(PAS_DE_SESSION);

if ($_SESSION['status'] != 'utilisateur' && $_SESSION['status'] != 'administrateur')
    erreur(PAS_AUTORISE);

$lien_bdd = connexion();
utilisateur_connecte($lien_bdd);

if (isset($_GET['page'])) {
    if ($_GET['page'] == 'liste_contributions')
        if (!isset($_GET['id_projet']))
            page_liste_contributions($lien_bdd);
        else {
            verifie_id($_GET['id_projet']);
            page_liste_contributions($lien_bdd,$_GET['id_projet']);
        }
    else if ($_GET['page'] == 'nouvelle_contribution') {
        if (!isset($_GET['id_projet']))
            page_nouvelle_contribution($lien_bdd);
         else {
            verifie_id($_GET['id_projet']);
            page_nouvelle_contribution($lien_bdd,'', '', $_GET['id_projet']);
        }
    } else if ($_GET['page'] == 'nouveau_projet')
        page_nouveau_projet();
    else if ($_GET['page'] == 'preferences')
        page_preferences($lien_bdd);
    else if ($_GET['page'] == 'rechercher') {
        if (!isset($_GET['id_projet']))
            page_rechercher($lien_bdd);
        else {
            verifie_id($_GET['id_projet']);
            page_rechercher($lien_bdd,$_GET['id_projet']);
        }
    } else if ($_GET['page'] == 'edition_contribution') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        if (isset($_GET['suppression']))
            page_edition_contribution($lien_bdd,$_GET['id_contribution'], $_GET['suppression']);
        else if (isset($_GET['fichier'])) {
            $fichier = $_GET['fichier'];
            $pos = strrpos($fichier, '/');
            $repertoire = substr($fichier, 0, $pos);
            page_fichiers_associes($lien_bdd,$_GET['id_contribution'], $repertoire);
        } else
            page_edition_contribution($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'cadre_edition_xml') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        if (isset($_GET['fichier']))
            page_cadre_edition_xml($lien_bdd,$_GET['id_contribution'], $_GET['fichier']);
        else
            page_cadre_edition_xml($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'edition_xml') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        if (isset($_GET['fichier']))
            page_edition_xml($lien_bdd,$_GET['id_contribution'], $_GET['fichier']);
        else
            page_edition_xml($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'reload') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        page_reload($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'fichiers_associes') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        if (isset($_GET['repertoire']))
            $repertoire = $_GET['repertoire'];
        else
            $repertoire = '';
        if (isset($_GET['renommer']))
            page_fichiers_associes($lien_bdd,$_GET['id_contribution'], $repertoire, '', $_GET['renommer']);
        else
            page_fichiers_associes($lien_bdd,$_GET['id_contribution'], $repertoire);
    } else if ($_GET['page'] == 'historique') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        if (isset($_GET['repertoire']) && !isset($_GET['rep_date']))
            erreur(PARAMETRES_MANQUANT);
        if (isset($_GET['repertoire']))
            page_historique($lien_bdd,$_GET['id_contribution'], $_GET['rep_date'], $_GET['repertoire']);
        else if (isset($_GET['rep_date']))
            page_historique($lien_bdd,$_GET['id_contribution'], $_GET['rep_date']);
        else
            page_historique($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'diff') {
        if (!isset($_GET['id_contribution']) || !isset($_GET['rep_date']) || !isset($_GET['fichier']) || !isset($_GET['avec']))
            erreur(PARAMETRES_MANQUANT);
        page_diff($lien_bdd,$_GET['id_contribution'], $_GET['rep_date'], $_GET['fichier'], $_GET['avec']);
    } else if ($_GET['page'] == 'renommer_contribution') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        page_renommer_contribution($lien_bdd,$_GET['id_contribution']);
    } else
        erreur('Page inconnue');
    
} else if (isset($_GET['action'])) {
    if ($_GET['action'] == 'supprimer_contribution')
        action_supprimer_contribution($lien_bdd);
    else if ($_GET['action'] == 'supprimer_repertoire')
        action_supprimer_repertoire($lien_bdd);
    else if ($_GET['action'] == 'supprimer_fichier')
        action_supprimer_fichier($lien_bdd);
    else if ($_GET['action'] == 'generer_apercu') {
        if (isset($_GET['type']))
            action_generer_apercu($lien_bdd,$_GET['type'], NULL);
        else
            action_generer_apercu($lien_bdd,NULL, NULL);
    } else if ($_GET['action'] == 'exporter')
        action_exporter($lien_bdd);
    else if ($_GET['action'] == 'effacer_site')
        action_effacer_site($lien_bdd);
    else if ($_GET['action'] == 'exporter_site') {
        if (isset($_GET['type']))
            action_exporter_site($lien_bdd,$_GET['type']);
        else
            action_exporter_site($lien_bdd);
    } else if ($_GET['action'] == 'supprimer_projet')
        action_supprimer_projet($lien_bdd);
    else if ($_GET['action'] == 'exporter_projet')
        action_exporter_projet($lien_bdd);
    
} else if (isset($_POST['action'])) {
    if ($_POST['action'] == 'ajouter_projet')
        action_ajouter_projet($lien_bdd);
    else if ($_POST['action'] == 'importer_projet')
        action_importer_projet($lien_bdd);
    else if ($_POST['action'] == 'editer_preferences')
        action_editer_preferences($lien_bdd);
    else if ($_POST['action'] == 'ajouter_contribution')
        action_ajouter_contribution($lien_bdd);
    else if ($_POST['action'] == 'ajouter_sous_repertoire')
        action_ajouter_sous_repertoire($lien_bdd);
    else if ($_POST['action'] == 'ajouter_fichier')
        action_ajouter_fichier($lien_bdd);
    else if ($_POST['action'] == 'renommer')
        action_renommer($lien_bdd);
    else if ($_POST['action'] == 'creer_xml')
        action_creer_xml($lien_bdd);
    else if ($_POST['action'] == 'importer_contribution')
        action_importer_contribution($lien_bdd);
    else if ($_POST['action'] == 'renommer_contribution')
        action_renommer_contribution($lien_bdd);
    else if ($_POST['action'] == 'rechercher')
        action_rechercher($lien_bdd);
    else
        erreur('Action inconnue');
} else {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && empty($_POST) && empty($_FILES) && $_SERVER['CONTENT_LENGTH'] > 0)
        erreur(ERR_TAILLE_MAX_POST);
    erreur(PARAMETRES_MANQUANT);
}


?>
