<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page permettant de gérer les fichiers associés dans une contribution
// nécessite tete_pied.php, contributions.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function page_fichiers_associes($lien_bdd,$id_contribution, $repertoire='', $message='', $renommer='') {
    define ("KILO_OCTET", 1024);
    define ("MEGA_OCTET", KILO_OCTET*KILO_OCTET);
    define ("GIGA_OCTET", MEGA_OCTET*MEGA_OCTET);
    
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    if ($repertoire == '')
        $chemin = '../../contribXML/'.$nom_contribution;
    else
        $chemin = '../../contribXML/'.$nom_contribution.'/'.$repertoire;
    
    $pos = strpos(realpath($chemin), realpath('../../contribXML/'.$nom_contribution));
    if ($pos === false || $pos != 0)
        erreur(PAS_AUTORISE);
    
    debut_html(TITRE_FICHIERS_ASSOCIES, TITRE_EDITER_CONTRIBUTION);
    
    $jeton = getJeton();
    
    echo '<p>'.NOM_CONTRIBUTION." ".$nom_contribution."</p>\n";
    
    echo ' <div class="listedefichier">'."\n";
    $chemincourant = '';
    echo '<a href="index.php?page=fichiers_associes&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$chemincourant.'">';
    echo '<img src="../../design/icones/dossier_ouvert.gif" alt="">'.$nom_contribution."</a>\n";
    if ($repertoire != '')
    {
        $rep = preg_split('#[/]#', $repertoire);
        for ($i=0; $i<count($rep); $i++)
        {
            if ($chemincourant == '')
                $chemincourant = $rep[$i];
            else
                $chemincourant = $chemincourant."/".$rep[$i];
            echo '<div class="indentation_fichier">'."\n";
            echo '<a href="index.php?page=fichiers_associes&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$chemincourant.'">';
            echo '<img src="../../design/icones/dossier_ouvert.gif">'.$rep[$i]."</a>\n";
        }
    }
    
    $liste_sous_repertoire = liste_sous_repertoire($chemin);
    for ($i=0; $i<count($liste_sous_repertoire); $i++)
    {
        if ($repertoire == '')
            $chemin_sous_repertoire = $liste_sous_repertoire[$i];
        else
            $chemin_sous_repertoire = $repertoire.'/'.$liste_sous_repertoire[$i];
        echo ' <div class="indentation_fichier">'."\n";
        echo '<a href="index.php?page=fichiers_associes&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$chemin_sous_repertoire.'">';
        echo '<img src="../../design/icones/dossier.gif" alt="">'.$liste_sous_repertoire[$i].'</a>';
        echo ' <a href="index.php?page=fichiers_associes&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$repertoire.'&amp;renommer='.$liste_sous_repertoire[$i].'" title="'.RENOMMER.'">';
        echo '<img src="../../design/icones/renommer.gif" alt="'.RENOMMER.'"></a>'."\n";
        echo ' <a href="index.php?action=supprimer_repertoire&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$chemin_sous_repertoire.'&amp;jeton='.$jeton.'" title="'.SUPPRIMER.'">';
        echo '<img src="../../design/icones/poubelle.gif" alt="'.SUPPRIMER.'"></a>'."\n";
        echo "</div>\n"; // indentation_fichier
    }
    
    if ($renommer == '') {
        $listefichiers = liste_fichiers($chemin);
        for ($i=0; $i<count ($listefichiers); $i++)
        {
            $nom_fichier = $listefichiers[$i];
            // On n'affiche pas le document XML car il ne fait pas partie des fichiers associés
            //if ($nom_fichier != $nom_contribution.".xml")
            //{
                if ($repertoire == '')
                    $chemin_fichier = $nom_fichier;
                else
                    $chemin_fichier = $repertoire.'/'.$nom_fichier;
                echo ' <div class="indentation_fichier">'."\n";
                echo '<img src="../../design/icones/fichier.gif" alt="">'.htmlentities($nom_fichier, ENT_QUOTES, 'UTF-8').' (<i>';
                echo taille_du_fichier($chemin.'/'.$nom_fichier).'</i>) ';
                if (strpos($nom_fichier, '.xml') == strlen($nom_fichier) - 4) {
                    echo "<a href=\"index.php?page=cadre_edition_xml&amp;id_contribution=$id_contribution&amp;fichier=".urlencode($chemin_fichier)."\">";
                    echo "<img src=\"../../design/icones/editer.gif\" alt=\"".EDITER_FICHIER_XML."\"></a>\n";
                }
                if ($nom_fichier != $nom_contribution.".xml") {
                    if (!fichier_avec_reference($nom_contribution, $nom_fichier))
                        echo ' <a title="'.SANS_REFERENCE.'"><img src="../../design/icones/sans_reference.gif" alt="'.SANS_REFERENCE.'"></a>';
                    echo ' <a href="'.$chemin.'/'.urlencode($nom_fichier).'" title="'.TELECHARGER.'" target="_blank">';
                    echo '<img src="../../design/icones/telecharger.gif" alt="'.TELECHARGER.'"></a>'."\n";
                    echo ' <a href="index.php?page=fichiers_associes&amp;id_contribution='.$id_contribution.'&amp;repertoire='.$repertoire.'&amp;renommer='.urlencode($nom_fichier).'" title="'.RENOMMER.'">';
                    echo '<img src="../../design/icones/renommer.gif" alt="'.RENOMMER.'"></a>'."\n";
                    echo ' <a href="index.php?action=supprimer_fichier&amp;id_contribution='.$id_contribution.'&amp;fichier='.urlencode($chemin_fichier).'&amp;jeton='.$jeton.'" title="'.SUPPRIMER.'">';
                    echo '<img src="../../design/icones/poubelle.gif" alt="'.SUPPRIMER.'"></a>'."\n";
                }
                echo "</div>\n"; // indentation_fichier
            //}
        }
    }
    
    if ($repertoire != '')
    {
        for($i=0; $i<count($rep); $i++)
            echo "</div>\n"; // indentation_fichier
    }
    
    echo "</div>\n"; // listedefichier
    
    if ($renommer != '') {
        echo RENOMMER.' '.$renommer;
        echo '<form method="POST" action="index.php">'."\n";
        echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
        echo '<input type="hidden" name="action" value="renommer">'."\n";
        echo '<input type="text" name="nouveau_nom" class="texte">'."\n";
        echo '<input type="hidden" name="nom_fichier" value="'.$renommer.'">'."\n";
        echo '<input type="hidden" name="id_contribution" value="'.$id_contribution.'">'."\n";
        echo '<input type="hidden" name="chemin" value="'.$repertoire.'">'."\n";
        echo '<input type="submit" name="renommer" value="'.RENOMMER.'" class="valider">'."\n";
        echo "</form>\n";
    }
    
    echo "<hr>\n";
    echo AJOUT_FICHIER.' '.basename($chemin);
    echo '<form method="POST" enctype="multipart/form-data" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="ajouter_fichier">'."\n";
    echo '<p><input type="file" name="fichier[]" class="fichier" multiple="multiple"></p>'."\n";
    echo '<input type="hidden" name="repertoire" value="'.$repertoire.'">'."\n";
    echo '<p><input type="hidden" name="id_contribution" value="'.$id_contribution.'"></p>'."\n";
    echo '<p><input type="hidden" name="chemin" value="'.$chemin.'"></p>'."\n";
    echo '<p><input type="submit" name="upload" value="'.AJOUTER.'" class="valider"></p>'."\n";
    echo "</form>\n";
    
    echo "<hr>\n";
    echo '<div class="sous_repertoires">'."\n"; // classe non définie dans la CSS !
    echo AJOUT_SOUS_DOSSIER.' '.basename($chemin);
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="ajouter_sous_repertoire">'."\n";
    echo '<input type="text" name="nom_sous_repertoire" class="texte">'."\n";
    echo '<input type="hidden" name="id_contribution" value="'.$id_contribution.'">'."\n";
    echo '<input type="hidden" name="chemin" value="'.$repertoire.'">'."\n";
    echo '<input type="submit" name="creer" value="'.AJOUTER.'" class="valider">'."\n";
    echo "</form>\n";
    echo "</div>\n"; // sous_repertoires
    
    echo "<hr>\n";
    echo CREER_FICHIER_XML.' '.basename($chemin);
    echo '<form method="POST" action="index.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="creer_xml">'."\n";
    echo '<input type="text" name="nom_fichier" class="texte">'."\n";
    echo '<input type="hidden" name="id_contribution" value="'.$id_contribution.'">'."\n";
    echo '<input type="hidden" name="chemin" value="'.$repertoire.'">'."\n";
    echo '<input type="submit" name="creer" value="'.CREER.'" class="valider">'."\n";
    echo "</form>\n";
    
    echo "<hr>\n";
    if ($message != '')
        echo "<p class=\"erreur\">$message</p>\n";
    
    // si on se trouve pas à la racine alors on peut revenir en arrière
    if ($repertoire != '')
    {
        echo '<div class="repertoire_parent">'."\n";
        $repertoires = explode ( "/", $repertoire);
        $repertoiresi = array_pop($repertoires);
        $nouveaurepertoire = implode("/", $repertoires);
        echo "<p><a href='index.php?page=fichiers_associes&amp;id_contribution=$id_contribution&amp;repertoire=".$nouveaurepertoire."'>".REVENIR_DOSSIER_PARENT."</a></p>\n";
        echo "</div>\n";
    }
    echo "<br>\n";
    echo '<p><a href="index.php?page=edition_contribution&amp;id_contribution='.$id_contribution.'" target="_parent">'.RETOUR."</a></p>\n";
    
    fin_html();
}


// crée un nouveau sous-répertoire à partir d'une requête POST
// nécessite tete_pied.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function action_ajouter_sous_repertoire($lien_bdd) {
    if (!isset($_POST['id_contribution']) || !isset($_POST['nom_sous_repertoire']) || !isset($_POST['chemin']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_contribution = $_POST['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $nom_sous_repertoire = $_POST['nom_sous_repertoire'];
    $chemin = $_POST['chemin'];
    
    if ($nom_sous_repertoire == '')
        page_fichiers_associes($lien_bdd,$id_contribution, $chemin, NOM_SOUSREPERTOIRE_MANQUANT);
    else {
        ajouter_repertoire($nom_contribution."/".$chemin, $nom_sous_repertoire);
        page_fichiers_associes($lien_bdd,$id_contribution, $chemin);
    }
}


// supprime un répertoire à partir d'une requête GET
// nécessite tete_pied.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function action_supprimer_repertoire($lien_bdd) 
{
    if (!isset($_GET['id_contribution']) || !isset($_GET['repertoire']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_GET['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $repertoire = $_GET['repertoire'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    $chemin_vers_repertoire = '../../contribXML/'.$nom_contribution.'/'.$repertoire;
    supprimer_repertoire($chemin_vers_repertoire, $nom_contribution);
    $parent = dirname($repertoire);
    if ($parent == '.')
        $parent = '';
    page_fichiers_associes($lien_bdd,$id_contribution, $parent);
}


// ajoute un fichier à la contribution à partir d'une requête POST
// nécessite tete_pied.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function action_ajouter_fichier($lien_bdd) 
{
    if (!isset($_POST['id_contribution']) || !isset($_POST['chemin']) || !isset($_POST['repertoire']) || !isset($_FILES['fichier']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_POST['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $repertoire_destination = $_POST['chemin'];
    $repertoire = $_POST['repertoire'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    if ($_FILES['fichier']['tmp_name'] == '')
        page_fichiers_associes($lien_bdd,$id_contribution, $repertoire, SELECTION_MANQUANTE);
    else {
        $creationfichier = ajouter_fichier($repertoire_destination);
        page_fichiers_associes($lien_bdd,$id_contribution, $repertoire);
    }
}


// supprime un fichier à partir d'une requête GET
// nécessite tete_pied.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function action_supprimer_fichier($lien_bdd) {
    if (!isset($_GET['id_contribution']) || !isset($_GET['fichier']) || !isset($_GET['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_GET['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_GET['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $fichier = $_GET['fichier'];
    $id_utilisateur = $_SESSION['id_utilisateur'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    
    $chemin_vers_fichier = '../../contribXML/'.$nom_contribution.'/'.$fichier;
    supprimer_fichier($chemin_vers_fichier, $nom_contribution);
    $repertoire = dirname($fichier);
    if ($repertoire == '.')
        $repertoire = '';
    page_fichiers_associes($lien_bdd,$id_contribution, $repertoire);
}


// renomme un fichier ou sous-répertoire à partir d'une requête POST
// nécessite tete_pied.php, utilisateurs.php, fichier.php, et l'initialisation des strings et des erreurs
function action_renommer($lien_bdd) {
    if (!isset($_POST['id_contribution']) || !isset($_POST['chemin']) || !isset($_POST['nom_fichier']) || !isset($_POST['nouveau_nom']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_contribution = $_POST['id_contribution'];
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $chemin = $_POST['chemin'];
    $nom_fichier = $_POST['nom_fichier'];
    $nouveau_nom = $_POST['nouveau_nom'];
    
    if ($nouveau_nom == '')
        page_fichiers_associes($lien_bdd,$id_contribution, $chemin, NOM_MANQUANT, $nom_fichier);
    else {
        renommer($nom_contribution, $chemin, $nom_fichier, $nouveau_nom);
        page_fichiers_associes($lien_bdd,$id_contribution, $chemin);
    }
}


// crée un nouveau document XML à partir d'une requête POST
// nécessite tete_pied.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function action_creer_xml($lien_bdd) {
    if (!isset($_POST['id_contribution']) || !isset($_POST['nom_fichier']) || !isset($_POST['chemin']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $id_contribution = $_POST['id_contribution'];
    verifier_l_utilisateur($lien_bdd,$id_utilisateur, $id_contribution);
    $nom_fichier = $_POST['nom_fichier'];
    if (strpos($nom_fichier, '.xml') === false)
        $nom_fichier = $nom_fichier.'.xml';
    $chemin = $_POST['chemin'];
    if ($chemin == '')
        $chemin_fichier = $nom_fichier;
    else
        $chemin_fichier = $chemin.'/'.$nom_fichier;
    page_cadre_edition_xml($lien_bdd,$id_contribution, $chemin_fichier);
}


?>
