<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page permettant de modifier les projets d'un utilisateur
// nécessite tete_pied.php, projets.php, base_de_donnees.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_projets_utilisateur($lien_bdd,$id_utilisateur) {
    
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    $status = $utilisateur['status'];
    $login = $utilisateur['login'];
    $liste_projets = liste_id_projets($lien_bdd);
    $liste_projets_utilisateur = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur, false);
    
    debut_html(LISTE_PROJETS, GESTION_UTILISATEURS);
    $jeton = getJeton();
    echo '<h2>'.$login.'</h2>'."\n";
    echo '<div class="boitedroite">'."\n";
    echo '<div class="contributeur">';
    echo '<table>';
	echo '<tr>';
	echo '<th>'. PROJET .'</th>';
	if($status != 'administrateur')
		echo '<th>' .DROIT_MODIFICATION.'</th>';
	echo '<th style="text-align:center">' .ACTIONS .'</th>';
	echo '</tr>';
    if ($liste_projets_utilisateur != FALSE) {
        for ($i=0; $i<count($liste_projets_utilisateur); $i++)
        {
            $projet = $liste_projets_utilisateur[$i];
            $id_projet = $projet['id'];
            $titre_projet = $projet['titre'];
            $id_profile = $projet['id_profile'];
            $form_nb = "form".$i;
            echo '<tr>'; 
            echo '<td>'."$titre_projet".'</td>';
            if($status != 'administrateur')
            {
				if($id_profile == 1)
					echo '<td style="text-align:center"><input type="checkbox" name="id_profile" value="1" checked="checked" form="'.$form_nb.'"> </td>';
				else 
					echo '<td style="text-align:center"><input type="checkbox" name="id_profile" value="1" form="'.$form_nb.'"> </td>';
                echo '<td>';
				echo '<form method="POST" action="administration.php" id="'.$form_nb.'">'."\n";
				echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
				echo ' <input type="hidden" name="action" value="supprimer_modifier_lien_projet"> '."\n";
				echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">';
				echo '<input type="hidden" name="id_utilisateur" value="'.$id_utilisateur.'"> ';
				echo '<input type="submit" name="modifier_droit_projet" value="'.EDITER.'" class="valider">  <input type="submit" name="supprimer_lien_projet" value="'.RETIRER.'" class="valider">'."\n";
				echo "</form>\n";
				echo '</td>';
				
			}
			else 
			{
				echo '<td>';
				echo '<form method="POST" action="administration.php" id="'.$form_nb.'">'."\n";
				echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
				echo '<input type="hidden" name="action" value="supprimer_modifier_lien_projet"> '."\n";
				echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">';
				echo '<input type="hidden" name="id_utilisateur" value="'.$id_utilisateur.'"> ';
				echo '<input type="submit" name="supprimer_lien_projet" value="'.RETIRER.'" class="valider" form="'.$form_nb.'">'."\n";
				echo "</form>\n";
				echo '</td>';
			}
            echo '</tr>'; 
        }
    }
     
    //ajouter un projet
    //echo '<div class="ajout_contributeur">'."\n";
    $liste_projets_hors_utilisateur = array();
    for ($i=0; $i<count($liste_projets); $i++)
    {
        $id_projet = $liste_projets[$i];
        $form_ajout = "ajoutform".$i;
        $lien = false;
        for ($j=0; $j<count($liste_projets_utilisateur); $j++)
        {
            if ($id_projet == $liste_projets_utilisateur[$j]['id'])
                $lien = true;
        }
        if ($lien == false)
            array_push($liste_projets_hors_utilisateur, $id_projet);
    }
    if (count($liste_projets_hors_utilisateur) > 0)
    {
		echo '<tr>' ;
        echo '<td> <select name="id_projet" form="'.$form_ajout.'">';
        for ($i=0; $i<count($liste_projets_hors_utilisateur); $i++)
        {
            $id_projet = $liste_projets_hors_utilisateur[$i];
            echo "<option value=\"".$id_projet."\">".titre_projet($lien_bdd,$id_projet)."</option>";
        }
        echo "</select>\n";
        echo '</td>';
        if($status != 'administrateur')
			echo '<td style="text-align:center"><input type="checkbox" name=id_profile value="1" form="'.$form_ajout.'"> </td>';

			
        echo '<td>';
        if($status == 'administrateur')
			echo '<input type="hidden" name=id_profile value="1" form="'.$form_ajout.'"> ';
        echo '<form method="POST" action="administration.php" id="'.$form_ajout.'">';
		echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
		echo '<input type="hidden" name="action" value="ajouter_lien_projet">'."\n";
		echo '<input type="hidden" name="id_utilisateur" value="'.$id_utilisateur.'" form="'.$form_ajout.'">';
        echo '<input type="submit" name="ajouter" value="'.JOINDRE.'" class="valider">';
        echo "</form>\n";
        echo '</td>';
    }
    echo '</table>'; //end table
    echo "</div>"; // ajout_contributeur
    echo "</div>\n"; // boitedroite
    
    echo '<p><a href="administration.php?page=administration_utilisateurs">'.RETOUR."</a></p>\n";
    
    fin_html();
}


// Ajoute un lien utilisateur-projet à partir d'une requête POST
function action_ajouter_lien_projet($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    if(isset($_POST['id_profile']))
		$id_profile = $_POST['id_profile'];
	else 
		$id_profile = 0;
    ajouter_participant($lien_bdd,$id_projet, $id_utilisateur,$id_profile);
    page_projets_utilisateur($lien_bdd,$id_utilisateur);
}


// Supprime un lien utilisateur-projet à partir d'une requête POST
function action_supprimer_lien_projet($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    
    supprimer_participant($lien_bdd,$id_projet, $id_utilisateur);
    page_projets_utilisateur($lien_bdd,$id_utilisateur);
}

//modifier le droit d'ecriture pour un lien utilisateur-projet
function action_modifier_droit_projet($lien_bdd)
{
	if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    if(isset($_POST['id_profile']))
		$id_profile = $_POST['id_profile'];
	else 
		$id_profile = 0;
		
	modifier_participant($lien_bdd,$id_projet, $id_utilisateur,$id_profile);	
	page_projets_utilisateur($lien_bdd,$id_utilisateur);
}

?>
