<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

//include(dirname(__FILE__)."/../include/connectes.php");

// affiche la page permettant de modifier le projet d'une contribution
// nécessite tete_pied.php, projets.php, contributions.php, base_de_donnees.php, et l'initialisation des strings et des erreurs
function page_projet_contribution($lien_bdd,$id_contribution) {
    
    $liste_projets = liste_des_projets($lien_bdd);
    
    debut_html(GESTION_CONTRIBUTIONS, GESTION_CONTRIBUTIONS);
    $jeton = getJeton();
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    $id_projet = id_projet_contribution($lien_bdd,$id_contribution);
    echo '<h2>'.$nom_contribution.'</h2>'."\n";
    echo '<div class="boitedroite">'."\n";
    
    echo '<div class="formulaire">'."\n";
    echo '<p class="soustitre">'.TITRE_MODIFIER_PROJET.'</p>'."\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="modifier_projet_contribution">'."\n";
    echo '<input type="hidden" name="id_contribution" value="'.$id_contribution.'">';
    
    echo ' <select name="id_projet">';
    $liste_projets = liste_des_projets($lien_bdd);
    if ($liste_projets != FALSE) {
        for ($i=0; $i<count($liste_projets); $i++) {
            $id = $liste_projets[$i]['id'];
            $titre = $liste_projets[$i]['titre'];
            if ($id == $id_projet)
                $selected = ' selected';
            else
                $selected = '';
            echo '<option'.$selected.' value="'.$id.'">'.$titre.'</option>';
        }
    }
    echo '</select> ';
    
    echo '<input type="submit" value="'.MODIFIER.'" class="valider">';
    echo "</form>\n";
    echo "</div>\n"; // formulaire
    
    echo "</div>\n"; // boitedroite
    
    echo '<p><a href="administration.php?page=gestion_des_contributions">'.RETOUR."</a></p>\n";
    
    fin_html();
}


// Modification du projet d'une contribution à partir d'une requête POST
function action_modifier_projet_contribution($lien_bdd) {
    
    if (!isset($_POST['id_contribution']) || !isset($_POST['id_projet']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_contribution = $_POST['id_contribution'];
    verifie_id($id_contribution);
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    
    // on vérifie que la contribution et le projet existent
    $nom_contribution = nom_contribution($lien_bdd,$id_contribution);
    if ($nom_contribution == FALSE)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $titre = titre_projet($lien_bdd,$id_projet);
    if ($titre == FALSE)
        erreur(PROJET_EXISTE_PAS);
    
    modifier_projet_contribution($lien_bdd,$id_contribution, $id_projet);
    page_projet_contribution($lien_bdd,$id_contribution);
}


?>
