<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page permettant de modifier les participants d'un projet
// nécessite tete_pied.php, projets.php, base_de_donnees.php, utilisateurs.php, et l'initialisation des strings et des erreurs
function page_participants_projet($lien_bdd,$id_projet) {
    
    $liste_utilisateurs = liste_des_utilisateurs($lien_bdd);
    
    debut_html(PARTICIPANTS, GESTION_PROJETS);
    $jeton = getJeton();
    $titre_projet = titre_projet($lien_bdd,$id_projet);
    $liste_participants = liste_participants($lien_bdd,$id_projet);
    echo '<h2>'.$titre_projet.'</h2>'."\n";
    echo '<div class="boitedroite">'."\n";
     echo '<div class="contributeur">';
    echo '<table>';
    echo '<tr>';
    echo '<th>'.PARTICIPANT.'</th>';
    //echo '<th> Droit de modification </th>';
    echo '<th style="text-align:center">'.ACTIONS.'</th>';
    echo '</tr>';
    if ($liste_participants != FALSE) {
        for ($i=0; $i<count($liste_participants); $i++)
        {
            $participant = $liste_participants[$i];
            $id_utilisateur = $participant['id'];
            $nom = $participant['nom'];
            $prenom = $participant['prenom'];
            $id_profile = $participant['id_profile'];
            echo '<tr>'; 
            echo '<td>'."$prenom $nom".'</td>';
            echo '<td>';
            echo '<form method="POST" action="administration.php">'."\n";
            echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
            echo '<input type="hidden" name="action" value="supprimer_participant">'."\n";
            echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">';
            echo '<input type="hidden" name="id_utilisateur" value="'.$id_utilisateur.'">';
            echo '<input type="submit" name="supprimer_participant" value="'.RETIRER.'" class="valider">';
            echo "</form>\n";
            echo '</td>';
            echo '</tr>';
        }
    }
    
    $liste_utilisateurs_hors_participants = array();
    for ($i=0; $i<count($liste_utilisateurs); $i++)
    {
        $utilisateur = $liste_utilisateurs[$i];
        $participe = false;
        for ($j=0; $j<count($liste_participants); $j++)
        {
            if ($utilisateur['id'] == $liste_participants[$j]['id'])
                $participe = true;
        }
        if ($participe == false)
            array_push($liste_utilisateurs_hors_participants, $utilisateur);
    }
    if (count($liste_utilisateurs_hors_participants) > 0)
    {   
		$nb = 1;
		$form_nb = "form".$nb;
		echo '<tr>';
        echo '<td> <select name="id_utilisateur" form="'.$form_nb.'">';
        for ($i=0; $i<count($liste_utilisateurs_hors_participants); $i++)
        {
            $utilisateur = $liste_utilisateurs_hors_participants[$i];
            echo "<option value=\"".$utilisateur['id']."\">".$utilisateur['prenom'].' '.$utilisateur['nom']."</option>";
        }
        echo "</select> </td>\n";
        echo '<td>';
        echo '<form method="POST" action="administration.php" id="'.$form_nb.'">'."\n";
		echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
		echo '<input type="hidden" name="action" value="ajouter_participant">'."\n";
		echo '<input type="hidden" name="id_profile" value="1">';
        echo '<input type="submit" name="ajouter" value="'.JOINDRE.'" class="valider">'; 
        echo '<input type="hidden" name="id_projet" value="'.$id_projet.'">';
        echo "</form>\n";
        echo '</td>';
        echo '</tr>';
    }
    echo '</table>';
    echo "</div> \n"; // ajout_contributeur
    echo "</div>\n"; // boitedroite

    echo '<p><a href="administration.php?page=administration_projets">'.RETOUR."</a></p>\n";
    
    fin_html();
}


// Ajoute un participant à partir d'une requête POST
function action_ajouter_participant($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    
    // on vérifie que l'utilisateur et la contribution existent
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    if ($utilisateur == FALSE)
        erreur(ECHEC_UTILISATEUR_EXISTANT);
    $titre_projet = titre_projet($lien_bdd,$id_projet);
    if ($titre_projet == FALSE)
        erreur(CONTRIBUTION_EXISTE_PAS);
    
    //pour un administrateur, il aura toujours le droit d'écriture
    if(isset($_POST['id_profile']))
		$id_profile = $_POST['id_profile'];
	else 
		$id_profile = 0; 
	
    ajouter_participant($lien_bdd,$id_projet, $id_utilisateur,$id_profile);
    page_participants_projet($lien_bdd,$id_projet);
}


// Supprime un participant à partir d'une requête POST
function action_supprimer_participant($lien_bdd) {
    
    if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    
    supprimer_participant($lien_bdd,$id_projet, $id_utilisateur);
    page_participants_projet($lien_bdd,$id_projet);
}
function action_modifier_profile_participant($lien_bdd)
{
	 if (!isset($_POST['id_projet']) || !isset($_POST['id_utilisateur']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
        $id_projet = $_POST['id_projet'];
    verifie_id($id_projet);
    $id_utilisateur = $_POST['id_utilisateur'];
    verifie_id($id_utilisateur);
    
    // on vérifie que l'utilisateur et la contribution existent
    $utilisateur = utilisateur($lien_bdd,$id_utilisateur);
    if ($utilisateur == FALSE)
        erreur(ECHEC_UTILISATEUR_EXISTANT);
    $titre_projet = titre_projet($lien_bdd,$id_projet);
    if ($titre_projet == FALSE)
        erreur(CONTRIBUTION_EXISTE_PAS);
    
    if(isset($_POST['id_profile']))
		$id_profile = $_POST['id_profile'];
	else 
		$id_profile = 0;  
    modifier_participant($lien_bdd,$id_projet, $id_utilisateur,$id_profile);    
	page_participants_projet($lien_bdd,$id_projet);
}


?>
