<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// affiche la page de modification d'un utilisateur, à partir de son id
// nécessite tete_pied.php, outils.php, base_de_donnees.php, utilisateurs.php, verification_noms.php,
// et l'initialisation des strings et des erreurs
function page_modifier_utilisateur($lien_bdd,$id) {
    
    $utilisateur = utilisateur($lien_bdd,$id);
    $login = $utilisateur['login'];
    $id = $utilisateur['id'];
    //$motdepasse = $utilisateur['motdepasse'];
    $nom = $utilisateur['nom'];
    $prenom = $utilisateur['prenom'];
    $email = $utilisateur['email'];
    $langue = $utilisateur['langue'];
    $status = $utilisateur['status'];
    
    debut_html(MODIFIER_UTILISATEUR, GESTION_UTILISATEURS);
    
    $jeton = getJeton();
    
    echo '<div class="boite_parametre_du_site">'."\n";
    echo '<form method="POST" action="administration.php">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<input type="hidden" name="action" value="modifier_parametres_utilisateur">'."\n";
    echo '<table class="bordure">'."\n";
    echo "<tr>";
    echo "<td>".LOGIN."</td>";
    echo "<td><input type=\"text\" class=\"texte\" name=\"login\" value=\"".$login."\"></td>";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td>".PRENOM."</td>";
    echo "<td><input type=\"text\" class=\"texte\" name=\"prenom\" value=\"".$prenom."\"></td>";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td>".NOM_FAMILLE."</td>";
    echo "<td><input type=\"text\" class=\"texte\" name=\"nom\" value=\"".$nom."\"></td>";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td>".EMAIL."</td>";
    echo "<td><input type=\"text\" class=\"texte\" name=\"email\" value=\"".$email."\" size=\"30\"></td>";
    echo "</tr>\n";
    echo "<tr>";
    echo "<td>".MOT_DE_PASSE."</td>";
    echo "<td><input type=\"password\" class=\"texte\" name=\"motdepasse\"></td>";
    echo "</tr>\n";
    echo '<tr><td>'.LANGUE.'</td>';
    echo '<td><select name="langue">';
    $liste_langues = lire_liste_langues();
    for ($i = 0; $i < count($liste_langues); $i++) {
        $nom = $liste_langues[$i];
        if ($nom == $langue)
            echo '<option value="'.$nom.'" selected>'.$nom.'</option>';
        else
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo "</select></td></tr>\n";
    echo "<tr>";
    echo "<td>".ADMINISTRATEUR."</td>";
    echo "<td><input type=\"checkbox\" name=\"status\" value=\"administrateur\"";
    if ($status == "administrateur")
        echo " checked";
    echo "></td>";
    echo "</tr>\n";
    echo "</table>\n";
    echo "<br>\n";
    echo "<p>";
    echo '<input type="hidden" class="texte" name="id" value="'.$id.'">'."\n";
    echo '<input type="reset" name="'.EFFACER.'" class="effacer">'."\n";
    echo '<input type="submit" name="'.CREER.'" class="valider">'."\n";
    echo "</p>\n";
    echo "</form>\n";
    echo "</div>\n"; // parametres_du_site
    
    echo '<p><a href="administration.php?page=administration_utilisateurs">'.RETOUR."</a></p>\n";
    
    fin_html();
}

// Modifie les paramètres d'un utilisateur à partir d'une requête POST
function action_modifier_parametres_utilisateur($lien_bdd) {
    
    if (!isset($_POST['login']) || !isset($_POST['prenom']) || !isset($_POST['nom']) || !isset($_POST['email']) ||
            !isset($_POST['motdepasse']) || !isset($_POST['id']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
        
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $id = $_POST['id'];
    verifie_id($id);
    $login = $_POST['login'];
    login_utilisateur($login);
    $prenom = $_POST['prenom'];
    prenom_utilisateur($prenom);
    $nom = $_POST['nom'];
    nom_utilisateur($nom);
    $email = $_POST['email'];
    if ($email != "")
        verifie_email($email);
    $langue = $_POST['langue'];
    verifie_langue($langue);
    
    $motdepasse = $_POST['motdepasse'];
    if ($motdepasse != "") {
        password_utilisateur($motdepasse);
        $motdepasse = md5($motdepasse);
    } else {
        $utilisateur = utilisateur($lien_bdd,$id);
        $motdepasse = $utilisateur['motdepasse'];
    }
    if (isset($_POST['status']) && $_POST['status'] == 'administrateur')
        $status = $_POST['status'];
    else
        $status = 'utilisateur';
    
    modifier_utilisateur($lien_bdd,$id, $prenom, $nom, $login, $status, $motdepasse, $langue, $email);
    page_modifier_utilisateur($lien_bdd,$id);
}

?>
