<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// ce fichier vérifie si la structure de la base de données est à jour
// nécessite base_de_donnees.php, et l'initialisation des strings et des erreurs


// renvoit true si la base de données est à jour, false sinon (auquel cas il faut probablement appeler maj_bdd)
function verif_bdd($lien_bdd) 
{
    if (verif_contributions1($lien_bdd) && verif_contributions2($lien_bdd) && verif_historiques($lien_bdd) && verif_demandes_inscription($lien_bdd) && verif_demandes_inscription2($lien_bdd) && verif_utilisateurs($lien_bdd) && verif_utilisateurs2($lien_bdd) && verif_projets_parents($lien_bdd) && verif_utilisateurs3($lien_bdd) && verif_connectes($lien_bdd) && verif_particiant_profile($lien_bdd))
        return true;
    return false;
}


function verif_contributions1($lien_bdd) {
    $requete = "SHOW COLUMNS FROM contributions";
    $resultat = executer_requete($requete, $lien_bdd);
    //$resultat = requete_modif($requete, $lien_bdd);
    $champs = lire_le_resultat($resultat, "Field");
    for ($i=0; $i<count($champs); $i++) {
        if ($champs[$i] == "nom") {
            return(true);
        }
        else if ($champs[$i] == "nom_contribution") {
            return(false);
        }
    }
    //erreur("impossible de vérifier la structure de la base de données");
}

function verif_contributions2($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "id_projet", "contributions"));
}

function verif_historiques($lien_bdd) {
    $base = $_SESSION['nom_base_de_donnes'];
    $requete = "SHOW TABLES FROM ".$base." LIKE 'historiques'";
    //sarra
    $resultat = executer_requete($requete, $lien_bdd);
    //$resultat = requete_modif($requete, $lien_bdd);
    if (!tester_resultat($resultat))
        erreur("impossible de vérifier la table historiques");
    if (lire_le_resultat($resultat)) {
        return(true);
    }
    return(false);
}

function verif_utilisateurs($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "langue", "utilisateurs"));
}

function verif_utilisateurs2($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "email", "utilisateurs"));
}

function verif_utilisateurs3($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "editeur", "utilisateurs"));
}

function verif_demandes_inscription($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "langue", "demandes_inscription"));
}

function verif_demandes_inscription2($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "email", "demandes_inscription"));
}

function verif_projets_parents($lien_bdd) {
    return(verif_champ_dans_table($lien_bdd, "id_projet_parent", "projets"));
}

function verif_connectes($lien_bdd)
{
	$base = $_SESSION['nom_base_de_donnes'];
    $requete = "SHOW TABLES FROM ".$base." LIKE 'connectes'";
    //sarra
    $resultat = executer_requete($requete, $lien_bdd);
    if (lire_le_resultat($resultat)) 
        return(true);
    else
		return(false);
}
function verif_particiant_profile($lien_bdd)
{
	return(verif_champ_dans_table($lien_bdd,"id_profile","participants"));
}

function verif_champ_dans_table($lien_bdd, $champ, $table) {
    $requete = "SHOW COLUMNS FROM $table";
    //sarra
    $resultat = executer_requete($requete, $lien_bdd);
    //$resultat = requete_modif($requete, $lien_bdd);
    if (!tester_resultat($resultat))
        erreur("impossible de vérifier la structure de la base de données");
    $champs = lire_le_resultat($resultat, "Field");
    for ($i=0; $i<count($champs); $i++) {
        if ($champs[$i] == $champ) {
            return(true);
        }
    }
    return(false);
}


// met à jour la structure de la base de données
function maj_bdd() {
    $lien_bdd = false;
    
    // en cas de modification, mettre à jour les requetes dans le fichier installation/creation_bdd.php
    if (!verif_demandes_inscription($lien_bdd))
        requete_modif("ALTER TABLE demandes_inscription ADD COLUMN langue char(3) NOT NULL;", $lien_bdd);
    if (!verif_demandes_inscription2($lien_bdd))
        requete_modif("ALTER TABLE demandes_inscription ADD COLUMN email varchar(50) NOT NULL;", $lien_bdd);
        
    if (!verif_utilisateurs($lien_bdd)) {
        requete_modif("ALTER TABLE utilisateurs ADD COLUMN langue char(3) NOT NULL;", $lien_bdd);
        $liste_utilisateurs = liste_des_utilisateurs();
        if ($liste_utilisateurs != FALSE) {
            for($i=0; $i<count($liste_utilisateurs); $i++) {
                $utilisateur = $liste_utilisateurs[$i];
                $id = $utilisateur['id'];
                modifier_utilisateur($lien_bdd,$id, false, false, false, false, false, $_SESSION['langue'], false);
            }
        }
    }
    if (!verif_utilisateurs2($lien_bdd)) {
        requete_modif("ALTER TABLE utilisateurs ADD COLUMN email varchar(50) NOT NULL;", $lien_bdd);
        $prevenir_ajout_email = true;
    } else
        $prevenir_ajout_email = false;
     
    if (!verif_historiques($lien_bdd))
        requete_modif("CREATE TABLE historiques (id_contribution int(6) NOT NULL, id_utilisateur int(5) NOT NULL, dossier_historique varchar(16) NOT NULL)", $lien_bdd);
        
     if(!verif_connectes($lien_bdd))  
		requete_modif("CREATE TABLE connectes (login_connecte varchar(16) NOT NULL, timestamp bigint(16) NOT NULL, dernier_timestamp bigint(16) NOT NULL) CHARACTER SET utf8",$lien_bdd);
    
    // si nécessaire : ALTER TABLE contributions ADD config VARCHAR(20) NOT NULL;
    // suivi de : UPDATE contributions SET config="$_SESSION['chemin_configuration_jaxe']";
    if (!verif_contributions1($lien_bdd)) {
        // vérif des liens
        $requete = "SELECT contributeurs.login FROM contributeurs LEFT JOIN utilisateurs ON contributeurs.login=utilisateurs.login WHERE utilisateurs.login IS NULL";
        $resultat = executer_requete($requete, $lien_bdd);
        if (nombre_de_lignes($resultat) > 0) {
            $table = lire_le_resultat($resultat, 'login');
            $liste = "";
            for ($i=0; $i<count($table); $i++)
                $liste .= ' '.$table[$i];
            erreur('bdd incohérente: contributeurs.login non trouvés dans la table utilisateurs: '.$liste);
        }
        
        // nettoyage de edition_contributions
        requete_modif("DELETE edition_contributions.* FROM edition_contributions LEFT JOIN contributions ON contributions.nom_contribution=edition_contributions.nom_contribution WHERE contributions.nom_contribution IS NULL", $lien_bdd);
        
        // modifs structure
        requete_modif("ALTER TABLE contributions CHANGE COLUMN nom_contribution nom varchar(30) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE contributeurs DROP COLUMN id;", $lien_bdd);
        requete_modif("ALTER TABLE contributeurs CHANGE COLUMN id_projet id_contribution int(6) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE contributeurs ADD COLUMN id_utilisateur int(5) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE edition_contributions ADD COLUMN id_utilisateur int(5) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE edition_contributions ADD COLUMN id_contribution int(6) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE edition_contributions DROP PRIMARY KEY;", $lien_bdd);
        
        requete_modif("UPDATE contributeurs, utilisateurs SET contributeurs.id_utilisateur=utilisateurs.id WHERE utilisateurs.login=contributeurs.login", $lien_bdd);
        
        requete_modif("UPDATE edition_contributions, utilisateurs SET edition_contributions.id_utilisateur=utilisateurs.id WHERE utilisateurs.login=edition_contributions.login_utilisateur", $lien_bdd);
        
        requete_modif("UPDATE edition_contributions, contributions SET edition_contributions.id_contribution=contributions.id WHERE contributions.nom=edition_contributions.nom_contribution", $lien_bdd);
        
        requete_modif("ALTER TABLE contributeurs DROP COLUMN login;", $lien_bdd);
        requete_modif("ALTER TABLE edition_contributions DROP COLUMN login_utilisateur;", $lien_bdd);
        requete_modif("ALTER TABLE edition_contributions DROP COLUMN nom_contribution;", $lien_bdd);
    }
    
    if (!verif_contributions2($lien_bdd)) {
        requete_modif("CREATE TABLE projets (id int(5) NOT NULL auto_increment, titre varchar(40) NOT NULL, PRIMARY KEY (id) )", $lien_bdd);
        requete_modif("CREATE TABLE participants (id_utilisateur int(5) NOT NULL, id_projet int(5) NOT NULL,id_profile int(5) NOT NULL)", $lien_bdd);
        requete_modif("ALTER TABLE contributions ADD COLUMN id_projet int(5) NOT NULL;", $lien_bdd);
        requete_modif("ALTER TABLE contributions ADD COLUMN id_dernier_utilisateur int(5);", $lien_bdd);
        requete_modif("ALTER TABLE contributions ADD COLUMN date_edition DATETIME;", $lien_bdd);
        requete_modif("UPDATE contributions, edition_contributions SET contributions.id_dernier_utilisateur=edition_contributions.id_utilisateur WHERE edition_contributions.id_contribution=contributions.id", $lien_bdd);
        requete_modif("UPDATE contributions, edition_contributions SET contributions.date_edition=edition_contributions.date WHERE edition_contributions.id_contribution=contributions.id", $lien_bdd);
        
        
        $no_projet = 1;
        $requete = "SELECT id FROM contributions";
        $resultat_requete = executer_requete($requete, $lien_bdd);
        if (!tester_resultat($resultat_requete)) {
            erreur(REQUETE_LISTE_CONTRIBUTION);
        }
        $liste_contributions = lire_le_resultat($resultat_requete, 'id');
        
        if ($liste_contributions != FALSE) {
            // pour chaque contribution
            for ($i=0; $i<count($liste_contributions); $i++) {
                $id_contribution = $liste_contributions[$i];
                $requete ="SELECT id_utilisateur FROM contributeurs WHERE id_contribution='$id_contribution' ORDER BY id_utilisateur";
                $resultat_requete = executer_requete($requete, $lien_bdd);
                if (!tester_resultat($resultat_requete)) {
                    erreur(ECHEC_REQUETE.' '.$requete);
                }
                $liste_utilisateurs_contrib = lire_le_resultat($resultat_requete, 'id_utilisateur');
                
                // recherche d'un projet avec les mêmes utilisateurs
                $trouve = false;
                $requete ="SELECT id FROM projets";
                $resultat_requete = executer_requete($requete, $lien_bdd);
                if (!tester_resultat($resultat_requete)) {
                    erreur(ECHEC_REQUETE.' '.$requete);
                }
                $liste_projets = lire_le_resultat($resultat_requete, 'id');
                for ($j=0; $j<count($liste_projets); $j++) {
                    $id_projet = $liste_projets[$j];
                    $requete ="SELECT id_utilisateur FROM participants WHERE id_projet='$id_projet' ORDER BY id_utilisateur";
                    $resultat_requete = executer_requete($requete, $lien_bdd);
                    if (!tester_resultat($resultat_requete)) {
                        erreur(ECHEC_REQUETE.' '.$requete);
                    }
                    $liste_utilisateurs_projet = lire_le_resultat($resultat_requete, 'id_utilisateur');
                    if ($liste_utilisateurs_contrib == $liste_utilisateurs_projet) {
                        $trouve = true;
                        break;
                    }
                }
                if (!$trouve) {
                    // création d'un nouveau projet
                    requete_modif("INSERT INTO projets (titre) VALUES ('projet $no_projet')", $lien_bdd);
                    $id_projet = dernier_id($lien_bdd);
                    requete_modif("INSERT INTO participants (id_utilisateur, id_projet) SELECT contributeurs.id_utilisateur, '$id_projet' FROM contributeurs WHERE id_contribution='$id_contribution'", $lien_bdd);
                    requete_modif ("UPDATE participants set id_profile = 1", $lien_bdd );
                    $no_projet = $no_projet + 1;
                }
                // ajout du lien
                requete_modif("UPDATE contributions SET id_projet='$id_projet' WHERE id='$id_contribution'", $lien_bdd);
            }
        }
        requete_modif("DROP table edition_contributions;", $lien_bdd);
        requete_modif("DROP table contributeurs;", $lien_bdd);
    }
    if (!verif_projets_parents($lien_bdd)) {
        requete_modif("ALTER TABLE projets ADD COLUMN id_projet_parent int(5);", $lien_bdd);
    }
    if (!verif_utilisateurs3($lien_bdd)) {
        requete_modif("ALTER TABLE utilisateurs ADD COLUMN editeur char(4) NOT NULL;", $lien_bdd);
    }
    
    if(!verif_particiant_profile($lien_bdd))
    {
		requete_modif("ALTER TABLE participants ADD COLUMN id_profile int(5);", $lien_bdd);
		requete_modif ("UPDATE participants set id_profile = 1", $lien_bdd ); 
	}
    
    
    debut_html(PARAMETRE_WEBJAXE, PARAMETRE_WEBJAXE);
    echo '<p>'.BDD_MAJ.'</p>';
    if ($prevenir_ajout_email)
        echo '<p>'.FAUT_AJOUTER_EMAIL.'</p>';
    echo '<p><a href="partie_administrateur/administration.php?page=accueil">Continuer</a></p>';
    fin_html();
}


function requete_modif($requete, $lien_bdd) {
    if (!tester_resultat(executer_requete($requete, $lien_bdd))) 
    {
        erreur(ECHEC_REQUETE." (".$requete.")");
        $requete = null;
    }
    $requete = null;
}

?>
