<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();


if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__)."/../include/base_de_donnees.php");
require_once(dirname(__FILE__).'/../include/projets.php');
require_once(dirname(__FILE__)."/../include/contributions.php");
require_once(dirname(__FILE__)."/../include/fichier.php");
require_once(dirname(__FILE__)."/../include/lecture_config.php");
require_once(dirname(__FILE__)."/../include/outils.php");
require_once(dirname(__FILE__)."/../include/tete_pied.php");
require_once(dirname(__FILE__)."/../include/utilisateurs.php");
require_once(dirname(__FILE__)."/../include/verification_noms.php");
require_once(dirname(__FILE__)."/accueil_administration.php");
require_once(dirname(__FILE__)."/parametres_du_site.php");
require_once(dirname(__FILE__)."/gestion_des_contributions.php");
require_once(dirname(__FILE__)."/administration_utilisateurs.php");
require_once(dirname(__FILE__)."/administration_projets.php");
require_once(dirname(__FILE__)."/modifier_utilisateur.php");
require_once(dirname(__FILE__)."/participants_projet.php");
require_once(dirname(__FILE__)."/sous_projets.php");
require_once(dirname(__FILE__)."/projets_utilisateur.php");
require_once(dirname(__FILE__)."/projet_contribution.php");
require_once(dirname(__FILE__)."/modifier_projet.php");
require_once(dirname(__FILE__)."/renommer_contribution.php");
require_once(dirname(__FILE__)."/confirmation.php");
require_once(dirname(__FILE__)."/utilisateurs_connectes.php");
require_once(dirname(__FILE__).'/../include/pclzip.lib.php');
require_once(dirname(__FILE__)."/../include/email.php");
require_once(dirname(__FILE__)."/../include/connectes.php");


init_erreurs();

$_SESSION['section'] = 'administrateur';


if (!isset($_SESSION['id_utilisateur']))
    erreur(PAS_DE_SESSION);

if ($_SESSION['status'] != 'administrateur')
    erreur(PAS_AUTORISE);
    
  
$lien_bdd = connexion();
utilisateur_connecte($lien_bdd);

if (isset($_GET['page'])) {
    if ($_GET['page'] == 'accueil')
        page_accueil();
    else if ($_GET['page'] == 'parametres_du_site')
        page_parametres_du_site();
    else if ($_GET['page'] == 'gestion_des_contributions') 
    {
        if (isset($_GET['id_projet'])) 
        {
            verifie_id($_GET['id_projet']);
            page_gestion_des_contributions($lien_bdd,$_GET['id_projet']);
        } else
            page_gestion_des_contributions($lien_bdd);
    } else if ($_GET['page'] == 'administration_utilisateurs')
        page_administration_utilisateurs($lien_bdd);
    else if ($_GET['page'] == 'administration_projets')
        page_administration_projets($lien_bdd);
    else if ($_GET['page'] == 'modifier_utilisateur') {
        if (!isset($_GET['id']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id']);
        page_modifier_utilisateur($lien_bdd,$_GET['id']);
    } else if ($_GET['page'] == 'participants_projet') {
        if (!isset($_GET['id_projet']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_projet']);
        page_participants_projet($lien_bdd,$_GET['id_projet']);
    } else if ($_GET['page'] == 'sous_projets') {
        if (!isset($_GET['id_projet']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_projet']);
        page_sous_projets($lien_bdd,$_GET['id_projet']);
    } else if ($_GET['page'] == 'projets_utilisateur') {
        if (!isset($_GET['id_utilisateur']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_utilisateur']);
        page_projets_utilisateur($lien_bdd,$_GET['id_utilisateur']);
    } else if ($_GET['page'] == 'projet_contribution') {
        if (!isset($_GET['id_contribution']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        page_projet_contribution($lien_bdd,$_GET['id_contribution']);
    } else if ($_GET['page'] == 'modifier_projet') {
        if (!isset($_GET['id_projet']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_projet']);
        page_modifier_projet($lien_bdd,$_GET['id_projet']);
    } else if ($_GET['page'] == 'renommer_contribution') {
        if (!isset($_GET['id_contribution']) || !isset($_GET['id_projet']))
            erreur(PARAMETRES_MANQUANT);
        verifie_id($_GET['id_contribution']);
        verifie_id($_GET['id_projet']);
        page_renommer_contribution($lien_bdd,$_GET['id_contribution'], $_GET['id_projet']);
    } else if ($_GET['page'] == 'confirmation') {
        if (isset($_GET['id_contribution'])) {
            verifie_id($_GET['id_contribution']);
            if (isset($_GET['id_projet'])) {
                verifie_id($_GET['id_projet']);
                page_confirmation($lien_bdd,$_GET['id_projet'], $_GET['id_contribution']);
            }
            else
                page_confirmation($lien_bdd,false, $_GET['id_contribution']);
        } else if (isset($_GET['id_projet'])) {
            verifie_id($_GET['id_projet']);
            page_confirmation($lien_bdd,$_GET['id_projet']);
        } else
            erreur(PARAMETRES_MANQUANT);
    } else if ($_GET['page'] == 'utilisateur_connectes')
    {
		page_utilisateurs_connectes($lien_bdd);
	}else
        erreur('Page inconnue');
    
} else if (isset($_GET['action'])) {
    if ($_GET['action'] == 'supprimer_contribution')
        action_supprimer_contribution($lien_bdd);
    else if ($_GET['action'] == 'supprimer_utilisateur')
        action_supprimer_utilisateur($lien_bdd);
    else if ($_GET['action'] == 'supprimer_projet')
        action_supprimer_projet($lien_bdd);
    else
        erreur('Action inconnue');
    
} else if (isset($_POST['action'])) {
    if ($_POST['action'] == 'ajouter_projet')
        action_ajouter_projet($lien_bdd);
    else if ($_POST['action'] == 'importer_projet')
        action_importer_projet($lien_bdd);
    else if ($_POST['action'] == 'changement_parametres_site')
        action_changement_parametres_site();
    else if ($_POST['action'] == 'desinstallation')
        action_desinstallation();
    else if ($_POST['action'] == 'ajout_contribution')
        action_ajout_contribution($lien_bdd);
    else if ($_POST['action'] == 'import_contribution')
        action_import_contribution($lien_bdd);
    else if ($_POST['action'] == 'ajouter_participant')
        action_ajouter_participant($lien_bdd);
   else if ($_POST['action'] == 'supprimer_participant')
        action_supprimer_participant($lien_bdd);
    else if ($_POST['action'] == 'ajouter_sous_projet')
        action_ajouter_sous_projet($lien_bdd);
    else if ($_POST['action'] == 'supprimer_sous_projet')
        action_supprimer_sous_projet($lien_bdd);
    else if ($_POST['action'] == 'modifier_parametres_utilisateur')
        action_modifier_parametres_utilisateur($lien_bdd);
    else if ($_POST['action'] == 'ne_pas_autoriser')
        action_ne_pas_autoriser($lien_bdd);
    else if ($_POST['action'] == 'creation_compte_definitif')
        action_creation_compte_definitif($lien_bdd);
    else if ($_POST['action'] == 'ajouter_lien_projet')
        action_ajouter_lien_projet($lien_bdd);
    else if ($_POST['action'] == 'supprimer_modifier_lien_projet')
    {
		if (isset($_POST['supprimer_lien_projet']))
			action_supprimer_lien_projet($lien_bdd);
		else if(isset($_POST['modifier_droit_projet']))
			action_modifier_droit_projet($lien_bdd);
	}
     
    else if ($_POST['action'] == 'modifier_projet_contribution')
        action_modifier_projet_contribution($lien_bdd);
    else if ($_POST['action'] == 'modifier_projet')
        action_modifier_projet($lien_bdd);
    else if ($_POST['action'] == 'renommer_contribution')
        action_renommer_contribution($lien_bdd);
    else
        erreur('Action inconnue');
} else {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && empty($_POST) && empty($_FILES) && $_SERVER['CONTENT_LENGTH'] > 0)
        erreur(ERR_TAILLE_MAX_POST);
    erreur(PARAMETRES_MANQUANT);
}


?>
