<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

//sarra add: confedit.class.php
require_once(dirname(__FILE__)."/../../site_config/confedit.class.php");

// crée la base de données à partir de la requête POST
// nécessite tete_pied.php, lecture_config.php, verification_noms.php, base_de_donnees.php, et l'initialisation des strings et des erreurs
function creation_bdd() {

    if (!isset($_POST['chemin_configuration_jaxe']) || !isset($_POST['langue']) ||
        !isset($_POST['serveur']) || !isset($_POST['base']) ||
        !isset($_POST['utilisateur']) || !isset($_POST['mot_de_passe']) || !isset($_POST['login_admin']) ||
        !isset($_POST['nom_admin']) || !isset($_POST['prenom_admin']) || !isset($_POST['passwd_admin']) ||
        !isset($_POST['choix_du_mail']) || !isset($_POST['nom_du_serveur_smtp']) || !isset($_POST['jeton']))
        erreur(PARAMETRES_MANQUANT);
    
    if(!comparerJeton($_POST['jeton']))
        erreur(JETON_INVALIDE);
    
    $sep = DIRECTORY_SEPARATOR;
    
   
    //lire_fichier_configuration("..".$sep."..".$sep."site_config".$sep."site_config.xml");
    $config = new ConfigEditor();
    $config_file = dirname(__FILE__).$sep."..".$sep."..".$sep."site_config".$sep."config.php";
    lire_fichier_configuration($config_file);
    
    $chemin_configuration_jaxe = $_POST['chemin_configuration_jaxe'];
    $_SESSION['chemin_configuration_jaxe'] = $chemin_configuration_jaxe;
    $langue = $_POST['langue'];
    $_SESSION['langue'] = $langue;
    $serveur = $_POST['serveur'];
    $base = $_POST['base'];
    $utilisateur = $_POST['utilisateur'];
    $mot_de_passe = $_POST['mot_de_passe'];
    $login_administrateur = $_POST['login_admin'];
    $nom_administrateur = $_POST['nom_admin'];
    $prenom_administrateur = $_POST['prenom_admin'];
    $passwd_administrateur = $_POST['passwd_admin'];
    $email_admin = $_POST['email_admin'];
    $choix_du_mail = $_POST['choix_du_mail'];
    $nom_du_serveur_smtp = $_POST['nom_du_serveur_smtp'];
    
    nom_utilisateur($nom_administrateur);
    prenom_utilisateur($prenom_administrateur);
    login_utilisateur($login_administrateur);
    password_utilisateur($passwd_administrateur);
    if (isset($_POST['email_admin']))
        verifie_email($email_admin);
        
    // Enregistrement du fichier de configuration de WebJaxe
    
    editer_fichier_config($config,$config_file,$chemin_configuration_jaxe, $_SESSION['chemin_dossier_apercu'], $serveur, $base, $utilisateur, $mot_de_passe, $langue, $email_admin, $choix_du_mail, $nom_du_serveur_smtp);
    
    $_SESSION['serveur_base_de_donnes'] = $serveur;
    $_SESSION['login_base_de_donnes'] = $utilisateur;
    $_SESSION['pass_base_de_donnes'] = $mot_de_passe;
    $_SESSION['nom_base_de_donnes'] = $base;
    $_SESSION['serveur_db'] = "mysql:host=".$_SESSION['serveur_base_de_donnes'].";dbname=".$_SESSION['nom_base_de_donnes'];
    // Création de la base de données si nécessaire
    if (!tester_base())
       creer_base();

        
    
    // création des tables
    
    creer_table("CREATE TABLE projets (id int(5) NOT NULL auto_increment, titre varchar(40) NOT NULL, id_projet_parent int(5), PRIMARY KEY (id) ) CHARACTER SET utf8");
    
    creer_table("CREATE TABLE contributions (id int(6) NOT NULL auto_increment, nom varchar(30) NOT NULL, config varchar(20) NOT NULL, id_projet int(5) NOT NULL, id_dernier_utilisateur int(5), date_edition DATETIME, PRIMARY KEY (id) ) CHARACTER SET utf8");
    
    // en cas de modification, mettre à jour la requete dans le fichier partie_administrateur/maj_bdd.php
    creer_table("CREATE TABLE utilisateurs (id int(5) NOT NULL auto_increment, prenom varchar(20) NOT NULL, nom varchar(20) NOT NULL, login varchar(16) NOT NULL, status varchar(16) NOT NULL, motdepasse varchar(64) NOT NULL, langue char(3) NOT NULL, email varchar(50) NOT NULL, editeur char(4) NOT NULL, PRIMARY KEY (id) ) CHARACTER SET utf8");
    
    // en cas de modification, mettre à jour la requete dans le fichier partie_administrateur/maj_bdd.php
    creer_table("CREATE TABLE demandes_inscription (id int(5) NOT NULL auto_increment, prenom varchar(20) NOT NULL, nom varchar(20) NOT NULL, login varchar(16) NOT NULL, status varchar(16) NOT NULL, motdepasse varchar(64) NOT NULL, langue char(3) NOT NULL, email varchar(50) NOT NULL, PRIMARY KEY (id) ) CHARACTER SET utf8");
    
    creer_table("CREATE TABLE participants (id_utilisateur int(5) NOT NULL, id_projet int(5) NOT NULL, id_profile int(5) NOT NULL) CHARACTER SET utf8");
    
    // en cas de modification, mettre à jour la requete dans le fichier partie_administrateur/maj_bdd.php
    creer_table("CREATE TABLE historiques (id_contribution int(6) NOT NULL, id_utilisateur int(5) NOT NULL, dossier_historique varchar(16) NOT NULL) CHARACTER SET utf8");
    
   //en cas de modification, mettre à jour la requete dans le fichier partie_administrateur/maj_bdd.php
    creer_table("CREATE TABLE connectes (login_connecte varchar(16) NOT NULL, timestamp bigint(16) NOT NULL, dernier_timestamp bigint(16) NOT NULL) CHARACTER SET utf8");
    
    // Création du compte administrateur
    $result = executer_requete("INSERT INTO utilisateurs (`id` ,`prenom` ,`nom` ,`login`,`status` ,`motdepasse`, `langue`, `email`) VALUES ('0', '".$prenom_administrateur."', '".$nom_administrateur."', '".$login_administrateur."','administrateur', md5('".$passwd_administrateur."'), '".$langue."', '".$email_admin."')",false);
    
    if ( $result == FALSE )
        erreur(ERREUR_COMPTE_ADMINISTRATEUR);
    
    // Sortie HTML
    debut_html(INITIALISATION, INITIALISATION);
    
    echo "<p>".CREATION_BD_REUSSI."</p>\n";
    echo "<a href='../../'>".ACCUEIL."</a>\n";
    
    fin_html();
}

function creer_table($requete) {
    $result = executer_requete($requete,false);
    if ( $result == FALSE )
        erreur(ERREUR_CREATION_TABLE);
}

?>
